/*
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_CHANNEL_H__
#define __TPA_CHANNEL_H__

#include <dbus/dbus-glib.h>
#include <glib-object.h>

#include "tpa-handle.h"

#include <tapioca/base/tpa-enums.h>
#include <tapioca/base/tpa-errors.h>

G_BEGIN_DECLS

typedef struct _TpaIChannel TpaIChannel;

struct _TpaIChannel {
    GObjectClass parent_class;

    /* Virtual Methods */
    TpaError    (* close)                   (GObject *obj);
    TpaError    (* get_interfaces)          (GObject *obj,
                                             gchar ***ret);
    TpaChannelType type;
    TpaHandle *handle;
    gboolean closed;
};

/* TYPE MACROS */
#define TPA_TYPE_ICHANNEL \
    (tpa_channel_get_type ())
#define TPA_IS_ICHANNEL(obj) \
    (g_type_is_a (G_OBJECT_TYPE(obj), TPA_TYPE_ICHANNEL))
#define TPA_ICHANNEL(obj) \
    (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TPA_TYPE_ICHANNEL, TpaIChannel))

GType       tpa_channel_get_type                (void);
void        tpa_channel_init                    (TpaIChannel *iface,
                                                 gpointer data);
void        tpa_channel_finalize                (GObject *obj);
void        tpa_channel_signal_closed           (GObject *obj);

G_END_DECLS

#endif /* #ifndef __TPA_CHANNEL_H__*/
