/*
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_GROUP_PRIVATE_H__
#define __TPA_GROUP_PRIVATE_H__

gboolean        tpa_group_add_members           (GObject *obj,
                                                 const GArray *constants,
                                                 const gchar *message,
                                                 GError **error);
gboolean        tpa_group_remove_members        (GObject *obj,
                                                 const GArray *constants,
                                                 const gchar *message,
                                                 GError **error);
gboolean        tpa_group_get_all_members       (GObject *obj,
                                                 GArray **ret,
                                                 GArray **ret1,
                                                 GArray **ret2,
                                                 GError **error);
gboolean        tpa_group_get_group_flags       (GObject *obj,
                                                 guint *ret,
                                                 GError **error);
gboolean        tpa_group_get_handle_owners     (GObject *obj,
                                                 GArray *handles,
                                                 GArray **ret,
                                                 GError **error);
gboolean        tpa_group_get_local_pending_members
                                                (GObject *obj,
                                                 GArray **ret,
                                                 GError **error);
gboolean        tpa_group_get_members           (GObject *obj,
                                                 GArray **ret,
                                                 GError **error);
gboolean        tpa_group_get_remote_pending_members
                                                (GObject *obj,
                                                 GArray **ret,
                                                 GError **error);
gboolean        tpa_group_get_self_handle       (GObject *obj,
                                                 guint *ret,
                                                 GError **error);

#endif /* #ifndef __TPA_GROUP_PRIVATE_H__*/
