/*
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_PROPERTIES_H__
#define __TPA_PROPERTIES_H__

#include <tapioca/base/tpa-errors.h>

G_BEGIN_DECLS

typedef struct _TpaIProperties TpaIProperties;
typedef struct _TpaIPropertiesPrivate TpaIPropertiesPrivate;

struct _TpaIProperties {
    GTypeInterface parent;

    TpaError    (* get_properties)             (GObject *obj,
                                                const GArray *properties,
                                                GPtrArray **ret);
    TpaError    (* set_properties)             (GObject *obj,
                                                const GPtrArray *properties,
                                                DBusGMethodInvocation *context);
    TpaError    (* list_properties)            (GObject *obj,
                                                GPtrArray **ret);
    TpaIPropertiesPrivate *priv;
};

/* TYPE MACROS */
#define TPA_TYPE_IPROPERTIES \
    (tpa_properties_get_type ())
#define TPA_IS_IPROPERTIES(obj) \
    (g_type_is_a (G_OBJECT_TYPE(obj), TPA_TYPE_IPROPERTIES))
#define TPA_IPROPERTIES(obj) \
    (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TPA_TYPE_IPROPERTIES, TpaIProperties))

GType       tpa_properties_get_type             (void);
void        tpa_properties_init                 (TpaIProperties *iface,
                                                 gpointer data);
void        tpa_properties_finalize             (GObject *obj);
void        tpa_properties_signal_properties_changed
                                                (GObject *obj,
                                                 GPtrArray *properties);
void        tpa_properties_signal_properties_flags_changed
                                                (GObject *obj,
                                                 GPtrArray *properties);

G_END_DECLS

#endif /* #ifndef __TPA_PROPERTIES_H__*/
