/*
 * Tapioca library
 * Copyright (C) 2006 INdT.
 * @author Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <tapioca/tpa-base.h>
#include <tapioca/tpa-client.h>

#include <glib.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <getopt.h>
#include <signal.h>
#include <sys/types.h>

/* variables */
static GMainLoop *mainloop;
static TpaManagerFactory *factory;
static TpaManager *manager;
static TpaConnection *connection;
static TpaContactList *list;

static void status_changed_cb (TpaConnection *conn, guint status, guint reason);

void exit_program()
{
    /*do not disconnect */
    /*tpa_connection_disconnect(connection);*/
    g_main_loop_quit(mainloop);
    g_print("Finishing test...\n");
}

static void print_contacts (TpaConnection *conn)
{
    TpaUserContact *user;
    GPtrArray *contacts;
    TpaContact *contact;
    guint i;

    tpa_connection_get_open_channels(conn);
    user = tpa_connection_get_user_contact (conn);
    g_print ("changing status to away\n");
    tpa_user_contact_set_presence_with_message (user, TPA_PRESENCE_AWAY, "Away");
    list = tpa_connection_get_contactlist (conn);
    contacts = tpa_contact_list_get_subscribed (list);
    g_print ("contact list:\n");
    for (i = 0; i < contacts->len; i++) {
        contact = g_ptr_array_index (contacts, i);
        g_print ("\t%s\n", tpa_channel_target_get_uri (TPA_CHANNEL_TARGET (contact)));
    }
}

int main (int argc, char **argv)
{
    GPtrArray *connections;
    signal(SIGINT, exit_program);
    g_type_init ();
    mainloop = g_main_loop_new (NULL, FALSE);

    tpa_debug_set_flags_from_env ();

    factory = tpa_manager_factory_new ();

    if (!factory)
    {
        g_print("failed to create Connection Manager Factory!\n");
        exit(1);
    }

    manager = tpa_manager_factory_get_manager (factory, "jabber");

    if (!manager)
    {
        g_print("failed to create Connection Manager!\n");
        exit(1);
    }

    connections = tpa_manager_get_connections (manager);
    if (!connections->len) {
        g_print("no connetions available!\n");
        exit(1);
    }

    connection = g_ptr_array_index (connections, 0);

    if(!connection)
    {
        g_print("failed to create Connection!\n");
        exit(1);
    }

    /* Set up connection callbacks */
    g_signal_connect (G_OBJECT (connection), "status-changed", G_CALLBACK (status_changed_cb), NULL);

    if (tpa_connection_get_status(connection) == TPA_CONNECTION_STATUS_CONNECTED)
        print_contacts(connection);

    g_main_loop_run(mainloop);
    return 0;
}

static void
status_changed_cb (TpaConnection *conn,
                   guint status,
                   guint reason)
{
    g_print("state-changed status: %d, reason: %d\n", status, reason);
    if(status == TPA_CONNECTION_STATUS_CONNECTED)
    {
        TpaUserContact *user = NULL;
        GPtrArray *contacts = NULL;
        TpaContact *contact = NULL;
        guint i;

        g_print ("Connected!\nProtocol: %s\n", tpa_connection_get_protocol(conn));
        g_print ("Status: %d\n", tpa_connection_get_status(conn));

        tpa_connection_get_open_channels(conn);
        user = tpa_connection_get_user_contact (conn);
        g_print ("changing status to away\n");
        tpa_user_contact_set_presence_with_message (user, TPA_PRESENCE_AWAY, "Away");
        list = tpa_connection_get_contactlist (conn);
        contacts = tpa_contact_list_get_subscribed (list);
        g_print ("contact list:\n");
        for (i = 0; i < contacts->len; i++) {
            contact = g_ptr_array_index (contacts, i);
            g_print ("\t%s\n", tpa_channel_target_get_uri (TPA_CHANNEL_TARGET (contact)));
        }
    }
    if(status == TPA_CONNECTION_STATUS_DISCONNECTED)
    {
        g_print("Disconnected. Finninshing test...\n");
        g_main_loop_quit(mainloop);
    }
}

