/*
 * Telapathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 * 
 * ti-page-channel-text.h:
 * A GtkNotebook page exposing org.freedesktop.Telepathy.Channel.Type.Text
 * functionality.
 * 
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */
 
#ifndef __TI_PAGE_CHANNEL_TEXT_H__
#define __TI_PAGE_CHANNEL_TEXT_H__

#include <gtk/gtk.h>
#include <glib-object.h>

#include "ti-channel.h"
#include "ti-page.h"

/*
 * Type macros.
 */

typedef struct _TIPageChannelText TIPageChannelText;
typedef struct _TIPageChannelTextClass TIPageChannelTextClass;

#define TI_TYPE_PAGE_CHANNEL_TEXT               ti_page_channel_text_get_type()
#define TI_PAGE_CHANNEL_TEXT(object)            (G_TYPE_CHECK_INSTANCE_CAST ((object), TI_TYPE_PAGE_CHANNEL_TEXT, TIPageChannelText))
#define TI_PAGE_CHANNEL_TEXT_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), TI_TYPE_PAGE_CHANNEL_TEXT, TIPageChannelTextClass))
#define TI_IS_PAGE_CHANNEL_TEXT(object)         (G_TYPE_CHECK_INSTANCE_TYPE ((object), TI_TYPE_PAGE_CHANNEL_TEXT))
#define TI_IS_PAGE_CHANNEL_TEXT_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), TI_TYPE_PAGE_CHANNEL_TEXT))
#define TI_PAGE_CHANNEL_TEXT_GET_CLASS(object)  (G_TYPE_INSTANCE_GET_CLASS ((object), TI_TYPE_PAGE_CHANNEL_TEXT, TIPageChannelTextClass))

struct _TIPageChannelText {
    TIPage parent;
};

GType ti_page_channel_text_get_type (void);

TIPageChannelText* ti_page_channel_text_new (GtkNotebook* parent_notebook, TIChannel* channel);

#endif
