#! /bin/sh
# Usage:  update TARGET NEW 
#    Update TARGET file if its contents is different from NEW file.
#    If the their contents are the same, timestamp of TARGET file
#    never changed. 
#
#    NOTE 1: NEW file is deleted if two files are the same.
#    NOTE 2: TARGET file is deleted if two files are not the same.

EXEC=0

case X-$1 in
  X--x)
    shift
    EXEC=1
    ;;
esac

TARGET=$1
NEW=$2

if [ ! -f $NEW ] ; then
  echo "Not found: $NEW"
  exit 1;
fi

if cmp -s $TARGET $NEW 2>/dev/null; then 
  rm -f $NEW;
  echo "$TARGET is unchanged";
else
  rm -f $TARGET; 
  mv -f $NEW $TARGET;
  case $EXEC in
  1)
    chmod a+x $TARGET
    ;;
  esac
  echo "$TARGET is created"; 
fi
