/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dirs.H"
#include "ConfigFile.H"
#include "commonElements.H"
#include <wx/string.h>

UrlFile::UrlFile (const wxString& url) {
  if (url.Length() > 0) {
    wxURL u(wxURL::ConvertFromURI(url));
    Init(u);
  }
}

UrlFile::UrlFile (wxURL& url) {
  Init(url);
}

void UrlFile::operator= (const UrlFile& input) {
  this->protocol = input.protocol;
  this->server = input.server;
  this->setCharset(input.getCharset());
  this->setFullPath(input.getFullPath());
}

void UrlFile::Init (wxURL& url) {
  this->protocol = url.GetProtocolName();
  if (this->protocol == _T("file")) {
    this->path.Assign(UrlToFileName(url.GetURL()));
  } else {
    this->server = url.GetHostName();
    setFullPath(wxURL::ConvertFromURI(url.GetPath()));
  }
}

wxURL* UrlFile::getURL () const {
  return new wxURL(wxURL::ConvertFromURI(getURLstr()));
}

wxString UrlFile::getURLstr () const {
  if(this->protocol.Length() == 0 ||
     this->protocol == _T("file")) {
    if (getFullPath(true).Length() > 0) {
      return FileNameToUrl(this->path);
    } else {
      return _T("");
    }
  } else {
    if (this->server.Length() > 0) {
      return this->protocol + wxString(_T("://"))
		     + this->server
         + wxURL::ConvertToValidURI(getFullPath(true));
    } else {
      return _T("");
    }
  }
}

wxString UrlFile::getFullPath (bool urltype) const {
  if (urltype) {
    return toUrlType(this->path.GetFullPath());
  } else {
    return this->path.GetFullPath();
  }
};

void UrlFile::setFullPath (const wxString& path, bool urltype) {
  if (urltype) {
    this->path.Assign(fromUrlType(path));
  } else {
    this->path.Assign(path);
  }
};

wxString UrlFile::toUrlType (const wxString& fullpath) {
  wxString retval(fullpath);
  retval.Replace(wxString(wxFileName::GetPathSeparator()).c_str(),wxString(_T("/")));
  return retval;
}

wxString UrlFile::fromUrlType (const wxString& fullpath) {
  wxString retval(fullpath);
  retval.Replace(wxString(_T("/")),wxString(wxFileName::GetPathSeparator()).c_str());
  return retval;
}

wxString UrlFile::FileNameToUrl (const wxFileName& filename) {
  wxString retval(_T("file:"));
#ifdef __WXMSW__
  /* Actually, a '/' should be in front of it but
   * it does not work this way (wxWindows-2.4.2)
   * and that's why wxFileSys::FileNameToURL fails.
   */
  retval += wxURL::ConvertToValidURI(filename.GetVolume()+ wxFileName::GetVolumeSeparator());
#endif
  retval += wxURL::ConvertToValidURI(filename.GetFullPath(wxPATH_UNIX));
  return retval;
}

wxFileName UrlFile::UrlToFileName (const wxString& url) {
  wxString fullpath = wxURL::ConvertFromURI(url.Mid(wxString(_T("file:")).Len()));
#ifdef __WXMSW__
  if (fullpath.compare(0,2,wxString(_T("//"))) == 0) {
    fullpath = fullpath.Mid(2);
  }
#endif
  return wxFileName(fullpath);
}

wxString UrlFile:: getCharset () const {
  if (this->charset.Len()) {
    return this->charset;
  } else {
    return _T("UTF-8");
  }
}

LessonPath::LessonPath ()
  : UrlFile(TtConfigFile::getPtr()->getDataBaseUrl())
{
}

LangDir::LangDir ()
  : wxFileName(wxString::FromAscii(LANGDIR),_T(""))
{
}
