/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "header.h"

/******************** MODES *********************************/

#define MAX_MODES 9

gint mode;
char mode_str[EQSO_LEN];

char *mode_msg[]={
    "unspecified",
    "SSB",
    "CW",
    "SSBs CWr",
    "CWs SSBr",
    "AM",
    "FM",
    "RTTY",
    "SSTV",
    "ATV"   /* 9 */
};

void mode_func (struct terminal *term, void *amode, void *d){
    int active;

    active=(vint)amode;
    if (active<0 || active>MAX_MODES) return;
    mode = active;
    safe_strncpy0(mode_str,mode_msg[mode],EQSO_LEN);
    /*safe_strncpy0(mode_str,_(CTEXT(T_QP0+qsop_method),term),MAX_STR_LEN);*/
    redraw_later(term);
}

int dlg_mode(struct dialog_data *dlg, struct dialog_item_data *di){
    int i, sel;
    struct menu_item *mi;
    
    if (!(mi = new_menu(1))) return 0;
    for (i = 1; i <= MAX_MODES; i++) {
        add_to_menu(&mi, mode_msg[i], "", "", MENU_FUNC mode_func, (void *)(vint)i, 0);
    }
    sel = mode-1;
    if (sel < 0) sel = 0;
    if (sel>=MAX_MODES) sel=0;
    do_menu_selected(term, mi, (void*)(vint)mode, sel);
    return 0;
}

/******************** EDIT QSO *******************************/

char callsign[EQSO_LEN], rstr[EQSO_LEN], qsonrr[EQSO_LEN], exc[EQSO_LEN], locator[EQSO_LEN];
/*gint mode;
char mode_str[EQSO_LEN]*/
char rsts[EQSO_LEN], qsonrs[EQSO_LEN];
char date_str[EQSO_LEN], time_str[EQSO_LEN], operator[EQSO_LEN], remark[MAX_STR_LEN]; 
gint qerror,qsl;

#define OEQSO_LEN 24
char ocallsign[OEQSO_LEN], orstr[OEQSO_LEN], oqsonrr[OEQSO_LEN], oexc[OEQSO_LEN], olocator[OEQSO_LEN];
char omode_str[OEQSO_LEN], orsts[OEQSO_LEN], oqsonrs[OEQSO_LEN];
char odate_str[OEQSO_LEN], otime_str[OEQSO_LEN], ooperator[OEQSO_LEN], oremark[MAX_STR_LEN]; 

char oomode_str[OEQSO_LEN], oorstr[OEQSO_LEN], oorsts[OEQSO_LEN];

void refresh_edit_qso(struct qso *q)
{

    
/*    dbg("refresh_edit_qso\n");*/
    dump_qso(q, "refresh_edit_qso before");
    if ((strcmp(rstr,oorstr) || strcmp(rsts,oorsts)) &&
         !strcmp(mode_str,oomode_str)){

            if (mode == MOD_SSB_SSB ||
                mode == MOD_CW_SSB ||
                mode == MOD_SSB_CW ||
                mode == MOD_CW_CW){
                
                int s,r;
                /* CHANGE menu2.c refresh_edit_qso */
                s=strlen(rsts);
                r=strlen(rstr);
                if (s==3 && r==3) mode=MOD_CW_CW;
                if (s==2 && r==2) mode=MOD_SSB_SSB;
                if (s==3 && r==2) mode=MOD_CW_SSB;
                if (s==2 && r==3) mode=MOD_SSB_CW;
            }
    }
            

    STORE_STR_FS_UC(q,operator);
    STORE_STR_FS   (q,date_str);
    STORE_STR_FS   (q,time_str);
    STORE_STR_FS_UC(q,callsign);
    STORE_INT      (q,mode);
    STORE_STR_FS   (q,rsts);
    STORE_STR_FS   (q,rstr);
    STORE_STR_FS   (q,qsonrr);
    STORE_STR_FS   (q,exc);
    STORE_STR_FS_UC(q,locator);
    STORE_STR_FS   (q,remark);
    q->error = qerror;
    q->qsl   = qsl;


    q->stamp = time(NULL);
    g_hash_table_foreach(ctest->bystamp, foreach_source_qsort_by_stamp, NULL);
   
    compute_qrbqtf(q);
    DIRTY_BAND(aband);
    write_qso_to_swap(aband, q);
    replicate_qso(NULL, q);
    recalc_stats(aband->stats, aband);
    check_autosave();
#ifdef HAVE_SDL
	gfx_reload(gfx);
#endif	
    dump_qso(q, "refresh_edit_qso after");
    dump_all_sources(ctest);
}                    

char *edit_qso_msg[] = {
    ocallsign, /* 0 */
    orstr    ,
    oqsonrr  ,
    oexc     ,
    olocator ,
    omode_str, /* 5 */
    orsts    ,
    /*oqsonrs  ,*/
    odate_str,
    otime_str,
    ooperator, 
    oremark  , /* 10 */
    CTEXT(T_ERROR),
    CTEXT(T_QSL),
    "", /* OK */  /* 13 */
    "", /* Cancel */
};


void edit_qso_fn(struct dialog_data *dlg)
{
    struct terminal *term = dlg->win->term;
    int max = 0, min = 0;
    int w, rw;
    int y = -1;

    max_group_width(term, edit_qso_msg + 0 , dlg->items + 0, 1, &max);
    min_group_width(term, edit_qso_msg + 0 , dlg->items + 0, 1, &min);
    max_group_width(term, edit_qso_msg + 1 , dlg->items + 1, 1, &max);
    min_group_width(term, edit_qso_msg + 1 , dlg->items + 1, 1, &min);
    max_group_width(term, edit_qso_msg + 2 , dlg->items + 2, 1, &max);
    min_group_width(term, edit_qso_msg + 2 , dlg->items + 2, 1, &min);
    max_group_width(term, edit_qso_msg + 3 , dlg->items + 3, 1, &max);
    min_group_width(term, edit_qso_msg + 3 , dlg->items + 3, 1, &min);
    max_group_width(term, edit_qso_msg + 4 , dlg->items + 4, 1, &max);
    min_group_width(term, edit_qso_msg + 4 , dlg->items + 4, 1, &min);
    max_group_width(term, edit_qso_msg + 5 , dlg->items + 5, 1, &max);
    min_group_width(term, edit_qso_msg + 5 , dlg->items + 5, 1, &min);
    max_group_width(term, edit_qso_msg + 6 , dlg->items + 6, 1, &max);
    min_group_width(term, edit_qso_msg + 6 , dlg->items + 6, 1, &min);
    max_group_width(term, edit_qso_msg + 7 , dlg->items + 7, 1, &max);
    min_group_width(term, edit_qso_msg + 7 , dlg->items + 7, 1, &min);
    max_group_width(term, edit_qso_msg + 8 , dlg->items + 8, 1, &max);
    min_group_width(term, edit_qso_msg + 8 , dlg->items + 8, 1, &min);
    max_group_width(term, edit_qso_msg + 9 , dlg->items + 9, 1, &max);
    min_group_width(term, edit_qso_msg + 9 , dlg->items + 9, 1, &min);
    max_group_width(term, edit_qso_msg +10 , dlg->items +10, 1, &max);
    min_group_width(term, edit_qso_msg +10 , dlg->items +10, 1, &min);
    max_group_width(term, edit_qso_msg +11 , dlg->items +11, 1, &max);
    min_group_width(term, edit_qso_msg +11 , dlg->items +11, 1, &min);
    max_group_width(term, edit_qso_msg +12 , dlg->items +12, 1, &max);
    min_group_width(term, edit_qso_msg +12 , dlg->items +12, 1, &min);
    
    max_buttons_width(term, dlg->items +13, 2, &max);
    min_buttons_width(term, dlg->items +13, 2, &min);
    
    w = dlg->win->term->x * 9 / 10 - 2 * DIALOG_LB;
    if (w > max) w = max;
    if (w < min) w = min;
    if (w > dlg->win->term->x - 2 * DIALOG_LB) w = dlg->win->term->x - 2 * DIALOG_LB;
    if (w < 1) w = 1;
    
    rw = 0;
    y ++;
    dlg_format_group(NULL, term, edit_qso_msg + 0, dlg->items + 0, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, edit_qso_msg + 1, dlg->items + 1, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, edit_qso_msg + 2, dlg->items + 2, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, edit_qso_msg + 3, dlg->items + 3, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, edit_qso_msg + 4, dlg->items + 4, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, edit_qso_msg + 5, dlg->items + 5, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, edit_qso_msg + 6, dlg->items + 6, 1, 0, &y, w, &rw);
    dlg_format_text (NULL, term, oqsonrs, dlg->x+6, &y, w, &rw, COLOR_DIALOG_TEXT, 0);
    dlg_format_group(NULL, term, edit_qso_msg + 7, dlg->items + 7, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, edit_qso_msg + 8, dlg->items + 8, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, edit_qso_msg + 9, dlg->items + 9, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, edit_qso_msg +10, dlg->items +10, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, edit_qso_msg +11, dlg->items +11, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, edit_qso_msg +12, dlg->items +12, 1, 0, &y, w, &rw);
    y++;
    dlg_format_buttons(NULL, term, dlg->items +13, 2, 0, &y, w, &rw, AL_LEFT);
    
    w = rw;
    dlg->xw = w + 2 * DIALOG_LB;
    dlg->yw = y + 2 * DIALOG_TB;

    
    center_dlg(dlg);
    draw_dlg(dlg);
    y = dlg->y + DIALOG_TB;
    y++;
    dlg_format_group(term, term, edit_qso_msg + 0, dlg->items + 0, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, edit_qso_msg + 1, dlg->items + 1, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, edit_qso_msg + 2, dlg->items + 2, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, edit_qso_msg + 3, dlg->items + 3, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, edit_qso_msg + 4, dlg->items + 4, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, edit_qso_msg + 5, dlg->items + 5, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, edit_qso_msg + 6, dlg->items + 6, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_text (term, term, oqsonrs, dlg->x+6, &y, w, &rw, COLOR_DIALOG_TEXT, 0);
    dlg_format_group(term, term, edit_qso_msg + 7, dlg->items + 7, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, edit_qso_msg + 8, dlg->items + 8, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, edit_qso_msg + 9, dlg->items + 9, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, edit_qso_msg +10, dlg->items +10, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, edit_qso_msg +11, dlg->items +11, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, edit_qso_msg +12, dlg->items +12, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    y++;
    dlg_format_buttons(term, term, dlg->items +13, 2, dlg->x + DIALOG_LB, &y, w, NULL, AL_LEFT);
    
}

void edit_qso(struct terminal *term, struct qso *qso, void *yyy)
{
    struct dialog *d;
    int i;
    static char ss[1024];
    

/*    dbg("edit_qso\n");*/
    
    if (!qso) return;
    
    dump_qso(qso, "edit_qso");
    dump_all_sources(ctest);
    
    safe_strncpy0(callsign, qso->callsign, EQSO_LEN); uc(callsign);
    safe_strncpy0(rstr,     qso->rstr,     EQSO_LEN);
    safe_strncpy0(qsonrr,   qso->qsonrr,   EQSO_LEN);
    safe_strncpy0(exc,  qso->exc,  EQSO_LEN); 
    safe_strncpy0(locator,  qso->locator,  EQSO_LEN); uc(locator);
    mode=qso->mode;
    safe_strncpy0(mode_str,mode_msg[mode],EQSO_LEN);
    safe_strncpy0(rsts,     qso->rsts,     EQSO_LEN);
    safe_strncpy0(qsonrs,   qso->qsonrs,   EQSO_LEN);
    safe_strncpy0(date_str, qso->date_str, EQSO_LEN); 
    safe_strncpy0(time_str, qso->time_str, EQSO_LEN);
    safe_strncpy0(operator, qso->operator, EQSO_LEN);
    safe_strncpy0(remark,   qso->remark,   MAX_STR_LEN);
    qerror = qso->error;
    qsl    = qso->qsl;
    
    safe_strncpy0(oomode_str, mode_msg[mode],EQSO_LEN);
    safe_strncpy0(oorstr,     qso->rstr,     EQSO_LEN);
    safe_strncpy0(oorsts,     qso->rsts,     EQSO_LEN);

    g_snprintf(ocallsign, OEQSO_LEN, "%s %-15s", TEXT(T_CALLSIGN2), callsign);
    g_snprintf(orstr    , OEQSO_LEN, "%s %-15s", TEXT(T_RSTR)     , rstr    );
    g_snprintf(oqsonrr  , OEQSO_LEN, "%s %-15s", TEXT(T_QSONRR)   , qsonrr  );
    g_snprintf(oexc     , OEQSO_LEN, "%s %-15s", TEXT(T_OPTEXCH)  , exc     );
    g_snprintf(olocator , OEQSO_LEN, "%s %-15s", TEXT(T_WWL)      , locator );
    g_snprintf(omode_str, OEQSO_LEN, "%s %-15s", TEXT(T_MODE)     , mode_str);
    g_snprintf(orsts    , OEQSO_LEN, "%s %-15s", TEXT(T_RSTS)     , rsts    );
    g_snprintf(oqsonrs  , OEQSO_LEN, "%s %-15s", TEXT(T_QSONRS)   , qsonrs  );
    g_snprintf(odate_str, OEQSO_LEN, "%s %-15s", TEXT(T_DATE)     , date_str);
    g_snprintf(otime_str, OEQSO_LEN, "%s %-15s", TEXT(T_TIME)     , time_str);
    g_snprintf(ooperator, OEQSO_LEN, "%s %-15s", TEXT(T_OPERATOR) , operator);
    g_snprintf(oremark  , OEQSO_LEN, "%s %-15s", TEXT(T_REMARK)   , remark  );
    
    
    if (!(d = mem_alloc(sizeof(struct dialog) + 55 * sizeof(struct dialog_item)))) return;
    memset(d, 0, sizeof(struct dialog) + 55 * sizeof(struct dialog_item));
    /*d->title = "Edit QSO";*/
    g_snprintf(ss,1000,TEXT(T_EDIT_QSO_CD), upcase(aband->bandchar), atoi(qso->qsonrs));
    d->title = ss;
    d->fn = edit_qso_fn;
    d->refresh = (void (*)(void *))refresh_edit_qso;
    d->refresh_data = (void *) qso;

    
    d->items[i=0].type = D_FIELD; /* 0 */
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = callsign;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data =rstr;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = qsonrr;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = exc;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = locator;

    /* 5 */
    d->items[++i].type = D_BUTTON;   
    d->items[i].gid  = 0;
    d->items[i].fn   = dlg_mode;
    d->items[i].text = mode_str;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = rsts;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = date_str;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = time_str;
    
    d->items[++i].type = D_FIELD;  
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = operator;
    
    d->items[++i].type = D_FIELD;    /* 10 */ 
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].maxl = EQSO_LEN;
    d->items[i].data = remark;
   
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&qerror;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&qsl;
    
    d->items[++i].type = D_BUTTON;      /* 13 */
    d->items[i].gid = B_ENTER;
    d->items[i].fn = ok_dialog;
    d->items[i].text = TEXT(T_OK);
    
    d->items[++i].type = D_BUTTON;      /* 14 */
    d->items[i].gid = B_ESC;
    d->items[i].fn = cancel_dialog;
    d->items[i].text = TEXT(T_CANCEL);
    
    d->items[++i].type = D_END;
    do_dialog_(term, d, getml(d, NULL));
}
                               


/******************** SKED *******************************/


char qrg_str[EQSO_LEN];
int we_call;
char pband[EQSO_LEN]="Select"; /* TODO TEXT(T_SELECT) */
/*, time_str[EQSO_LEN], callsign[EQSO_LEN]*/;
/*char locator[EQSO_LEN], remark[MAX_STR_LEN]; */
                       
int pband_int=-1;

void refresh_sked(struct qso *q)
{
    GString *gs;
    char s[10], *c;
    time_t now;
    struct tm *utc;

    time(&now);
    utc=gmtime(&now);
    
    dbg("refresh_sked\n");
    gs = g_string_new("SK ");

    g_string_sprintfa(gs, "%d.%02d;", utc->tm_hour, utc->tm_min);
    g_string_append(gs, fixsemi(aband->operator));
    g_string_append_c(gs,';');
    safe_strncpy0(s, aband->pband, 10); 
    c = index(s, ' ');
    if (c) *c='\0';
    g_string_append(gs, s);
    g_string_append_c(gs,';');
    g_string_append(gs, fixsemi(qrg_str));
    g_string_append_c(gs,';');
    
    g_string_sprintfa(gs, "%d;", we_call);
    g_string_append(gs, pband);
    g_string_append_c(gs,';');
    g_string_append(gs, time_str);
    g_string_append_c(gs,';');
    g_string_append(gs, fixsemi(callsign));
    g_string_append_c(gs,';');
    
    g_string_append(gs, fixsemi(locator));
    g_string_append_c(gs,';');
    g_string_append(gs, fixsemi(remark));
    g_string_append_c(gs,';');
    
/*    dbg("sked '%s'\n", gs->str);*/
    sw_sked_read(gs->str,1);
    g_string_append_c(gs,'\n');

    rel_write_all(gs->str);
    g_string_free(gs, TRUE);


}                    

char *sked_msg[] = {
    CTEXT(T_QRG), /* 0 */
    CTEXT(T_WE_CALL), 
    CTEXT(T_BAND),
    CTEXT(T_TIME), 
    CTEXT(T_CALLSIGN2),
    CTEXT(T_WWL), /* 5 */
    CTEXT(T_REMARK),
    "", /* OK */  /* 7 */
    "", /* Cancel */
};
void sked_fn(struct dialog_data *dlg)
{
    struct terminal *term = dlg->win->term;
    int max = 0, min = 0;
    int w, rw;
    int y = -1;

    max_group_width(term, sked_msg + 0, dlg->items + 0, 1, &max);
    min_group_width(term, sked_msg + 0, dlg->items + 0, 1, &min);
    max_group_width(term, sked_msg + 1, dlg->items + 1, 1, &max);
    min_group_width(term, sked_msg + 1, dlg->items + 1, 1, &min);
    max_group_width(term, sked_msg + 2, dlg->items + 2, 1, &max);
    min_group_width(term, sked_msg + 2, dlg->items + 2, 1, &min);
    max_group_width(term, sked_msg + 3, dlg->items + 3, 1, &max);
    min_group_width(term, sked_msg + 3, dlg->items + 3, 1, &min);
    max_group_width(term, sked_msg + 4, dlg->items + 4, 1, &max);
    min_group_width(term, sked_msg + 4, dlg->items + 4, 1, &min);
    max_group_width(term, sked_msg + 5, dlg->items + 5, 1, &max);
    min_group_width(term, sked_msg + 5, dlg->items + 5, 1, &min);
    max_group_width(term, sked_msg + 6, dlg->items + 6, 1, &max);
    min_group_width(term, sked_msg + 6, dlg->items + 6, 1, &min);
    
    max_buttons_width(term, dlg->items +7, 2, &max);
    min_buttons_width(term, dlg->items +7, 2, &min);
    
    w = dlg->win->term->x * 9 / 10 - 2 * DIALOG_LB;
    if (w > max) w = max;
    if (w < min) w = min;
    if (w > dlg->win->term->x - 2 * DIALOG_LB) w = dlg->win->term->x - 2 * DIALOG_LB;
    if (w < 1) w = 1;
    
    rw = 0;
    y ++;
    dlg_format_group(NULL, term, sked_msg + 0, dlg->items + 0, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, sked_msg + 1, dlg->items + 1, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, sked_msg + 2, dlg->items + 2, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, sked_msg + 3, dlg->items + 3, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, sked_msg + 4, dlg->items + 4, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, sked_msg + 5, dlg->items + 5, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, sked_msg + 6, dlg->items + 6, 1, 0, &y, w, &rw);
    y++;
    dlg_format_buttons(NULL, term, dlg->items +7, 2, 0, &y, w, &rw, AL_LEFT);
    
    
    w = rw;
    dlg->xw = w + 2 * DIALOG_LB;
    dlg->yw = y + 2 * DIALOG_TB;

    
    center_dlg(dlg);
    draw_dlg(dlg);
    y = dlg->y + DIALOG_TB;
    y++;
    dlg_format_group(term, term, sked_msg + 0, dlg->items + 0, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, sked_msg + 1, dlg->items + 1, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, sked_msg + 2, dlg->items + 2, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, sked_msg + 3, dlg->items + 3, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, sked_msg + 4, dlg->items + 4, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, sked_msg + 5, dlg->items + 5, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, sked_msg + 6, dlg->items + 6, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    y++;
    dlg_format_buttons(term, term, dlg->items +7, 2, dlg->x + DIALOG_LB, &y, w, NULL, AL_LEFT);
    
}

void sked(struct terminal *term, void *xxx, void *yyy){
    struct dialog *d;
    int i;
    struct band *band;
    
    if (pband_int<0){
        for (i = 0; i < ctest->bands->len; i++) {
            band = (struct band *)g_ptr_array_index(ctest->bands, i);
            if (band==aband) break;
        }
        i++;
        if (i<ctest->bands->len){
            band = (struct band *)g_ptr_array_index(ctest->bands, i);
            safe_strncpy0(pband, band->pband, EQSO_LEN);
            pband_int = i;
        }
    }
	if (pband_int<0) pband_int=0;
    band = (struct band *)g_ptr_array_index(ctest->bands, pband_int);
	if (band) safe_strncpy0(qrg_str, band->skedqrg, EQSO_LEN);
	

    if (!(d = mem_alloc(sizeof(struct dialog) + 15 * sizeof(struct dialog_item)))) return;
    memset(d, 0, sizeof(struct dialog) + 15 * sizeof(struct dialog_item));
    d->title = TEXT(T_SEND_SKED);
    d->fn = sked_fn;
    d->refresh = (void (*)(void *))refresh_sked;
    d->refresh_data = NULL;

    d->items[i=0].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = qrg_str;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&we_call;
    

    d->items[++i].type = D_BUTTON;
    d->items[i].gid  = 0;
    d->items[i].fn   = dlg_pband;
    d->items[i].text = pband;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = time_str;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = callsign;
    
    d->items[++i].type = D_FIELD;   /* 5 */
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = locator;
   
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = 61;
    d->items[i].data = remark;
    d->items[i].maxl = EQSO_LEN;
    
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ENTER;
    d->items[i].fn = ok_dialog;
    d->items[i].text = TEXT(T_OK);
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ESC;
    d->items[i].fn = cancel_dialog;
    d->items[i].text = TEXT(T_CANCEL);
    
    d->items[++i].type = D_END;
    do_dialog_(term, d, getml(d, NULL));
}
                               
void sked_from_tmpqso(struct terminal *term, struct tmpqso *tmpqso, void *yyy)
{
    time_t now;
    struct tm *utc;

    time(&now);
    now+=cfg->skedshift*60;
    utc=gmtime(&now);
           
    strcpy(qrg_str,"");
    we_call=0;
    /* pband */
    g_snprintf(time_str, EQSO_LEN, "%d.%02d", utc->tm_hour, utc->tm_min);
    safe_strncpy0(callsign, tmpqso->callsign, EQSO_LEN); uc(callsign);
    safe_strncpy0(locator,  tmpqso->locator,  EQSO_LEN); uc(locator);
    strcpy(remark, "");

    sked(term, NULL, yyy);
}

void sked_from_qso(struct terminal *term, struct qso *qso, void *yyy)
{
    time_t now;
    struct tm *utc;

    time(&now);
    now+=cfg->skedshift*60;
    utc=gmtime(&now);
           
    strcpy(qrg_str,"");
    we_call=0;
    /* pband */
    g_snprintf(time_str, EQSO_LEN, "%d.%02d", utc->tm_hour, utc->tm_min);
    safe_strncpy0(callsign, qso->callsign, EQSO_LEN); uc(callsign);
    safe_strncpy0(locator,  qso->locator,  EQSO_LEN); uc(locator);
    strcpy(remark, "");

    sked(term, NULL, yyy);
}



void sked_pband_func (struct terminal *term, void *ip, void *d){
    struct band *band;
    int active;

    active=(vint)ip;
    dbg("sked_pband_func(%d)\n", active);
    if (active<0 || active>=ctest->bands->len) return;
    
    pband_int = active;
    band = g_ptr_array_index(ctest->bands, pband_int);
    safe_strncpy0(pband, band->pband, EQSO_LEN);
 	safe_strncpy0(qrg_str, band->skedqrg, EQSO_LEN);
    redraw_later(term);
}

void sked_pband(struct terminal *term, struct session *ses, char *ptr)                   
{                                                                                             
    int i, sel;
    struct menu_item *mi;
    struct band *band;
    
    if (!(mi = new_menu(1))) return;
    for (i = 0; i < ctest->bands->len; i++) {
        band = (struct band *)g_ptr_array_index(ctest->bands, i);
        add_to_menu(&mi, band->pband, "", "", MENU_FUNC sked_pband_func, (void *)(vint)i, 0);
    }
    sel = (vint) ptr;
    if (sel < 0) sel = 0;
    if (sel>=ctest->bands->len) sel=0;
    do_menu_selected(term, mi, ptr, sel);
}


int dlg_pband(struct dialog_data *dlg, struct dialog_item_data *di){
    sked_pband(dlg->win->term, NULL, (char *)(vint)pband_int); 
    return 0;
}
