//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
//*********************************************************************************
//** GlADPoint.cpp : Source for an augmented display point
//** 
//** author : Delorme Maxime
//** date   : 07/07/05
//*********************************************************************************

#include "tulip/GlADAxisPoint.h"
using namespace std;
using namespace tlp;
/*
GlADAxisPoint::GlADAxisPoint() {
  //    cout << __PRETTY_FUNCTION__ << endl ;
  // no default constructor
}
*/
//===================================================
GlADAxisPoint::GlADAxisPoint(const Coord& position, const Color& color, float range) : GlADPoint(position, color) {
  //cout << __PRETTY_FUNCTION__ << endl ;
  this->range = range;
  this->negativeThickness = 1;
  this->positiveThickness = 3;

  Color endColor = color;
  endColor.setA(0);

  for(int i=0; i < 3; i++)
    displayDim[i] = true;

  for(int i=0; i < N_POINT_LINES; i++)
    lines[i] = new GlADLine(position, position, color, endColor, negativeThickness);
}
//===================================================
GlADAxisPoint::GlADAxisPoint(const Coord& position, const Color& color, float range, int negativeThickness, int positiveThickness) : GlADPoint(position, color) {
  //cout << __PRETTY_FUNCTION__ << endl ;

  this->range = range;
  this->negativeThickness = negativeThickness;
  this->positiveThickness = positiveThickness;

  for(int i=0; i < N_POINT_LINES; i++)
    lines[i] = new GlADLine(position, position, color, Color(255, 255, 255, 0), negativeThickness);

  for(int i=0; i < 3; i++)
    displayDim[i] = true;
}
//===================================================
GlADAxisPoint::~GlADAxisPoint() {
  //cout << __PRETTY_FUNCTION__  << endl;
  for(int i=0; i < N_POINT_LINES; i++)
    {
      delete lines[i];
      lines[i] = NULL;
    }
}
//===================================================
void GlADAxisPoint::draw(GlGraph* graph) {
  //cout << __PRETTY_FUNCTION__ << endl;
  computeLines();

  for(int i=0; i < N_POINT_LINES; i++)
    if (lines[i] != NULL && displayDim[i % 3])
      lines[i]->draw(graph);
    
  GlADPoint::draw(graph);
}
//===================================================
void GlADAxisPoint::changeRenderOptions() {
  for(int i=0; i < N_POINT_LINES; i++)
    lines[i]->setRenderOptions(renderOptions);
}
//===================================================
float GlADAxisPoint::getRange() const {
  //cout << __PRETTY_FUNCTION__  << endl;
    
  return range;
}
//===================================================
int GlADAxisPoint::getNegativeThickness() const {
  //cout << __PRETTY_FUNCTION__  << endl;

  return negativeThickness;
}
//===================================================
int GlADAxisPoint::getPositiveThickness() const {
  //cout << __PRETTY_FUNCTION__ << endl ;

  return positiveThickness;
}
//===================================================
void GlADAxisPoint::setRange(const float range) {
  //cout << __PRETTY_FUNCTION__ << endl ;

  this->range = range;
}
//===================================================
void GlADAxisPoint::setNegativeThickness(const int negativeThickness) {
  //cout << __PRETTY_FUNCTION__ << endl ;
 
  this->negativeThickness = negativeThickness;
}
//===================================================
void GlADAxisPoint::setPositiveThickness(const int positiveThickness) {
  //cout << __PRETTY_FUNCTION__ << endl ;

  this->positiveThickness = positiveThickness;
}
//===================================================
void GlADAxisPoint::computeLines() {
  //cout << __PRETTY_FUNCTION__ << endl;

  Coord tmpPos;

  // -x-axis
  tmpPos   = Coord(position->getX() - range, position->getY(), position->getZ());
  lines[0]->setEndPosition(tmpPos);

  // -y-axis -- we flip the y axis
  tmpPos   = Coord(position->getX(), position->getY() + range, position->getZ());
  lines[1]->setEndPosition(tmpPos);

  // -z-axis
  tmpPos   = Coord(position->getX(), position->getY(), position->getZ() - range);
  lines[2]->setEndPosition(tmpPos);

  // +x-axis
  tmpPos   = Coord(position->getX() + range, position->getY(), position->getZ());
  lines[3]->setEndPosition(tmpPos);

  // +y-axis -- we flip the y axis
  tmpPos   = Coord(position->getX(), position->getY() - range, position->getZ());
  lines[4]->setEndPosition(tmpPos);

  // +z-axis
  tmpPos   = Coord(position->getX(), position->getY(), position->getZ() + range);
  lines[5]->setEndPosition(tmpPos);

  for(int i=3; i < N_POINT_LINES; i++)
    lines[i]->setThickness(positiveThickness);
}
//===================================================
void GlADAxisPoint::setDisplayDim(bool displayDim[3]) {
  for(int i=0; i < 3; i++)
    this->displayDim[i] = displayDim[i];
}
//===================================================
