//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <GL/gl.h>
#include <GL/glu.h>

#include "tulip/GlGraph.h"
#include "tulip/GlTools.h"

using namespace tlp;
using namespace std;

//====================================================
void GlGraph::initProjection(bool reset){
  // already done by the caller
  // X Error: GLXBadContextState 155
  // if the following line is uncommented
  //setupOpenGlContext();
  glMatrixMode(GL_PROJECTION);
  if (reset) glLoadIdentity();
  Vector<int, 4> viewport = _renderingParameters.getViewport();
  Camera camera = _renderingParameters.getCamera();
  float ratio = double(viewport[2])/double(viewport[3]);
  if (_renderingParameters.isViewOrtho()) 
    if (ratio>1)
      glOrtho(ratio*-camera.sceneRadius/2.0/camera.zoomFactor, ratio*camera.sceneRadius/2.0/camera.zoomFactor,
	      -camera.sceneRadius/2.0/camera.zoomFactor, camera.sceneRadius/2.0/camera.zoomFactor,
	      0, camera.sceneRadius*2.);
    else 
      glOrtho(-camera.sceneRadius/2.0/camera.zoomFactor, camera.sceneRadius/2.0/camera.zoomFactor,
	      1./ratio * - camera.sceneRadius/2.0/camera.zoomFactor, 1./ratio * camera.sceneRadius/2.0/camera.zoomFactor,
	      0, camera.sceneRadius*2.);
  else
    glFrustum(ratio*-1.0/camera.zoomFactor, ratio*1.0/camera.zoomFactor, 
	      -1.0/camera.zoomFactor, 1.0/camera.zoomFactor, 1.0 , 
	      camera.sceneRadius*2.);
  
  glGetFloatv (GL_PROJECTION_MATRIX, (GLfloat*)&projectionMatrix);
  transformMatrix = modelviewMatrix * projectionMatrix;
  glTest(__PRETTY_FUNCTION__);
}
//====================================================
void GlGraph::initModelView(){
  // already done by the caller
  // X Error: GLXBadContextState 155
  // if the following line is uncommented
  //setupOpenGlContext();
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  Camera camera = _renderingParameters.getCamera();
  gluLookAt(camera.eyes[0], camera.eyes[1], camera.eyes[2], 
	    camera.center[0], camera.center[1], camera.center[2],
	    camera.up[0], camera.up[1], camera.up[2]); 
  //  initLights();
  glGetFloatv (GL_MODELVIEW_MATRIX, (GLfloat*)&modelviewMatrix);
  transformMatrix = modelviewMatrix * projectionMatrix;
  glTest(__PRETTY_FUNCTION__);
}
//====================================================
void GlGraph::initLights() {
  GLfloat pos[4];
  Camera camera = _renderingParameters.getCamera();
  camera.eyes.get(pos[0],pos[1],pos[2]);
  pos[3]=1;
  GLfloat amb[4] = {0.3,0.3 , 0.3 ,0.3};
  GLfloat dif[4] = {1,1,1,1};
  GLfloat specular[4] = {0,0,0,1};
  GLfloat attC[3] = {1,1,1};
  GLfloat attL[3] = {0,0,0};
  GLfloat attQ[3] = {0,0,0};

  glEnable( GL_LIGHTING );
  glEnable( GL_LIGHT0 );

  glLightfv( GL_LIGHT0, GL_POSITION, pos );
  glLightfv( GL_LIGHT0, GL_AMBIENT, amb );
  glLightfv( GL_LIGHT0, GL_DIFFUSE, dif );
  glLightfv( GL_LIGHT0, GL_CONSTANT_ATTENUATION, attC );
  glLightfv( GL_LIGHT0, GL_LINEAR_ATTENUATION, attL );
  glLightfv( GL_LIGHT0, GL_QUADRATIC_ATTENUATION, attQ );
  glLightfv( GL_LIGHT0, GL_SPECULAR , specular);

  glTest(__PRETTY_FUNCTION__);
}
//====================================================
void GlGraph::initGlParameter() {
  // already done by the caller
  // X Error: GLXBadContextState 155
  // if the following line is uncommented
  //setupOpenGlContext();
  Vector<int, 4> viewport = _renderingParameters.getViewport();
  glViewport(viewport[0], viewport[1], viewport[2], viewport[3]);
  glEnable(GL_LINE_SMOOTH);
  //  glEnable(GL_POINT_SMOOTH);
  glDisable(GL_POINT_SMOOTH);
  glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
  glHint(GL_LINE_SMOOTH_HINT,GL_DONT_CARE);
  glLineWidth(1.0);
  glPointSize(1.0);
  glShadeModel(GL_SMOOTH);
  glEnable(GL_CULL_FACE);
  glEnable(GL_DEPTH_TEST);
  glEnable(GL_NORMALIZE);
  glDepthFunc(GL_LEQUAL );
  //glDepthFunc(GL_LESS );
  glPolygonMode(GL_FRONT, GL_FILL);
  glColorMask(1, 1, 1, 1);
  glEnable(GL_BLEND);
  glIndexMask(~0);
  Color background = _renderingParameters.getBackgroundColor();
  glClearColor(background.getRGL(), background.getGGL(), background.getBGL(), 1.0);
  glClearStencil(3);
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT | GL_STENCIL_BUFFER_BIT);
  glTest(__PRETTY_FUNCTION__);
}
//====================================================
