//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#include <GL/gl.h>
#include "tulip/GlHudPolygon.h"
#include "tulip/GlTools.h"



using namespace std;

namespace tlp {
  GlHudPolygon::GlHudPolygon(const vector<Coord> &points, 
			     const vector<Color> &fcolors,
			     const vector<Color> &ocolors,
			     const bool filled,
			     const bool outlined):
    _points(points),
    _fillColors(fcolors),
    _outlineColors(ocolors),
    _filled(filled),
    _outlined(outlined) {
    assert(points.size() >= 3);
  }
  //=====================================================
  GlHudPolygon::GlHudPolygon(const unsigned int nbPoints,
			     const unsigned int nbFillColors,
			     const unsigned int nbOutlineColors,
			     const bool filled,
			     const bool outlined):
    _points(nbPoints),
    _fillColors(nbFillColors),
    _outlineColors(nbOutlineColors),
    _filled(filled),
    _outlined(outlined) {
  }
  //=====================================================
  GlHudPolygon::~GlHudPolygon() {
  }
  //=====================================================
  void GlHudPolygon::setFillMode(const bool filled) {
    _filled = filled;
  }
  //=====================================================
  void GlHudPolygon::setOutlineMode(const bool outlined) {
    _outlined = outlined;
  }
  //=====================================================
  void GlHudPolygon::resizePoints(const unsigned int nbPoints) {
    assert(nbPoints >= 3);
    _points.resize(nbPoints);
  }
  //=====================================================
  void GlHudPolygon::resizeColors(const unsigned int nbColors) {
    assert(nbColors >= 1);
    _points.resize(nbColors);
  }
//=====================================================
  const tlp::Coord& GlHudPolygon::point(const unsigned int i) const {
    return _points[i];
  }
//=====================================================
  tlp::Coord& GlHudPolygon::point(const unsigned int i) {
    return _points[i];
  }
  //=====================================================
  const tlp::Color& GlHudPolygon::fcolor(const unsigned int i) const {
    return _fillColors[i];
  }
  //=====================================================
  tlp::Color& GlHudPolygon::fcolor(const unsigned int i) {
    return _fillColors[i];
  }
  //=====================================================
  const tlp::Color& GlHudPolygon::ocolor(const unsigned int i) const {
    return _outlineColors[i];
  }
  //=====================================================
  tlp::Color& GlHudPolygon::ocolor(const unsigned int i) {
    return _outlineColors[i];
  }
  //=====================================================
  void GlHudPolygon::draw(GlGraph *glGraph) {
    setup();

    vector<Coord> newPoints(_points.size());
    for(unsigned int i=0; i < _points.size(); ++i) {
      newPoints[i] = transformCoordinates(_points[i], glGraph);
    }

    if (_filled){
      if (_points.size() == 3)
	glBegin(GL_TRIANGLES);
      else 
	if (_points.size() == 4)
	  glBegin(GL_QUADS);
	else
	  glBegin(GL_POLYGON);

      for(unsigned int i=0; i < _points.size(); ++i) {
	if (i < _fillColors.size()) {
	  glColor4ubv((unsigned char *)&_fillColors[i]);
	}
	_points[i][2] = 0;
	glVertex3fv((float *)&newPoints[i]);
      }
      glEnd();
    }
    
    if (_outlined) {
      glBegin(GL_LINE_LOOP);
      for(unsigned int i=0; i < _points.size(); ++i) {
	if (i < _outlineColors.size()) {
	  glColor4ubv((unsigned char *)&_outlineColors[i]);
	}
	_points[i][2] = 0;
	glVertex3fv((float *)&newPoints[i]);
      }
      glEnd();
    }
    
    glTest(__PRETTY_FUNCTION__);
    unsetup();
  }
  //=====================================================
}
