//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
// Warning !!! this file does not have to be compiled
// when building Tulip with Qt 3
#include <QtCore/QtPlugin>
#include "tulip/GWOverviewWidgetPlugin.h"
#include "tulip/GWOverviewWidget.h"

#include "../designer/gwoverviewwidget.xpm"


using namespace tlp;

GWOverviewWidgetPlugin::GWOverviewWidgetPlugin(QObject *parent) : QObject(parent) {
  initialized = false;
}

GWOverviewWidgetPlugin::~GWOverviewWidgetPlugin() {
}

void GWOverviewWidgetPlugin::initialize(QDesignerFormEditorInterface * /*core*/) {
  if (initialized)
    return;

  initialized = true;
}

bool GWOverviewWidgetPlugin::isInitialized() const {
  return initialized;
}

QWidget* GWOverviewWidgetPlugin::createWidget(QWidget *parent) {
  return new GWOverviewWidget(parent, name());
}

QString GWOverviewWidgetPlugin::name() const {
  return "GWOverviewWidget";
}
  
QString GWOverviewWidgetPlugin::domXml() const {
  return "<widget class=\"GWOverviewWidget\" name=\"overviewWidget\">\n"
         "</widget>\n";
}

QString GWOverviewWidgetPlugin::includeFile() const {
  return "tulip/GWOverviewWidget.h";
}

QString GWOverviewWidgetPlugin::group() const {
  return "Tulip Widgets";
}

QIcon GWOverviewWidgetPlugin::icon() const {
  return QIcon(QPixmap(gwoverviewwidget_xpm));
}

QString GWOverviewWidgetPlugin::toolTip() const {
  return "Cluster Tree";
}

QString GWOverviewWidgetPlugin::whatsThis() const {
  return "A widget displaying the overview of the GlGraph associated to a GlGraphWidget";
}

bool GWOverviewWidgetPlugin::isContainer() const {
  return false;
}

QString GWOverviewWidgetPlugin::codeTemplate() const {
    return "";
}

Q_EXPORT_PLUGIN(GWOverviewWidgetPlugin)
