//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#include "TreeArityMax.h"

DOUBLEPLUGINOFGROUP(TreeArityMax,"Tree Arity Max","David Auber","20/12/1999","Alpha","1.0","Tree");

using namespace std;
using namespace tlp;

TreeArityMax::TreeArityMax(const PropertyContext &context):DoubleAlgorithm(context) 
{}
//======================================================
double TreeArityMax::getNodeValue(const node n) {
  if (graph->outdeg(n) == 0) return 0;
  if (doubleResult->getNodeValue(n) != 0) 
    return doubleResult->getNodeValue(n);
  
  double result = graph->outdeg(n);
  node _n;
  forEach(_n, graph->getOutNodes(n)) {
    if (getNodeValue(_n) > result)
      result = getNodeValue(_n);
  }
  
  doubleResult->setNodeValue(n, result);
  return result;
}
//======================================================
bool TreeArityMax::run() {
  doubleResult->setAllEdgeValue(0);
  doubleResult->setAllNodeValue(0);
  node n;
  forEach(n, graph->getNodes()) {
    doubleResult->setNodeValue(n, getNodeValue(n));
  }
  return true;
}
//======================================================
bool TreeArityMax::check(string &erreurMsg) {
   if (AcyclicTest::isAcyclic(graph)) {
     erreurMsg="";
     return true;
   }
   else {
     erreurMsg="The Graph must be Acyclic";
     return false;
   } 
}







