//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#include <tulip/Graph.h>
#include <tulip/GlGraphWidget.h>
#include <tulip/StringProperty.h>
#include "ElementInfoToolTip.h"
#include "viewGl.h"

using namespace tlp;


ElementInfoToolTip::ElementInfoToolTip(GlGraphWidget *glWidget, viewGl* viewWidget) :
  QToolTip(glWidget),
  glWidget(glWidget),
  viewWidget(viewWidget) {
}

void ElementInfoToolTip::maybeTip( const QPoint & p ) {
  node tmpNode;
  edge tmpEdge;
  ElementType type;
  QString tmp;
  if (viewWidget->areTooltipsEnabled() &&
      glWidget->doSelect(p.x(), p.y(), type, tmpNode, tmpEdge)) {
    // try to show the viewlabel if any
    StringProperty *labels = glWidget->getGraph()->getProperty<StringProperty>("viewLabel");
    std::string label;
    QString ttip;
    switch(type) {
    case NODE:
      label = labels->getNodeValue(tmpNode);
      if (!label.empty())
	ttip += (label + " (").c_str();
      ttip += QString("node: ")+ tmp.setNum(tmpNode.id);
      if (!label.empty())
	ttip += ")";
      tip(QRect(p.x()-2,p.y()-2,4,4), ttip); 
      break;
    case EDGE: 
      label = labels->getEdgeValue(tmpEdge);
      if (!label.empty())
	ttip += (label + "(").c_str();
      ttip += QString("edge: ")+ tmp.setNum(tmpEdge.id);
      if (!label.empty())
	ttip += ")";
      tip(QRect(p.x()-2,p.y()-2,4,4), ttip);
      break;
    }
  }
}
