/* twpsk  - A gui application for PSK
 * Copyright (C) 1999-2005 Ted Williams WA0EIR 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
 * Version: 2.1 - Aug 2002
 */

/*
 * Disp class header file
 */
#ifndef INCLUDED_TWPSKDISP
#define INCLUDED_TWPSKDISP

#include "GUI.h"

#define MAX_GRAYS   100
#define START 150
#define MAX_SAMPLES 8192                 /* max sample buffer size */
#define MAX_FFT (MAX_SAMPLES / 2) + 1
#define WF 1
#define SA 0
#define LINE_WIDTH 2                     /* keep it even */

class Disp {
   private:

      Display *display;
      Window window;
      int screen;
      Colormap cmap;
      GC gc;
      Cursor wfCursor;

      XColor dispPix[MAX_GRAYS];
      XColor redPix, defPix;

      int values[WF_WIDTH][WF_HEIGHT];

      int displayFlag;

      int cnt;                         /* Sample counter */
      int samples;                     /* Size of the sample */
      int speed;                       /* Speed scale value 0 -> 100 */
      int ffts;                        /* Number of filters */
      float fc;                        /* Center freq of display */
      float deltaf;                    /* Hz per fft sample */
      int delta;                       /* Offset into fft samples */
      float max;                       /* Max value in values? */
      int maxi;                        /* Index to max */
      int row;                         /* Row in circular buffer */
      float scaleFactor;               /* Scale factor for values */

      /* for IMD */
      int upperSig;
      int lowerSig;
      int upperIMD;
      int lowerIMD;

#if 0
      inline float sqr(float arg)
      {
         return arg * arg;
      }

      inline void swap (float &a, float &b)
      {
         float t = a; a = b; b = t;
      }
#endif
      void IMDcalc(float val[]);
      void mkPoints (float buffer[]);
      void drawDisplay(void);

      unsigned long get_mask_color(int color, unsigned long mask);
      void find_visual_info(int *truecolor, XVisualInfo *vinf);

   public:
      int brightness;
   
      void fft_setup (int samps, int overlap);
      void setup (Widget wfDA);
      void offset (float freq);
      void getFFT (float *val, int len);
      float new_fc (int x);
      int find_center (int x);

      void changeDisplay (int val)
      {
         displayFlag = val;
      }

      int getsamplecnt()
      {
          return samples;
      }

      void  set_samples(int samps)
      {
         fft_setup (512 * samps, -1);
//TJW
//printf ("deltaf = %f fc = %f\n", deltaf, fc);
      }

      void setFFTspeed (int val)
      {
         speed = val;
      }
};
#endif
