#!/usr/bin/perl
# ulog-acctd2mrtg.pl v0.1
# Donated to the public domain by Erik Hensema
# 
# This script reads the ulog-acctd logfile and produces some nice stats readable
# by MRTG.
# Please note that this script isn't as generic as I'd like it to be. You'll have
# to adjust it for your own needs.
#
# For more information: see the README file.

sub uptime() {
	open UPTIME, "</proc/uptime" or die "Cannot open /proc/uptime: $!";

	my $line = <UPTIME>;
	chomp $line;

	(my $up, my $idle) = split /\s/, $line;

	$days = int($up / (24 * 3600));
	$up -= $days * 24 * 3600;
	$hours = int($up / 3600);
	$up -= $hours * 3600;
	$secs = int($up / 60);

	return sprintf("%d days, %02d:%02d", $days, $hours, $secs)
}

my $logfile = "/var/log/ulog-acctd/account.log.old";
my $pidfile = "/var/run/ulog-acctd.pid";

if($#ARGV != 0) {
	die "Usage: $0 intern|extern|forward|drop\n";
}

$mode = $ARGV[0];

$bytes_in = 0;
$bytes_out = 0;

open LOG, "<$logfile" or die "Cannot open $logfile: $!";

while(<LOG>) {
	chomp;

	($hostname, $timestamp, $proto, $srcip, $sport, $dstip, $dport, $packets, $bytes, $if_in, $if_out, $prefix) = split /\t/;

	if($mode eq "extern") {
		if($prefix eq "\"EXT_IN\"") {
			$bytes_in+=$bytes;
		} elsif ($prefix eq "\"EXT_OUT\"") {
			$bytes_out+=$bytes;
		}
	} elsif ($mode eq "intern") {
		if($prefix eq "\"INT_IN\"") {
			$bytes_in+=$bytes;
		} elsif ($prefix eq "\"INT_OUT\"") {
			$bytes_out+=$bytes;
		}
	} elsif ($mode eq "forward") {
		if($prefix eq "\"FORWARD\"") {
			if($if_in eq "\"eth0\"") {
				$bytes_in+=$bytes;
			} else {
				$bytes_out+=$bytes;
			}
		}
	} elsif ($mode eq "drop") {
		if($prefix eq "\"DROP\"") {
			$bytes_in+=$bytes;
			$bytes_out+=$packets * 10;
		}
	}
}

print <<EOM;
+$bytes_in
+$bytes_out
EOM

print uptime() . "\n";

$mode eq "extern" && print "External Traffic\n";
$mode eq "intern" && print "Internal Traffic\n";
$mode eq "forward" && print "Forwarded Traffic\n";
$mode eq "drop" && print "Dropped Traffic\n";
