/**
 * @file windows_compat.h
 * Hacks to work with different versions of windows.
 * This is only included if WIN32 is set.
 *
 * @author  Ben Gardner
 * @license GPL v2+
 *
 * $Id: windows_compat.h 923 2007-09-18 13:04:22Z bengardner $
 */
#ifndef WINDOWS_COMPAT_H_INCLUDED
#define WINDOWS_COMPAT_H_INCLUDED

#define HAVE_SYS_STAT_H

#define NO_MACRO_VARARG

typedef char               CHAR;

typedef signed char        INT8;
typedef short              INT16;
typedef int                INT32;

typedef unsigned char      UINT8;
typedef unsigned short     UINT16;
typedef unsigned int       UINT32;

/* eliminate GNU's attribute */
#define __attribute__(x)

/* MSVC compilers before VC7 don't have __func__ at all; later ones call it
 * __FUNCTION__.
 */
#ifdef _MSC_VER
#if _MSC_VER < 1300
#define __func__    "???"
#else
#define __func__    __FUNCTION__
#endif
#else /* _MSC_VER */
#define __func__    "???"
#endif

#include "stdio.h"
#include "string.h"

#undef snprintf
#define snprintf      _snprintf

#undef vsnprintf
#define vsnprintf     _vsnprintf

#undef strcasecmp
#define strcasecmp    _strcmpi

#undef strncasecmp
#define strncasecmp   _strnicmp

/* includes for _setmode() */
#include <io.h>
#include <fcntl.h>
#include <direct.h>

#define mkdir(x, y) _mkdir(x)
#define PATH_SEP  '\\'

#endif   /* WINDOWS_COMPAT_H_INCLUDED */

