-- UUAGC 0.9.5 (CodeSyntax.ag)
module CodeSyntax where

import Patterns
import CommonTypes
import Data.Map(Map)
import Data.Set(Set)
-- CAlternative ------------------------------------------------
{-
   alternatives:
      alternative CAlternative:
         child con            : {Constructor}
         child visits         : CVisits
         child children       : {[(Name,Type,Bool)]}
         child terminals      : {[Name]}
-}
data CAlternative = CAlternative (Constructor) (CVisits) ([(Name,Type,Bool)]) ([Name])
-- CAlternatives -----------------------------------------------
{-
   alternatives:
      alternative Cons:
         child hd             : CAlternative
         child tl             : CAlternatives
      alternative Nil:
-}
type CAlternatives = [CAlternative]
-- CGrammar ----------------------------------------------------
{-
   alternatives:
      alternative CGrammar:
         child typeSyns       : {TypeSyns}
         child derivings      : {Derivings}
         child wrappers       : {Set Nonterminal}
         child prods          : CProductions
         child pragmas        : {PragmaMap}
-}
data CGrammar = CGrammar (TypeSyns) (Derivings) (Set Nonterminal) (CProductions) (PragmaMap)
-- CInterface --------------------------------------------------
{-
   alternatives:
      alternative CInterface:
         child seg            : CSegments
-}
data CInterface = CInterface (CSegments)
-- CProduction -------------------------------------------------
{-
   alternatives:
      alternative CProduction:
         child nt             : {Nonterminal}
         child inh            : {Attributes}
         child syn            : {Attributes}
         child alts           : CAlternatives
         child inter          : CInterface
-}
data CProduction = CProduction (Nonterminal) (Attributes) (Attributes) (CAlternatives) (CInterface)
-- CProductions ------------------------------------------------
{-
   alternatives:
      alternative Cons:
         child hd             : CProduction
         child tl             : CProductions
      alternative Nil:
-}
type CProductions = [CProduction]
-- CRule -------------------------------------------------------
{-
   alternatives:
      alternative CChildVisit:
         child name           : {Name}
         child nt             : {Nonterminal}
         child nr             : {Int}
         child inh            : {Attributes}
         child syn            : {Attributes}
         child isLast         : {Bool}
      alternative CRule:
         child name           : {Name}
         child isIn           : {Bool}
         child hasCode        : {Bool}
         child nt             : {Nonterminal}
         child con            : {Constructor}
         child field          : {Name}
         child childnt        : {Maybe Nonterminal}
         child tp             : {Maybe Type}
         child pattern        : {Pattern}
         child rhs            : {[String]}
         child defines        : {Map Int (Name,Name,Maybe Type)}
         child owrt           : {Bool}
         child origin         : {String}
         child uses           : {Set (Name, Name)}
-}
data CRule = CChildVisit (Name) (Nonterminal) (Int) (Attributes) (Attributes) (Bool)
           | CRule (Name) (Bool) (Bool) (Nonterminal) (Constructor) (Name) (Maybe Nonterminal) (Maybe Type) (Pattern) ([String]) (Map Int (Name,Name,Maybe Type)) (Bool) (String) (Set (Name, Name))
-- CSegment ----------------------------------------------------
{-
   alternatives:
      alternative CSegment:
         child inh            : {Attributes}
         child syn            : {Attributes}
-}
data CSegment = CSegment (Attributes) (Attributes)
-- CSegments ---------------------------------------------------
{-
   alternatives:
      alternative Cons:
         child hd             : CSegment
         child tl             : CSegments
      alternative Nil:
-}
type CSegments = [CSegment]
-- CVisit ------------------------------------------------------
{-
   alternatives:
      alternative CVisit:
         child inh            : {Attributes}
         child syn            : {Attributes}
         child vss            : Sequence
         child intra          : Sequence
         child ordered        : {Bool}
-}
data CVisit = CVisit (Attributes) (Attributes) (Sequence) (Sequence) (Bool)
-- CVisits -----------------------------------------------------
{-
   alternatives:
      alternative Cons:
         child hd             : CVisit
         child tl             : CVisits
      alternative Nil:
-}
type CVisits = [CVisit]
-- Sequence ----------------------------------------------------
{-
   alternatives:
      alternative Cons:
         child hd             : CRule
         child tl             : Sequence
      alternative Nil:
-}
type Sequence = [CRule]
