/* valadbusmethod.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gobject/valadbusmethod.h>
#include <vala/valasymbol.h>
#include <vala/valacodenode.h>
#include <gee/readonlycollection.h>

enum  {
	VALA_DBUS_METHOD_DUMMY_PROPERTY
};
static GeeCollection* vala_dbus_method_real_get_cheader_filenames (ValaSymbol* base);
static char* vala_dbus_method_real_get_default_cname (ValaMethod* base);
static gpointer vala_dbus_method_parent_class = NULL;


ValaDBusMethod* vala_dbus_method_new (const char* name, ValaDataType* return_type, ValaSourceReference* source_reference) {
	ValaDBusMethod * self;
	g_return_val_if_fail (return_type == NULL || VALA_IS_DATA_TYPE (return_type), NULL);
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	self = g_object_newv (VALA_TYPE_DBUS_METHOD, 0, NULL);
	vala_symbol_set_name (VALA_SYMBOL (self), name);
	vala_method_set_return_type (VALA_METHOD (self), return_type);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	return self;
}


static GeeCollection* vala_dbus_method_real_get_cheader_filenames (ValaSymbol* base) {
	ValaDBusMethod * self;
	self = VALA_DBUS_METHOD (base);
	return GEE_COLLECTION (gee_read_only_collection_new (G_TYPE_STRING, ((GBoxedCopyFunc) g_strdup), g_free, NULL));
}


static char* vala_dbus_method_real_get_default_cname (ValaMethod* base) {
	ValaDBusMethod * self;
	self = VALA_DBUS_METHOD (base);
	return g_strdup ("dbus_g_proxy_begin_call");
}


static void vala_dbus_method_class_init (ValaDBusMethodClass * klass) {
	vala_dbus_method_parent_class = g_type_class_peek_parent (klass);
	VALA_SYMBOL_CLASS (klass)->get_cheader_filenames = vala_dbus_method_real_get_cheader_filenames;
	VALA_METHOD_CLASS (klass)->get_default_cname = vala_dbus_method_real_get_default_cname;
}


static void vala_dbus_method_init (ValaDBusMethod * self) {
}


GType vala_dbus_method_get_type (void) {
	static GType vala_dbus_method_type_id = 0;
	if (G_UNLIKELY (vala_dbus_method_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDBusMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_dbus_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDBusMethod), 0, (GInstanceInitFunc) vala_dbus_method_init };
		vala_dbus_method_type_id = g_type_register_static (VALA_TYPE_METHOD, "ValaDBusMethod", &g_define_type_info, 0);
	}
	return vala_dbus_method_type_id;
}




