/* valaattribute.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALAATTRIBUTE_H__
#define __VALA_VALAATTRIBUTE_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/list.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttributePrivate ValaAttributePrivate;

/**
 * Represents an attribute specified in the source code.
 */
struct _ValaAttribute {
	ValaCodeNode parent_instance;
	ValaAttributePrivate * priv;
	GeeList* args;
};
struct _ValaAttributeClass {
	ValaCodeNodeClass parent_class;
};

ValaAttribute* vala_attribute_new (const char* name, ValaSourceReference* source_reference);
void vala_attribute_add_argument (ValaAttribute* self, ValaNamedArgument* arg);
gboolean vala_attribute_has_argument (ValaAttribute* self, const char* name);
char* vala_attribute_get_string (ValaAttribute* self, const char* name);
gint vala_attribute_get_integer (ValaAttribute* self, const char* name);
gboolean vala_attribute_get_bool (ValaAttribute* self, const char* name);
char* vala_attribute_get_name (ValaAttribute* self);
void vala_attribute_set_name (ValaAttribute* self, const char* value);
GType vala_attribute_get_type (void);

G_END_DECLS

#endif
