/* valabindingprovider.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALABINDINGPROVIDER_H__
#define __VALA_VALABINDINGPROVIDER_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valasymbol.h>
#include <vala/valamemberaccess.h>

G_BEGIN_DECLS


#define VALA_TYPE_BINDING_PROVIDER (vala_binding_provider_get_type ())
#define VALA_BINDING_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BINDING_PROVIDER, ValaBindingProvider))
#define VALA_IS_BINDING_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BINDING_PROVIDER))
#define VALA_BINDING_PROVIDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), VALA_TYPE_BINDING_PROVIDER, ValaBindingProviderIface))

typedef struct _ValaBindingProvider ValaBindingProvider;
typedef struct _ValaBindingProviderIface ValaBindingProviderIface;

/**
 * Interface for dynamic binding providers.
 */
struct _ValaBindingProviderIface {
	GTypeInterface parent_iface;
	ValaSymbol* (*get_binding) (ValaBindingProvider* self, ValaMemberAccess* ma);
};

ValaSymbol* vala_binding_provider_get_binding (ValaBindingProvider* self, ValaMemberAccess* ma);
GType vala_binding_provider_get_type (void);

G_END_DECLS

#endif
