/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.5
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef SCROLLED_H
#define SCROLLED_H
#include <vdk/vdkobj.h>
#include <vdk/widcontain.h>
/*!
  \class VDKScrolled
  \brief this calls provides a scrolled container widget

  both horizontal and vertical scroll bars will appear when needed.
 */
class VDKScrolled: public VDKObjectContainer
{
public:
  /*!
    Use this property to get/set border shadow.
    Shadows can be:
    - shadow_none
    - shadow_in
    - shadow_out
    - shadow_etched_in
    - shadow_etched_out
   */
  VDKReadWriteValueProp<VDKScrolled,GtkShadowType> BorderShadow;
  /*!
    Constructor
    \param owner owner form
    \param mode either v_box or h_box, meaning that scrolled will be
    constructed with a v_box or h_box inside
   */
  VDKScrolled(VDKForm* owner = NULL,int mode = v_box);
  /*!
    Destructor
   */
  virtual ~VDKScrolled();
  /*!
    Adds a widget to scrolled
    \param obj widget to be added
    \param others args will be ignored
   */
  // warning: only first arg is used
  void Add(VDKObject* obj, int justify = l_justify,
		   int expand = TRUE, int fill = TRUE , int padding = 1);
  /*!
    Adds a non self scrollable widget, acts like Add()
   */
  void AddWithViewport(VDKObject* obj);
  /*!
    Adds a self scrollable widget
   */
  void AddWithoutViewport(VDKObject* obj, int justify = l_justify,
		 int expand = TRUE, int fill = TRUE, int padding = 0);
  /*!
    \internal
  */
  void SetBorderShadow(GtkShadowType bs);
};
#endif
