/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.FontState;

public class BlockContainer
extends FObj {
    FontState fs;
    ColorType backgroundColor;
    int paddingTop;
    int paddingBottom;
    int paddingLeft;
    int paddingRight;
    int position;
    int top;
    int bottom;
    int left;
    int right;
    int width;
    int height;
    ColorType borderTopColor;
    int borderTopWidth;
    int borderTopStyle;
    ColorType borderBottomColor;
    int borderBottomWidth;
    int borderBottomStyle;
    ColorType borderLeftColor;
    int borderLeftWidth;
    int borderLeftStyle;
    ColorType borderRightColor;
    int borderRightWidth;
    int borderRightStyle;
    int span;
    AreaContainer areaContainer;
    PageSequence pageSequence;

    protected BlockContainer(FObj fObj, PropertyList propertyList) throws FOPException {
        super(fObj, propertyList);
        this.name = "fo:block-container";
        this.span = this.properties.get("span").getEnum();
    }

    public boolean generatesReferenceAreas() {
        return true;
    }

    public int getContentWidth() {
        if (this.areaContainer != null) {
            return this.areaContainer.getContentWidth();
        }
        return 0;
    }

    public int getSpan() {
        return this.span;
    }

    public Status layout(Area area) throws FOPException {
        Object object;
        int n;
        Object object2;
        if (this.marker == -1000) {
            this.marker = 0;
            String string = this.properties.get("font-family").getString();
            object2 = this.properties.get("font-style").getString();
            String string2 = this.properties.get("font-weight").getString();
            n = this.properties.get("font-size").getLength().mvalue();
            int n2 = this.properties.get("font-variant").getEnum();
            this.fs = new FontState(area.getFontInfo(), string, (String)object2, string2, n, n2);
            this.backgroundColor = this.properties.get("background-color").getColorType();
            this.paddingLeft = this.paddingTop = this.properties.get("padding").getLength().mvalue();
            this.paddingRight = this.paddingTop;
            this.paddingBottom = this.paddingTop;
            if (this.paddingTop == 0) {
                this.paddingTop = this.properties.get("padding-top").getLength().mvalue();
                this.paddingLeft = this.properties.get("padding-left").getLength().mvalue();
                this.paddingBottom = this.properties.get("padding-bottom").getLength().mvalue();
                this.paddingRight = this.properties.get("padding-right").getLength().mvalue();
            }
            this.position = this.properties.get("position").getEnum();
            this.top = this.properties.get("top").getLength().mvalue();
            this.bottom = this.properties.get("bottom").getLength().mvalue();
            this.left = this.properties.get("left").getLength().mvalue();
            this.right = this.properties.get("right").getLength().mvalue();
            this.width = this.properties.get("width").getLength().mvalue();
            this.height = this.properties.get("height").getLength().mvalue();
            this.borderBottomColor = this.borderTopColor = this.properties.get("border-color").getColorType();
            this.borderLeftColor = this.borderTopColor;
            this.borderRightColor = this.borderTopColor;
            if (this.borderTopColor == null) {
                this.borderTopColor = this.properties.get("border-top-color").getColorType();
                this.borderBottomColor = this.properties.get("border-bottom-color").getColorType();
                this.borderLeftColor = this.properties.get("border-left-color").getColorType();
                this.borderRightColor = this.properties.get("border-right-color").getColorType();
            }
            this.borderBottomWidth = this.borderTopWidth = this.properties.get("border-width").getLength().mvalue();
            this.borderLeftWidth = this.borderTopWidth;
            this.borderRightWidth = this.borderTopWidth;
            if (this.borderTopWidth == 0) {
                this.borderTopWidth = this.properties.get("border-top-width").getLength().mvalue();
                this.borderBottomWidth = this.properties.get("border-bottom-width").getLength().mvalue();
                this.borderLeftWidth = this.properties.get("border-left-width").getLength().mvalue();
                this.borderRightWidth = this.properties.get("border-right-width").getLength().mvalue();
            }
            this.borderBottomStyle = this.borderTopStyle = this.properties.get("border-style").getEnum();
            this.borderLeftStyle = this.borderTopStyle;
            this.borderRightStyle = this.borderTopStyle;
            if (this.borderTopStyle == 0) {
                this.borderTopStyle = this.properties.get("border-top-style").getEnum();
                this.borderBottomStyle = this.properties.get("border-bottom-style").getEnum();
                this.borderLeftStyle = this.properties.get("border-left-style").getEnum();
                this.borderRightStyle = this.properties.get("border-right-style").getEnum();
            }
            this.span = this.properties.get("span").getEnum();
            object = this.properties.get("id").getString();
            area.getIDReferences().initializeID((String)object, area);
        }
        boolean bl = false;
        object2 = (AreaContainer)area;
        if (this.width == 0 && this.height == 0) {
            this.width = this.right - this.left;
            this.height = this.bottom - this.top;
        }
        this.areaContainer = new AreaContainer(this.fs, ((AreaContainer)object2).getXPosition() + this.left, ((AreaContainer)object2).getYPosition() - this.top, this.width, this.height, this.position);
        this.areaContainer.setPage(area.getPage());
        this.areaContainer.setBackgroundColor(this.backgroundColor);
        this.areaContainer.setPadding(this.paddingTop, this.paddingLeft, this.paddingBottom, this.paddingRight);
        this.areaContainer.setBorderStyle(this.borderTopStyle, this.borderLeftStyle, this.borderBottomStyle, this.borderRightStyle);
        this.areaContainer.setBorderWidth(this.borderTopWidth, this.borderLeftWidth, this.borderBottomWidth, this.borderRightWidth);
        this.areaContainer.setBorderColor(this.borderTopColor, this.borderLeftColor, this.borderBottomColor, this.borderRightColor);
        this.areaContainer.start();
        this.areaContainer.setAbsoluteHeight(area.getAbsoluteHeight());
        this.areaContainer.setIDReferences(area.getIDReferences());
        int n3 = this.children.size();
        n = this.marker;
        while (n < n3) {
            FObj fObj = (FObj)this.children.elementAt(n);
            object = fObj.layout(this.areaContainer);
            ((Status)object).isIncomplete();
            if (((Status)object).getCode() == 8) {
                bl = true;
            }
            ++n;
        }
        area.setAbsoluteHeight(this.areaContainer.getAbsoluteHeight());
        this.areaContainer.end();
        if (this.position == 3) {
            this.areaContainer.setHeight(this.height);
        }
        area.addChild(this.areaContainer);
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new BlockContainer(fObj, propertyList);
        }
    }
}

