/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.util.Vector;
import org.apache.fop.apps.FOPException;
import org.apache.fop.dom.CharacterDataImpl;
import org.apache.fop.dom.svg.SVGTextElementImpl;
import org.apache.fop.fo.EnumProperty;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.svg.SVGLengthProperty;
import org.apache.fop.svg.SVGObj;
import org.apache.fop.svg.SVGStyle;
import org.apache.fop.svg.SVGTransform;
import org.apache.fop.svg.TextElement;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGElement;

public class Text
extends SVGObj {
    Vector textList = new Vector();
    SVGTextElementImpl textGraph = new SVGTextElementImpl();

    protected Text(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "svg:text";
    }

    protected void addCharacters(char[] cArray, int n, int n2) {
        this.textList.addElement(new String(cArray, n, n2 - n));
    }

    protected void addChild(FONode fONode) {
        super.addChild(fONode);
        if (fONode instanceof TextElement) {
            TextElement textElement = (TextElement)((Object)fONode);
            SVGElement sVGElement = textElement.createTextElement();
            this.textList.addElement(sVGElement);
        }
    }

    public SVGElement createGraphic() {
        Object object;
        int n = this.textList.size();
        int n2 = 0;
        while (n2 < n) {
            Object object2;
            object = this.textList.elementAt(n2);
            if (object instanceof SVGElement) {
                object2 = (SVGElement)object;
                this.textGraph.appendChild((Node)object2);
            } else if (object instanceof String) {
                object2 = (String)object;
                CharacterDataImpl characterDataImpl = new CharacterDataImpl();
                characterDataImpl.setData((String)object2);
                this.textGraph.appendChild(characterDataImpl);
            }
            ++n2;
        }
        object = ((SVGLengthProperty)this.properties.get("x")).getSVGLength();
        this.textGraph.x = object == null ? 0.0f : object.getValue();
        object = ((SVGLengthProperty)this.properties.get("y")).getSVGLength();
        this.textGraph.y = object == null ? 0.0f : object.getValue();
        this.textGraph.anchor = (EnumProperty)this.properties.get("text-anchor");
        this.textGraph.setStyle(((SVGStyle)this.properties.get("style")).getStyle());
        this.textGraph.setTransform(((SVGTransform)this.properties.get("transform")).getTransform());
        this.textGraph.setId(this.properties.get("id").getString());
        switch (this.properties.get("xml:space").getEnum()) {
            case 2: {
                this.textGraph.setXMLspace("default");
                break;
            }
            case 1: {
                this.textGraph.setXMLspace("preserve");
                break;
            }
        }
        return this.textGraph;
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new Text(fObj, propertyList);
        }
    }
}

