create table if not exists commands (command varchar(20) not null primary key, alias varchar(10), class int, args text, help text);
create table if not exists commargs (cmd varchar(20) not null, arg varchar(20) not null, help text, primary key (cmd, arg));
create table if not exists configvars (var varchar(30) not null, vtype enum('int','string','bool'), defval text, help text, applies enum('not','new','now'));

insert into commands values ('!ban', '!bi', 3, '<ip> [<reason>]', 'Permanent ban of ip with the reason. User with given ip has been recently kicked, nick is banned too.');
insert into commands values ('!unban', '!ub', 3, '<ip>', 'Unban the ip. If a nick was banned with the same ip, it is unbanned too, smae for all other types of bans');
insert into commands values ('!getip', '!gi', 3, '<nick>', "Print user's ip address");
insert into commands values ('!gethost', '!gh', 3, '<nick>', "Print user's hostname if available. This works only if dns_lookup = 1.");
insert into commands values ('!getinfo', '!gi', 3, '<nick>', "Print user's ip, hostname, adn other available information");
insert into commands values ('!nickban', '!bn', 3, '<nick>', "permanently adds given nick ONLY to nickbanlist");
insert into commands values ('!nickunban', '!un', 3, '<nick>', "removes given nick ONLY from nickbanlist");
insert into commands values ('!tempban', '!tb', 3, '<ip> <time> [<reason>]', "temporary ban on ip (and possibly nick), if user has been kicked recently, his nick is banned, and the kick reason is used for reason");
insert into commands values ('!ipban', '!bi', 3, '<ip> [<reason>]', "perm ban the ipaddress, but not nick, even if the kick is found");
insert into commands values ('!ipunban', '!ui', 3, '<ip>', "remove the ip from banlist, anyway, if there is a nick banned with same ip, nick stays banned");
insert into commands values ('!ipbanlist', '!bl', 3, NULL, "print the banlist of ip's");
insert into commands values ('!kick', '!ki', 3, '<nick> <reason>', "Kick the user from command line, the _ban_ think doesn't work here");
insert into commands values ('!ops', '!oc', 3, '<message>', "send the messahe to all online operators to pm from hub_security, replies go to sender's pm from hub_security");
insert into commands values ('!regs', NULL, 3, '<message>', "send the <message> to all registered users");
insert into commands values ('!regpasswd', '!rp', 3, '<nick>', "allow registered nick to change his password (he has to use command +passwd <pass>)");
insert into commands values ('!regdisable', '!r0', 3, '<nick>', "disable registered user, that is praticaly unregistering him, but he can be enabled later");
insert into commands values ('!regenable', '!r1', 3, '<nick>', "enable user's registration, when he wad previously disabled with !regdisable");
insert into commands values ('!help', '!?', 3, NULL, "gives a help on all available commands");
insert into commands values ("!quit" , NULL, 10, NULL, "Stop the hub");
insert into commands values ("!set", "!=" , 5 , '<variable> <value>', "Set the given variable to the new <value>, settings are not saved to config");
insert into commands values ("!regpurge" , NULL, 5 , '<nick>', "not implemented");
insert into commands values ("!getconfig" ,"!gc", 5 , NULL, "Prints all the variables, that can be configures in the config file and their current values");
insert into commands values ("!broadcast" ,"!bc", 4 , '<message>', "send the message to all user's pms, replied are sent back to you into pm from hub_security");
insert into commands values ("!regdeluser","!rd" , 4, '<nick>', "not implemented");
insert into commands values ("!regnewuser","!rn" , 4, '<nick> [<class>]', "register new user with given class (default is 1), Allowed classes are 1-5, you can't give class higher then your's -2");
insert into commands values ("!regclass"  ,"!rc" , 4, '<nick> [<class>]', "Setup the class for registered user");
insert into commands values ("!hostban"   ,"!bh" , 4, '<host> <reason>' , "add the host permanently to banlist");
insert into commands values ("!hostunban" ,"!uh" , 4, '<host>', "remove host from hostbanlist");
insert into commands values ("!drop"      ,"!dr" , 4, '<nick>', "disconnect user from hub, kicktempban applies here");

insert into configvars values ("hub_name", 'string', "VerliHub", "The name of hub", 'new');
insert into configvars values ("max_users", 'int', "3500", "maximum count of normal users", 'new');
insert into configvars values ("max_extra_ops", 'int', "50", "number of ops that can login after hub is full of normal users", 'new');
insert into configvars values ("max_extra_admins", 'int', "5", "number of extra admins, on full hub", 'new');
insert into configvars values ("min_share", 'int', "(unsigned long)1*1024", "Minimum share in megabytes",'new');
insert into configvars values ("min_share_reg", 'int', "(unsigned long)0*1024", "min share for class >=2 [MB]", 'new');
insert into configvars values ("min_share_ops", 'int', "(unsigned long)0", "min share for ops class>= 3 [MB]",'new');
insert into configvars values ("max_share", 'int', "(unsigned long)1024*1024", "maximum share [MB]", 'new');
insert into configvars values ("tban_kick", 'int', "300", "time period of not allowing to login kicked users after kick [s]", 'now');
insert into configvars values ("max_nick", 'int', "32", "max length of nickname",'new');
insert into configvars values ("min_nick", 'int', "3", "min length of nickname", 'new');
insert into configvars values ("nick_chars", 'string', "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789()[]{}_-+=.", "chars allowed for nick", 'new');
insert into configvars values ("max_chat_msg", 'int', "256", "size of max allowed chat message for normal users in [B]", 'now');
insert into configvars values ("max_chat_lines", 'int', "5", "number of lines allowed per chat message",'now');
insert into configvars values ("db_host", 'string', "loclahost", "mysql database hostname", 'not');
insert into configvars values ("db_user", 'string', "verlihub", "mysql username",'not');
insert into configvars values ("db_pass", 'string', "", "mysql passwrd",'not');
insert into configvars values ("db_data", 'string', "verlihub", "mysql database to use on the host",'not');
insert into configvars values ("nick_prefix", 'string', "", "prefix before nick, to allow user in", 'new');
insert into configvars values ("listen_port", 'int','4111',"port on which server listens",'not');
insert into configvars values ("listen_ip",'string',"0.0.0.0", "ip address on which server listens",'not');
insert into configvars values ("timer_conn_period", 'int', '4', "period of timer executed for every connection", 'now');
insert into configvars values ("timer_serv_period", 'int' ,'1', "period [s] of timer executed only with the server, this executes the connection timers too",'now');
insert into configvars values ("nicklist_on_login", 'bool', '1', "disable sending of nicklist before user sends myinfo",'new');
insert into configvars values ("delayed_search", 'bool', '1', "is search to be sent in server timer (1) or immediately(0), cpu effect is enourmous",'now');
insert into configvars values ("step_delay", 'int', '100',"delay in [us] on every step, gives the processor time not to be cooked",'now');
insert into configvars values ("hub_security",'string', "VerliHub","The name of hub security",'not');
insert into configvars values ("log_level",'int', "2","intensity of logging events 5 logs all (input, output, etc), 0 logs nothing",'now');
insert into configvars values ("check_ctm", 'int', "1", "disconnect users who give different ip in commnect to me",'now');
insert into configvars values ("check_rctm", 'int', "1", "drop users who give different nick in revocnnectome",'now');
insert into configvars values ("max_message_size",'int', '10240', "maximum size of incoming single message",'now');
insert into configvars values ("dns_lookup",'bool', '0', "lookup hostnames in dns on new suer connection",'new');
