/*
	Vertex Model Assember: Configuration Parameters and Values

	Management for sequential lists of configuration items, each
	item in this list has a type, parameter, and value. Each of which
	can be dynamically and abstractly treated for easier coding of
	parsing routines.

 */

#ifndef VMACFG_H
#define VMACFG_H

#include <sys/types.h>


/*
 *	Configuration item structure, contains three (3) values as
 *	follows; a parameter, a data type, and a value. Each member
 *	must be a size of 4 bytes, so the size of the structure must be
 *	exactly 3 * 4 = 12 bytes.
 */
typedef struct {
#define VMA_CFG_ITEM_TYPE_NONE		0	/* Value is NULL. */
#define VMA_CFG_ITEM_TYPE_INT_8		1
#define VMA_CFG_ITEM_TYPE_U_INT_8	2
#define VMA_CFG_ITEM_TYPE_INT_16	3
#define VMA_CFG_ITEM_TYPE_U_INT_16	4
#define VMA_CFG_ITEM_TYPE_INT_32	5
#define VMA_CFG_ITEM_TYPE_U_INT_32	6
#define VMA_CFG_ITEM_TYPE_INT_64	7
#define VMA_CFG_ITEM_TYPE_U_INT_64	8
#define VMA_CFG_ITEM_TYPE_FLOAT		9
#define VMA_CFG_ITEM_TYPE_DOUBLE	10
#define VMA_CFG_ITEM_TYPE_STRING	11

#define VMA_CFG_ITEM_TYPE_COLOR		20

	int32_t type;	/* One of MA_CFG_ITEM_TYPE_*, specifies value type. */
	char *parameter;
	void *value;

} vma_cfg_item_struct;


/* Configuration item IO. */
extern vma_cfg_item_struct *VMACFGItemNew(
	int type, const char *parameter
);
extern void *VMACFGItemGetValue(vma_cfg_item_struct *ci, int *type_rtn);
extern void VMACFGItemSetValue(vma_cfg_item_struct *ci, const void *value);
extern void VMACFGItemResetValue(vma_cfg_item_struct *ci);
extern void VMACFGItemReset(vma_cfg_item_struct *ci);
extern void VMACFGItemDelete(vma_cfg_item_struct *ci);


/* Configuration item list handling. */
extern int VMACFGItemListMatchParameter(
	vma_cfg_item_struct *list, const char *parameter
);

extern void *VMACFGItemListMatchGetValue(
	vma_cfg_item_struct *list, const char *parameter, int *type_rtn
);
extern int VMACFGItemListGetValueI(
	vma_cfg_item_struct *list, const char *parameter
);
extern long VMACFGItemListGetValueL(
	vma_cfg_item_struct *list, const char *parameter
);
extern float VMACFGItemListGetValueF(
	vma_cfg_item_struct *list, const char *parameter
);
extern double VMACFGItemListGetValueD(
	vma_cfg_item_struct *list, const char *parameter
);
extern char *VMACFGItemListGetValueS(
	vma_cfg_item_struct *list, const char *parameter
);

extern vma_cfg_item_struct *VMACFGItemListMatchSetValue(
	vma_cfg_item_struct *list, const char *parameter,
	const void *value, int create_as_needed
);



#endif	/* VMACFG_H */
