/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef GRIDDEFINITION_H
#define GRIDDEFINITION_H

#include <GraphDefinition.h>

#include <Types.h>

class GridView;
class QDomElement;

class GridDefinition : public GraphDefinition
{
public:
  GridDefinition();
  virtual ~GridDefinition();

  virtual GraphView* getView();
  virtual void updateGraph();

  void setLinXAxis( bool value );
  void setXAxisMin( TReal value );
  void setXAxisMax( TReal value );
  void setNoXSteps( uint value );
  void setYAxisMin( TReal value );
  void setYAxisMax( TReal value );
  void setNoYSteps( uint value );
  void setTracking( bool value );
  
  bool  getLinXAxis() const;
  TReal getXAxisMin() const;
  TReal getXAxisMax() const;
  uint  getNoXSteps() const;
  TReal getYAxisMin() const;
  TReal getYAxisMax() const;
  uint  getNoYSteps() const;
  bool  getTracking() const;

  virtual void writeGraphSettingToStream( QTextStream& stream );
  virtual bool readGraphSettingFromDOM( QDomElement& element );

private:
  GridDefinition( const GridDefinition& );
  GridDefinition& operator= ( const GridDefinition& );

private:
  QString xAxisTitle_;
  bool linXAxis_;
  TReal xMin_;
  TReal xMax_;
  uint  xSteps_;
  TReal yMin_;
  TReal yMax_;
  uint  ySteps_;
  bool  trackProjFreq_;
  QGuardedPtr<GridView> view_;

};

#endif

