/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef TABLEDEFINITION_H
#define TABLEDEFINITION_H

#include <GraphDefinition.h>

class TableView;
class QDomElement;

class TableDefinition : public GraphDefinition
{
public:
  TableDefinition();
  virtual ~TableDefinition();

  virtual GraphView* getView();
  virtual void updateGraph();

  virtual void writeGraphSettingToStream( QTextStream& stream );
  virtual bool readGraphSettingFromDOM( QDomElement& element );
  
private:
  TableDefinition( const TableDefinition& );
  TableDefinition& operator=( const TableDefinition& );
  
private:
  QGuardedPtr<TableView> view_;
};

#endif
