//<copyright>
//
// Copyright (c) 1996
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>

//<file>
//
// Name:    query.C
//
// Purpose: parsing of post and query
//
// Created: 13 May 1996 Till Vollmer
//
// $Id: query.C,v 1.1 1997/02/25 11:09:48 tvollmer Exp $
//
// Description:
//   
//</file>
//
// $Log: query.C,v $
// Revision 1.1  1997/02/25 11:09:48  tvollmer
// Initial revision
//
// Revision 1.8  1996/10/10 13:30:13  tvollmer
// + first in ' ' then decoding (:-))
//
// Revision 1.7  1996/10/09 14:17:02  gessl
// Alpha of Edit Attributes (Action&Template not registered in slaveworker.C)
//
// Revision 1.6  1996/10/04 11:39:02  tvollmer
// new utils library
//
// Revision 1.5  1996/07/29 15:59:38  tvollmer
// bug removed (key=) at end
//
// Revision 1.4  1996/07/16 10:45:40  tvollmer
// removed + bug
//
// Revision 1.3  1996/07/10 12:06:10  tvollmer
// HGNEW and HGDELETE
//
// Revision 1.2  1996/07/09 14:47:19  tvollmer
// *** empty log message ***
//
// Revision 1.1  1996/05/21 10:30:39  tvollmer
// Initial revision
//
//

#include "query.h"
#include <hyperg/utils/new.h>
void QueryParser::add(const RString& it)
{
    RString key;
    RString entry;
    int pos=0;
    while (pos<it.length())
    if (it.gWordChar(pos,'=',key))
    {
        pos++;
        if (it.gSubstrIndex(pos,pos)=="&" ||it.gSubstrIndex(pos,pos) =="" )  // empty entry
        {
            pos++;
            key.subst('+',' ');
            unescape(key);
            insert(HeaderField(key,""));
            
        }
        else
        if(it.gWordChar(pos,'&',entry))
        {
            pos++;
// unescape them
            key.subst('+',' ');
            unescape(key);
            entry.subst('+',' ');
            unescape(entry);
            insert(HeaderField(key,entry));
        }
        else
            break;
        
    }
    else
        break;
}

void QueryParser::unescape(RString& url) 
{
    register int x,y;

    char* h_url =HGNEW(char[url.length()+1]);
    strcpy (h_url, url);//because unescape_url is a C function

    for(x=0,y=0;h_url[y];++x,++y) {
        if((h_url[x] = h_url[y]) == '%') {
            h_url[x] = x2c_(&h_url[y+1]);
            y+=2;
        }
    }
    h_url[x] = '\0';
    url =  RString(h_url);

    HGDELETE(h_url);
}
char QueryParser::x2c_(char *what) 
{
    char digit;

    digit = (what[0] >= 'A' ? ((what[0] & 0xdf) - 'A')+10 : (what[0] - '0'));
    digit *= 16;
    digit += (what[1] >= 'A' ? ((what[1] & 0xdf) - 'A')+10 : (what[1] - '0'));
    return(digit);
}

