//<file>
//
// Name:        message.C
//
// Purpose:     Message class for status and error messages
//
// Created:     03 Aug 93    Keith Andrews
//
// Modified:    11 Jan 94    Michael Pichler
//
// Modified:     9 Mai 94    Gerald Pani
//                           
//</file>


#include "message.h"

#include <iostream.h>
#include <stdlib.h>


// static members
RString HgMessage::progname_;
HgMessage::cleanupfunc HgMessage::cleanup_ = nil;


void HgMessage::init( const RString& progname, cleanupfunc cleanup)
{
  progname_ = progname;
  cleanup_ = cleanup;
}


void HgMessage::message(const char* msg)
{
  cerr << progname_ << ": " << msg << endl;
}


void HgMessage::error(const char* msg)
{
  cerr << progname_ << ". Error: " << msg << endl;
}


void HgMessage::fatalError(const char* msg, int code)
{
  cerr << progname_ << ". Fatal error: " << msg << endl;
  if (cleanup_)
    (*cleanup_)();
  cerr << progname_ << " terminated with exit code " << code << "." << endl;
  ::exit (code);
}
