// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1996
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        condition.h
// 
// Purpose:     
// 
// Created:     19 Nov 1996   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// $Id: condition.h,v 1.1 1996/12/06 13:36:58 root Exp $
// 
// $Log: condition.h,v $
// Revision 1.1  1996/12/06 13:36:58  root
// Initial revision
//
// 
// </file> 
#ifndef hg_dc_threads_condition_h
#define hg_dc_threads_condition_h

#include "mutexlock.h"

#ifdef Solaris
#  include <thread.h>
#endif

class HWCondition {
public:
   HWCondition (HWMutexLock&) ;
   ~HWCondition() ;
   
   bool ok() const { return !error(); }
   operator void*() const { return (void*)ok(); }
   bool operator !() const { return !ok(); }
   int error() const { return error_; }

   void wait() ;
   void signal() ;

private:
#ifdef Solaris
   cond_t cond_ ;
#endif
   HWMutexLock* lock_ ;
   int error_ ;

private:
   HWCondition (const HWCondition&) {}
   HWCondition& operator = (const HWCondition&) { return *this; }

public:
   static Verbose verbose ;
   static const char* version1 ;
} ;
static const char* hg_utils_condition_version = HWCondition::version1 ;


#endif
