// This may look like C code, but it is really -*- C++ -*-

// <copyright>
// 
// Copyright (c) 1993-1995
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
// </copyright>

//<file>
//
// Name:       environ.h
//
// Purpose:    Access to environment variables and other system values
//
// Created:     1 Feb 92    Gerald Pani
//
// Modified:   21 Jul 93    Gerald Pani
//
//
// Description:
//
//   See class Environ.
//
//</file>

#ifndef hg_utils_environ_h
#define hg_utils_environ_h

#include "hgunistd.h"
#include <stdlib.h>
#include "str.h"

//<class>
//
// Name:       Environ
//
// Purpose:    Access to environment variables and other system values
//
//
// Public Interface:
//
// - boolean getEnv( const RString& var, RString& val)
//   Sets val to the value of the environment variable var.
//   Method returns false, if var isn't set.
//   
// - boolean getEnv( const RString& var, int& val)
//   Sets val to the value of the environment variable var.
//   Method returns false, if var isn't set.
//   
// - boolean getEnv( const RString& var, boolean& val)
//   Sets val to "true", if var is equal to "true" or "1".
//   Method returns false, if var isn't set.
//   
// - void setEnv( const RString& var, const RString& value)
// - void setEnv( const RString& var, int value)
// - void setEnv( const RString& var, boolean value)
//   Sets the environment variable var to value.
//   
// - RString user()
//   Returns the username corresponding to the user id of the process.
//   
// - boolean getpw( RString& user, RString& passwd)
//   Fetches username and encrypted password corresponding to the
//   user id of the process. This function returns false and prints
//   a message if an error occurs.
// 
// - RString timeString( time_t t, boolean local = true)
//   Converts t to a string ("yy/mm/dd hh:mm:ss") in local or gm time.
// 
// - RString gmTimeString()
//   Equivalent to 'timeString( ::time( nil), false)'.
//   
// - boolean gmDate2Sec( const RString& date, time_t& secs)
// 
// - hgtime gmDate2hgtime( const char* date)
//   Converts "[yy]yy/mm/dd hh:mm:ss" (GMT) into a Hyper-G time type.
// 
// - const RString& hgtime2gmDate( hgtime time)
//   Converts a Hyper-G time value into "[yy]yy/mm/dd hh:mm:ss" (GMT).
// 
// - hgtime lDate2hgtime( const char* date)
//   Converts "[yy]yy/mm/dd hh:mm:ss" (local time) into a Hyper-G time type.
// 
// - const RString&  lDate2gmDate( const char* date)
//   Converts "[yy]yy/mm/dd hh:mm:ss" (local time) into yy/mm/dd hh:mm:ss gmDate
// 
// - const RString&  gmDate2LDate( const char* date)
//   Converts "[yy]yy/mm/dd hh:mm:ss" (gm time) into yy/mm/dd hh:mm:ss local time
// 
// - const RString& hgtime2lDate( hgtime time)
//   Converts a Hyper-G time value into "[yy]yy/mm/dd hh:mm:ss" (local time).
// 
// - const RString& hostName()
//   Returns the name of this host.
// 
// - const RString& hostAddress()
//   Returns the internet address ("aaa.bbb.ccc.ddd") of this host.
// 
// - boolean hostAddress( const RString host, RString& addr)
//   Returns the internet address ("aaa.bbb.ccc.ddd") of host in addr,
//   if true, otherwise an error string.
// 
// - boolean hostName( const RString addr, RString& name)
//   Returns the official name of host with internet address addr ("aaa.bbb.ccc.ddd"),
//   if true, otherwise an error string.
// 
// Description:
//
//
//</class>

class Environ {
  public:
     static boolean getEnv( const RString& var, RString& value);
     static boolean getEnv( const RString& var, int& value);
     static boolean getEnv( const RString& var, boolean& value);
     static void setEnv( const RString& var, const RString& value);
     static void setEnv( const RString& var, const char* value);
     static void setEnv( const RString& var, int value);
     static void setEnv( const RString& var, boolean value);
     static const RString& user();
     static boolean getpw( RString& user, RString& passwd); 
     static const RString& timeString( time_t t, boolean local = true);
     static const RString& gmTimeString();
     static boolean gmDate2Sec( const RString& date, time_t& secs);
     static hgtime gmDate2hgtime( const char* date);
     static const RString& hgtime2gmDate( hgtime time);
     static hgtime lDate2hgtime( const char* date);
     static const RString& lDate2gmDate( const char* date);
     static const RString& gmDate2lDate( const char* date);
     static const RString& hgtime2lDate( hgtime time);
     static const RString& hostName();
     static const RString& hostAddress();
     static boolean hostAddress( const RString& host, RString& addr);
     static boolean hostName( const RString& hostAddr, RString& name);

     static const char* version_1_0;
};
static const char* hg_utils_environ_version = Environ::version_1_0;

#endif





