// This may look like C code, but it is really -*- C++ -*-
/* NCSA CCI for X Windows
** Software Development Group
** National Center for Supercomputing Applications
** University of Illinois at Urbana-Champaign
** 605 E. Springfield, Champaign, IL 61820
** mosaic@ncsa.uiuc.edu

** Copyright  (C)  1995 Board of Trustees of the University of Illinois
*/



#ifndef hg_viewer_cci_scene_view_h
#define hg_viewer_cci_scene_view_h


#include "scenewin.h"
#include <hyperg/utils/str.h>

class QvWWWInline;
class Session;

class CCISceneViewer: public SceneWindow {  // standalone scene viewer
  QvWWWInline* currentNode_;
  RString currentURL_;
public:
  CCISceneViewer (Session* session);
  virtual ~CCISceneViewer() {}
  RString filenameToURL(const char* filename);
  void handleLoad(char *data, int length, const RString& url);
  virtual const char* mostRecentURL () const;  // mpi

//  int followLink (const GeometricObject*, const SourceAnchor*);
  virtual void 
    requestInlineURL(     // URL-request for inline VRML
		      QvWWWInline* node, // node (where attach inline data)
		      const char* url,   // requested URL (of data to be fetched)
		      const char* docurl); // URL of requesting document(for local URLs)

};



#endif
