// This may look like C code, but it is really -*- C++ -*-

//<copyright>
//
// Copyright (c) 1992,93,94,95
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
// This file is part of VRweb.
//
// VRweb is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// VRweb is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VRweb; see the file LICENCE. If not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// Note that the GNU General Public License does not permit incorporating
// the Software into proprietary or commercial programs. Such usage
// requires a separate license from IICM.
//
//</copyright>

//<file>
//
// Name:        sdfcam.h
//
// Purpose:     interface to Camera object (SDF)
//
// Created:     18 Mar 92   Michael Hofer and Michael Pichler
//
// Changed:      4 May 95   Michael Pichler
//
// $Id: sdfcam.h,v 1.3 1997/02/25 17:03:58 mpichler Exp $
//
//</file>



#ifndef harmony_scene_sdfcamera_h
#define harmony_scene_sdfcamera_h


#include "object3d.h"
#include "camera.h"


class SDFCamera
: public Object3D, public Camera
{
  public:
    SDFCamera (int obj_n, int par = 0, const char* name = 0);

    const char* type () const  { return "cam"; }

    void print ();

    void computeParams ();

    int getdispstat () const  { return (dispstat_); }

  private:
    int dispstat_;   // 0 OFF  1 ON (camera used)

  friend int SDFScene::readActFile (FILE*, int&);
  friend int SDFScene::readPosFile (FILE*, int);
  friend int SDFScene::readCamFile (FILE*);
  friend void SDFScene::writeCameras (ostream&);

}; // SDFCamera


#endif
