//<copyright>
//
// Copyright (c) 1994,95,96,97
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
// This file is part of VRweb.
//
// VRweb is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// VRweb is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VRweb; see the file LICENCE. If not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// Note that the GNU General Public License does not permit incorporating
// the Software into proprietary or commercial programs. Such usage
// requires a separate license from IICM.
//
//</copyright>

//<file>
//
// Name:        stranslate.C
//
// Purpose:     implementation of class STranslate
//
// Created:     29 Mar 94   Michael Pichler <mpichler@iicm.tu-graz.ac.at>
//
// Changed:     24 Oct 95   Tomas Torron-Mack <ttorron@iicm.tu-graz.ac.at> (added Spanish)
//
// Changed:     15 Dec 95   ric Plante <planteer@JSP.UMontreal.CA> (added French)
// Changed:     21 May 96   Frederic Devernay <Frederic.Devernay@sophia.inria.fr> (updated F)
//
// Changed:      4 Mar 96   Lia Spolidoro <lia@philos.unipv.it> (added Italian)
//
// Changed:      5 Sep 96   Korean Strings (utf8 encoded)
//
// Changed:      5 Oct 96   Japanese Strings (utf8 encoded)
//
// Changed:     27 Feb 97   Michael Pichler
//
// $Id: stranslate.C,v 1.53 1997/04/30 10:50:30 mpichler Exp $
//
//</file>



#include "stranslate.h"



// order of strings (see include/hyperg/hyperg/language.h)
// English, German, Styrian, French, Italian, Spanish,
// Korean, Japanese, Hungarian


#define CURVERSION "1.5"

static const char* sstringtable [STranslate::NumStrings][HgLanguage::NumLanguages] =
{
  // AboutSCENEVIEWER
  { "VRweb - 3D Scene Viewer", "VRweb - 3D Szenen-Viewer", "Wie-Aar-web - Drei De Wiua",
    "VRweb - Visionneur 3-D", "VRweb-Visionatore di scene in 3D", 0, "VRweb - ü ",
    "VRweb - 3D   ޭ", 0 },
  // AboutVERSIONtemplate
  { "Version " CURVERSION " (%s)\nof %s\n\n"
    "by Michael Pichler (mpichler@iicm.edu) et al.\n\n"
    "latest VRweb info:\n"
    "http:/""/www.iicm.edu/vrweb\n"
    "Please, send error reports to\nvrweb-bugs@iicm.edu",
    0, 0, 0, 0, 0, 0, 0, 0 },  // %s should be filled with comment and compilation date via sprintf
  /* korean:
    "" CURVERSION "Michael Pichler (mpichler@iicm.edu)   ϴ.\n"
    " ֽ   \n: http:/""/www.iicm.edu/vrweb ʽÿ\n"
    " ޽ vrweb-bugs@iicm.tu-graz.ac.at  ֽʽÿ.", */
  // AboutVERSIONdaemon
  { "--- Harmony Scene Viewer --- Version " CURVERSION, 0, 0, 0, 0, 0, 0, 0, 0 },  // will always be in English
  // AboutVERSIONhttp
  { "VRweb/" CURVERSION, 0, 0, 0, 0, 0, 0, 0, 0 },  // WWW User-Agent, not to be translated
  // AboutVERSIONvrweb
  { "VRweb " CURVERSION, 0, 0, 0, 0, 0, 0, 0, 0 },  // VRweb startup version, will not be translated

  /* Anchor highglighting */
  // AnchBRIGHTNESS
  { "Brightness", "Helligkeit", "Hlligkeit", "Surbrillance", "Brillantezza", "Brillo", "", "邳", 0 },
  // AnchBOUNDINGCUBE
  { "Bounding Cube", "Begrenzungswrfel", "Wirfl ummadum", "Cube englobant", "Cubo Delimitante", "Cubo Delimitante",
    0, "޳h ", 0 },
  // AnchCOLORCODE
  { "Colour Code", "Farbkodierung", "ondare Foab", "Code de couleur", "Codice del colore", "Cdigo de Color",
    " ڵ", "F ", 0 },
  // AnchCOLOREDGES
  { "Colour Edges", "Kanten hervorheben", "Kanten nochimolen",
    "Artes de couleur", "Margini del colore", "Colorear Lados", "", "F", 0 },

  /* Anchor Definition, Object Selection */
  // AnchorDEFAULTDESTINATION
  { "Use Default Destination", "Verwende Defaultziel", "Nimm's normale Zl",
    "Utiliser destination par dfaut", "Usare destinazione per default", "Usar Destino Estndar",
    "⺻  ", "̫ĖړIngp", 0 },
  // AnchorDEFINEDESTINATION
  { "Define As Destination", "Definiere als Ziel", "Nimm's als Zl",
    "Dfinir comme destination", "Definire destinazione", "Definir como Destino",
    " ", "ړInƂĒ`", 0 },
  // AnchorDEFINESOURCE
  { "Define As Source", "Definiere als Quelle", "Nimm's als Qulln",
    "Dfinir comme source", "Definire come origine", "Definir como Orgen",
    "ٿ ", "ƂĒ`", 0 },
  // AnchorDELETE
  { "Delete", "Lschen", "Lschn", "Effacer", "eliminare", "Eliminar", "", "폜", 0 },
  // AnchorDESELECT
  { "Deselect Object/Group", "Selektion entfernen", "Nix auswhln",
    "Annuler slection d'objet/groupe", "Diselezionare oggetto/gruppo", "Deseleccionar Objeto/Grupo",
    "ü/׷  ", "I޼ު/ٰ߂܂", 0 },
  // AnchorDISPLAY
  { "Display", "Anzeigen", "Anzagn", "Afficher", "Schermo", "Monitor", "ȭ ", "ިڲ", 0 },
  // AnchorFOLLOW
  /* I'd prefer "Aktivieren" for german "Anker verfolgen"; this way consistent with other Harmony viewers */
  { "Follow", "Verfolgen", "Nchlaffn", "Suivre", "Attivare", "Activar", "󰡱", "]", 0 },
  /* currently used for viewpoints (Ansichten) instead of anchors */
  // AnchorNEXT
  { "Next", "Nchste", "Nexte", "Suivant", "Seguente", "Siguiente", "", "", 0 },
  // AnchorPREVIOUS
  { "Previous", "Vorige", "Vurige", 0, 0, "Previo", "", "O", 0 },

//  // AnchorSELECTANCHORS
//{ "Select Anchors", "Anker selektieren", "nka auswhln", "Choisir ancres", "Seleziona agganci", "Seleccionar Anclas",
//  "Ŀ ", "ݶI", 0 },
  // AnchorSELECTGROUPS
  { "Select Groups", "Gruppen selektieren", "Gruppn auswhln",
    "Choisir groupes", "Seleziona gruppi", "Seleccionar Grupos", "׷ ", "ٰ I", 0 },
  // AnchorSELECTOBJECTS
  { "Select Objects", "Objekte selektieren", "Objekte auswhln",
    "Choisir objets", "Seleziona oggetti", "Seleccionar Objetos", "ü ", "޼ު I", 0 },

  /* Hint how to select anchors */
  // AnchorHintACTIVATION
  { "Activate anchors with ctrl+click", "Anker aktivieren mittels ctrl+click", "nka auswhln mit ctrl+click",
    "Faites ctrl+clic pour activer une ancre", "Attiva ancore con ctrl+click", "Activar Anclas con ctrl+click",
    "ctrl+click  Ŀ Ȱȭ", "ctrl+click ݶ èނɂ", 0 },

  /* Buttons */
  // ButtonROTATE
  { "rotate", "Rotation", "drahn", "Pivoter", "Rotazione", "Rotacin", "ȸ", "]", 0 },
  // ButtonSHOWANCHORS
  { "Anchors", "Anker", "nka", "Ancres", "Ancore", "Anclas", "Ŀ", "ݶ", 0 },
  // ButtonTRANSL
  { "transl", "Transl", "vaschiabn", "Dplacer", "Transl", "Transl", "ȯ", "]", 0 },
  // ButtonZOOM
  { "zoom", "Zoomen", "zuwaziagn", "Zoom", "Zoom", "Zoom", ".Ȯ", "ް", 0 },

  /* Colors */
  // ColBLACK
  { "black", "schwarz", "schwoaz", "noir", "nero", "negro", "", "ÂF", 0 },
  // ColCYAN
  { "cyan", "trkis", "trkis", 0, "turchese", "turquesa", "ûϻ", "F", 0 },
  // ColGRAY
  { "grey", "grau", "grau", "gris", "grigio", "gris", "ȸ", "͂F", 0 },
  // ColGREEN
  { "green", "grn", "grn", "vert", "verde", "verde", "", "ΐF", 0 },
  // ColLIGHTGRAY
  { "lt.grey", "hellgrau", "hllgrau", "gris ple", "grigio chiaro", "gris claro",
    " ȸ", "󂢂͂F", 0 },
  // ColMAGENTA
  { "magenta", "rosa", "rosa", 0, "magenta", "magenta", "ȫ", "ϼF", 0 },
  // ColORANGE
  { "orange", "orange", "oronsch", 0, "arancio", "naranja", "", "ݼސF", 0 },
  // ColPURPLE
  { "purple", "lila", "lila", "mauve", "porpora", "prpura", "ֻ", "F", 0 },
  // ColREDBROWN
  { "red-brown", "rot-braun", "rot-braun", "brun rouge", "rosso-marrone", "marrn rojizo",
    " ", "ԂF", 0 },
  // ColYELLOW
  { "yellow", "gelb", "glb", "jaune", "giallo", "amarillo", "", "F", 0 },
  // ColWHITE
  { "white", "wei", "wei", "blanc", "bianco", "blanco", "", "F", 0 },

  /* Color Submenus */
  // ColorANCHOREDGES
  { "Anchor Edges", "Anker-Kanten", "nka Kantn", "Artes des ancres", "Bordi ancore", "Lados del Ancla",
    "Ŀ ", "ݶ", 0 },
  // ColorANCHORFACES
  { "Anchor Faces", "Anker-Flchen", "nka Flchn", "Surface des ancres", "Lati ancore", "Caras del Ancla",
    "Ŀ ̽", "ݶ", 0 },
  // ColorBACKGROUND
  { "Background", "Hintergrund", "Hintagrund", "Fond", "Sfondo", "Fondo", "", "wiF", 0 },
  // ColorGLOBALAMBIENT
  { "Ambient (global light)", "Ambientes Licht", "Umgebungsliacht", "Lumire ambiante", 0, 0 /* I, E */,
    "ȯ(global light)", "(۰ 邢)", 0 },
  // ColorHEADSUP
  { "Heads-up Display", "Kontrollsymbole", "Die klanen Kastln", "Console", "Simboli di controllo", "Controles",
    "Heads-Up ȭ ", "ォިڲ", 0 },
  // ColorOTHER
  { "Choose...", "auswhlen...", "auswhln...", "Slection...", "Scelta...", "Elejir...", "...", "I", 0 },
  /* { "other...", "andere...", "ndare...", "autres...", "altri...", "otros...", 0, " ...", 0 }, */
  // ColorVIEWINGLIGHT
  { "Viewing Light", "Standard-Lichtquelle", "Liacht zum Schaun", "Lumire standard", "Fonte di luce", "Fuente de Luz",
    "", "邭\\", 0 },

  /* Demo Menu Items */
  // DemoCAR_VW
  { "Car (VW)", "VW-Kfer", "FauWeh-Kfa", "Automobile (VW)", "Automobile", "Coche (VW)", "ڵ", "", 0 },
  // DemoCLOCKTOWER
  { "Clock Tower", "Uhrturm", "Uahtuam", "Clocher", "Torre dell'orologio", "Torre del Reloj",
    "ðž", "v", 0 },
  // DemoCORVETTE
  { "Corvette", "Corvette", "Korwett", 0, "Corvette", "Corvette", "", "ޯĊ", 0 },
  // DemoCUBE
  { "Cube", "Wrfel", "Wirfl", 0, "Cubo", "Cubo", "ť", "", 0 },
  // DemoENGINE
  { "Engine", "Motor", "Motoa", "Moteur", "Motore", "Motor", "", "ݼ", 0 },
  // DemoIICMFOYER
  { "IICM Foyer", "IICM Vorraum", "EiEiSiEm Vuarraum", "Foyer de l'IICM", "IICM Foyer", "Vestbulo de IICM",
    "IICM  ", "IICM xe", 0 },
  // DemoIICMINST
  { "IICM Institute", "IICM Institut", "EiEiSiEm Inschtitut", "L'Institut IICM", "Istituto IICM", "Instituto IICM",
    "IICM ", "IICM wZ", 0 },
  // DemoKANDHLEIT
  { "Office Andrews/Leitner", "Bro Andrews/Leitner", "Bhro Andrews/Leitner",
    "Bureau Andrews/Leitner", "Ufficio Andrews/Leitner", "Oficina Andrews/Leitner", "繫", "", 0 },
  // DemoROOM
  { "Room", "Zimmer", "Zimma", "Pice", "Stanza", "Habitacin", "", "", 0 },
  // DemoWORLD
  { "World", "Globus", "Wltkugl", "Monde", "Mondo", "Mundo", "", "n", 0 },

  /* dialog buttons */
  // DialogButtonOPEN
  { "Open", "ffnen", "Aufmchn", "Ouvrir", "Apri", "Abrir", "", "J", 0 },
  // DialogButtonSAVE
  { "Save", "Speichern", "Speichan", "Sauvegarder", "Salva", "Guardar", "", "ۑ", 0 },

  /* dialog strings (labels) */
  // DialogStringBSPRECALCULATION
  { "SV-BSP recalculation", "SV-BSP Neuberechnung", "SV-BSP Neiberechnung", 0, 0, 0, 0, 0, 0 },
  // DialogStringCOLLISIONDISTANCE
  { "Collision Distance", "Kollisions-Distanz", "Koulischn-Entfernung",
    "Distance de collision", "Distanza di collisione", 0, "浹 Ÿ", "Փˋ", 0 },
  // DialogStringFILENAME
  { "Filename:", "Dateiname:", "Feilnm:", "Fichier:", "Nome del file", "Fichero:", " ̸", "̧ٖ", 0 },
  // DialogStringNAVSPEEDFACTOR
  { "Navigation Speed Factor", "Beschleunigungsfaktor", "Beschleinigungsfaktor",
    "Facteur de vitesse de navigation", "Fattore velocit' di navigazione", 0,
    " ӵ ", "޹ް ߰ޗvf", 0 },
  // DialogStringOVERWRITEEXISTENTFILE
  { "Overwrite existent File?", "Bestehende Datei berschreiben?", "ba vorhndenes Feil drbaschreibn?",
    "Remplacer le fichier existant?", "Riscrivi il file esistente?", "Reemplazar fichero existente?",
    "ϴ Ͽ  ðڽϱ?", "݂ ̧ق̏ɏ܂H", 0},
  // DialogStringQUADSLICES
  { "Quadrics Complexity", "Zylinder-Spalten", "Kuglsplten", 0, 0, 0,  /* F, I, E */
    " п", " \\", 0 },
  // DialogStringROTATIONSPEED
  { "Rotation Speed", "Rotationsgeschwindigkeit", "Routationsgeschwindigkeit",
    "Vitesse de rotation", "Velocita' di rotazione", 0, "ȸ ӵ", "]߰", 0 },
  // DialogStringZOOMSPEED
  { "Zoom Speed", "Zoomgeschwindigkeit", "Zoomgeschwindigkeit",
    "Vitesse de zoom", "Velocita' dello zoom", 0, ".Ȯ ӵ", "ްѽ߰", 0 },
  // DialogStringCONVERGENCEPLANE
  { "Stereo: Convergence Plane", "Stereo: Konvergenzebene", "Stereo: Kounvergenz", 0, 0, 0, 0, 0, 0 },  /* F, I, E */
  // DialogStringSCREENEYE
  { "Stereo: Eye distance", "Stereo: Augenabstand", "Stereo: Augnbstnd", 0, 0, 0, 0, 0, 0 },

  /* dialog title */
  // DialogTitleCOLOURCHOOSER
  { "Colour Chooser", "Farbe whlen", "Foab auswhln",
    "Slecteur de couleurs", "Selezionatore dei colori", "Seleccionar Color", " ñ", "FI@", 0 },
  // DialogTitleNAVIGATIONSETTINGS
  { "VRweb Settings", "VRweb Einstellungen", "VRweb Einstllungan",
    "VRweb Paramtres", "Configurazione del VRweb", "VRweb Valores de Ajuste", "VRweb ", "VRweb ݒ", 0 },
  // DialogTitleOPENFILE
  { "Open File", "Datei ffnen", "Feil aufmchn", "Ouverture de fichier", "Apri file", "Abrir Fichero",
    " ", "̧يJ", 0 },
  // DialogTitlePARSEROUTPUT
  { "Parser Output", 0, 0, "Sortie de l'analyse grammaticale", "Uscita del parser", 0,
    "и ", "͌", 0 },
  // DialogTitleSAVEFILE
  { "Save Scene", "Szene speichern", "Szene speichan", "Sauvegarder la scne", "Salva la scena", "Guardar Escena",
    "Scene ", "ݕۑ", 0 },

  /* display modes */
  // DisplayBOUNDINGBOX
  { "Bounding Boxes", "Begrenzungswrfel", "Schochtln ummadum",
    "Cubes dlimitants", "Cubo delimitante", "Cubo Delimitante", " ũ ", "޳ ", 0 },
  // DisplayFLATSHADING
  { "Flat Shading", "konstant schattiert", "gleiche Foab",
    "Nuances constantes", "Ombreggiatura piatta", "Sombreado Constante", "ϴ ũ", "ׯ Ae", 0 },
  // DisplayHIDDENLINE
  { "Hidden Line", "hidden line (Umrisse)", "nua die Kanten ummadum",
    "Lignes caches", "Linea nascosta", "Hidden Line (Permetro)", " ", "B", 0 },
  // DisplayINTERACTIVE
  { "Interactive", "interaktiv", "beim ummadumfoahn", "Interaction", "Interattivo", "Interactivo",
    "ȣۿ", "ݍp", 0 },
  // DisplaySMOOTHSHADING
  { "Smooth Shading", "verlaufend schattiert", "vaschmiate Foab",
    "Nuances varies", "Ombreggiatura smooth", "Sombreado Progresivo",
    "ϴ ۰", "ׂׂ Ae", 0 },
  // DisplayTEXTURING
  { "Texturing", "Texturen", "Bldln auf die Flchn", "Texturation", "Applica motivo", "Texturas",
    " ȯ", "øݸ", 0 },
  // DisplayTHESAME
  { "The same", "Dieselbe", "die gleiche", "Mme chose", "Lo stesso", "El mismo", "", "", 0 },
  // DisplayWIREFRAME
  { "Wireframe", "Kantenmodell", "olle Kanten", "Fil de fer", "Scheletro", "Modelo Alambre", " Ʋ", "ܲ԰ڰ", 0 },

  /* Document Information */
  // DocumentANNOTATIONS
  { "Annotations", "Annotationen", "nmerkungan", 0 /*ok*/, "Annotazioni", "Notas", "ּ", "", 0 },
  // DocumentATTRIBUTES
  { "Attributes", "Attribute", "Attribute", "Attributs", "Attributi", "Atributos", "Ӽ", "", 0 },
  // DocumentPARENTS
  { "Parents", "Vorfahren", "Vurfhrn", 0 /*ok*/, "Genitori", "Padres", "θ", "e", 0 },
  // DocumentREFERENCES
  { "References", "Referenzen", "Referenzen", "Rfrences", "Referenze", "Referencias", "", "̧ݽ", 0 },
  // DocumentTEXTURES
  { "Textures", "Texturen", "Bldln auf die Flchn", "Texturation", "Motivi", "Texturas", "", "ø", 0 },

  /* Edit Menu Items */
  // EditCAMERA
  { "Camera", "Kamera", "Kmera", "Camra", 0, "Cmara", "", "", 0 },
  // EditOBJMANIP
  { "Obj. Manipulation", "Obj.manipulation", "Obj.manipulatioun", 0, 0, 0, "", "I", 0 },
  // EditQUIT
  { "Quit Editing", "Bearbeiten beenden", 0, 0, 0, 0, " ", "ҏWI", 0 },

  /* Edit toolbar buttons */
  // EditbuttonINSERT
  { "Insert", 0, 0, 0, 0, 0, 0, 0, 0 },
  // EditbuttonANCHOR
  { "Anchor", "Anker", "nka", "Ancres", "Ancore", "Anclas", "Ŀ", "ݶ", 0 },
  // EditbuttonTEXTURE
  { "Texture", "Textur", "Textua", "Texture", "Texture", "Textura", 0, 0, 0 },
  // EditbuttonMATERIAL
  { "Material", 0, 0, "Matriaux", "Materiali", "Materiales", 0, 0, 0 },
  // EditbuttonSTRUCTURE
  { "Structure", "Struktur", "Struktua", 0, 0, 0, 0, 0, 0 },
  // EditbuttonTRANSFORM
  { "Transform", 0, 0, 0, 0, 0, 0, 0, 0 },
  // EditbuttonVIEWPOINT
  { "Viewpoint", "Kamera", "Kmera", "Camra", "Telecamera", "Cmara", "", "", 0 },
  // EditbuttonGRID
  { "Grid", "Gitter", "Gitta", 0, 0, 0, 0, 0, 0 },

  /* Edit dialogs */
  // EditdialogINSERTOBJECT
  { "Insert Object", 0, 0, 0, 0, 0, 0, 0, 0 },
  // EditdialogANCHOREDITOR
  { "Anchor Editor", "Anker-Editor", "nka-Editoa", 0, 0, 0, 0, 0, 0 },
  // EditdialogTEXTUREEDITOR
  { "Texture Editor", "Textur-Editor", "Textua-Editoa", 0, 0, 0, 0, 0, 0 },
  // EditdialogMATERIALEDITOR
  { "Material Editor", "Material-Editor", "Material-Editoa", 0, 0, 0, 0, 0, 0 },
  // EditdialogSTRUCTUREVIEWER
  { "Structure Viewer", "Struktur (Hierarchie)", "Struktua (Hierarchie)", 0, 0, 0, 0, 0, 0 },
  // EditdialogTRANSFORMEDITOR
  { "Transform Editor", "Trasformations-Editor", "Trasformations-Editoa", 0, 0, 0, 0, 0, 0 },
  // EditdialogVIEWPOINTSETTINGS
  { "Viewpoint Settings", "Kamera-Parameter", "Kmera-Parameta", 0, 0, 0, 0, 0, 0 },
  // EditdialogGRIDSETTINGS
  { "Grid Settings", "Gitter-Parameter", "Gitta-Parameta", 0, 0, 0, 0, 0, 0 },

  /* File Menu Items */
  // FileDEMO
  { "Demo", "Demo", "Zag her", "Dmonstrations", "Demo", "Demo", "", "", 0 },
  // FileEDIT
  { "Edit", "Bearbeiten", "Editian", "dition", "Edito", "Editar", "", "ҏW", 0 },
  // FileEXITVIEWER
  { "Exit Viewer", "Beende Viewer", "her auf!", "Terminer", "Viewer di uscita", "Terminar Viewer",
    "Viewer ", "ޭ I", 0 },
  // FileEXPORT
  { "Export...", 0, "Expoat...", "Exporter...", "Esportare...", "Exportar...",
    "ڷṭ", "", 0 },
  // FileMAIL
  { "Mail to...", "Mail an...", "Schick' a mail n...", "Poster ...", "Invia posta...", "Enviar a...",
    "..  ", "ҰّM...", 0 },
  // FileOPEN
  { "Open...", "ffnen...", "Mch auf...", "Ouvrir...", "Apri...", "Abrir...", "...", "J", 0 },
  // FilePARSERERRORS
  { "View Parser Output...", "Parser Output anzeigen...", "Parsa Autput nzagn...",
    "Sortie de l'analyseur grammatical...", "Uscita parser...", "Ver Output del Parser...",
    "м  ", "͌ʕ\\", 0 },
  // FilePRINT
  { "Print...", "Drucken...", "Druck's...", "Imprimer...", "Stampa...", "Imprimir...", "...", " ...", 0 },
  // FileSAVE
  { "Save", "Speichern", "Speicher's", "Sauvegarder", "Salva", "Guardar", "", "ۑ", 0 },
  // FileSAVEAS
  { "Save as...", "Speichern unter...", "Speicher's als...", "Sauvegarder sous...", "Salva come...", "Guardar como...",
    "̸", "Otĕۑ", 0 },
  // FileUSABILITYTESTS
  { "Usability Test", "Benutzer-Test", "Benutza-Test", "Test d'usage", "Test di uso", "Test Usuario",
    "밡ɼ ", "Lpý", 0 },

  /* window title */
  // HARMONY3DVIEWER
  { "Harmony VRweb", "Harmony VRweb", "Arnie/Hamroni VRweb", 0, "VRweb Harmony", "Harmony VRweb",
    "ϸ VRweb", "ʰư VRweb", 0 },
  // VRWEBSCENEVIEWER
  { "VRweb Scene Viewer", "VRweb Szenen-Viewer", "VRweb Szenen-Wiua",
    "Visionneur de scnes VRweb", "Viewer di scena del Vrweb", "VRweb Scene Viewer",
    "VRweb ü  ", "VRweb  ޭ", 0 },

  /* Help Menu Items */
  // HelpABOUTPRODUCT
  { "About", "Info ber...", "Info ba...", " propos...", "Info...", "Info...", "VRweb Ͽ", "", 0 },
  // HelpINDEX
  { "Index", "Index", "Index", 0, "Indice", "Indice", "", "", 0 },
  // HelpOVERVIEW
  { "Overview", "bersicht", "basicht", "Survol", "Panorama", "Panorama", " ", "T", 0 },

  /* Menubar Items */
  // MenuANCHORS
  { "Anchors", "Anker", "nka", "Ancres", "Ancore", "Anclas", "Ŀ", "ݶ", 0 },
  // MenuCOLOR
  { "Colour", "Farben", "Foab", "Couleurs", "Colore", "Color", "", "F", 0 },
  // MenuDISPLAY
  { "Display", "Anzeige", "nzeige", "Affichage", "Schermo", "Monitor", "ȭ ", "ިڲ", 0 },
  // MenuDOCUMENT
  { "Document", "Dokument", "Doukument", 0 /*ok*/, "Documento", "Documento", "", "޷", 0 },
  // MenuFILE
  { "File", "Datei", "Feil", "Fichier", "File", "Fichero", "", "̧", 0 },
  // MenuHELP
  { "Help", "Hilfe", "Hlfe", "Aide", "Aiuto", "Ayuda", "", "", 0 },
  // MenuNAVIGATE
  { "Navigate", "Navigation", "Ummadumkumman", "Navigation", "Navigare", "Navegacin", "", "޹ް", 0 },
  // MenuOPTIONS
  { "Options", "Optionen", "Optionen", 0, "Opzioni", "Opciones", "ɼ", "߼", 0 },
  // MenuSPECIAL
  { "Special", "Extras", "Spezill", "Particularits", "Speciale", "Extras", "", "ʂ", 0 },
  // MenuVIEW
  { "View", "Ansicht", "nsicht", 0, "Vista", "Vista", 0, 0, 0 },
  // MenuVIEWPOINTS
  { "Viewpoints", "Ansichten", "nsichten", "Points de vue", "Punti di vista", "Perspectivas", "", "ϓ_", 0 },

  /* Messages (Errors, Warnings, Hints) */
  // MessageERRORNOINPUTFILE
  { "Original input not available for saving\n(got it through pipe; use Export)",
    "Originaldaten nicht mehr verfgbar\n(stammen aus pipe; Ersatz: Export)",
    "Die Originaldaten hb i nimma\n(pipe; nimm'n Expoat)",
    "Entre originale non disponible\n(obtenue par pipeline; servez vous de Exporter).",
    "Dati originali non disponibili per essere salvati\n(ottienili col pipe; usa export)",
    "Datos originales ya no estn a disposicin \npara ser almacenados (provenientes de pipe; usar Export)",
    " Է Ҽ ϴ.(Export Ͻʽÿ)",
    "ؼ ͂ ۑ K؂ȂłB", 0 },
  // MessageERRORONREADING
  { "Error on reading ", "Fehler beim Lesen von ", "Fhla beim Lesn va ",
    "Erreur pendant la lecture de ", "Errore nella lettura di ", "Error al leer ",
    "б  ", "ǂݒװ ", 0 },
  // MessageERRORONWRITING
  { "Error on writing ", "Fehler beim Schreiben von ", "Fhla beim Schreibn va ",
    "Erreur pendant l'criture de ", "Errore nella scrittura di ", "Error al grabar ",
    "  ", "װ ", 0 },
  // MessageSUCCESSFULLYWRITTEN
  { "File written: ", "Datei gespeichert: ", "Feil gschpeichat: ",
    "Fichier crit: ", "File scritto: ", "Fichero almacenado: ", " : ", "̧ : ", 0 },
  // MsgboxtitleERROR
  { "Error", "Fehler", "Fhla", "Erreur", "Errore", "Error", "", "װ", 0 },

  /* Navigation Modes */
  // NavFLIPOBJECT
  { "Flip", "Objekt bewegen", "Schupfn", "Pivoter objet", "Oggetto colpito", "Mover Objeto", "ø", "د", 0 },
  // NavFLY
  { "Fly", "Fliegen", "Fliagn", "Voler", "Volare", "Volar", "ö", "ײ", 0 },
  // NavFLYTO
  { "Fly To", "Fliegen auf Ziel", "Flieg duathin", "Voler vers", "Volare verso", "Volar hacia",
    ".. ö", " ײ", 0 },
  // NavHEADSUP
  { "Heads Up", "Kontrollsymbole", "Kastln (Box!)", "Console", "Controlli", "Controles",
    "ȣ ", "ォ", 0 },
  // NavWALK
  { "Walk", "Gehen", "Hatschn", "Marcher", "Camminare", "Caminar", "̵", "", 0 },

  /* Hints for using navigation modes */
  // NavHintFLIPOBJECT
  { "Drag mouse to translate/rotate/zoom the model",
    "Objekt verschieben/rotieren/zoomen durch Ziehen der Maus",
    "Vaschiab'/drah'/ziach's Objekt mit da Maus",
    "Maintenir enfonc le bouton de souris pour dplacer/faire pivoter/faire un zoom sur l'objet",
    "Muovi mouse per translare,ruotare,ingrandire,rimpicciolire ogg.",
    "Mover el ratn para trasladar/rotar/agrandar-achicar el objeto",
    "ȯ/ȸ/.Ȯϱ ؼ 콺  ̽ʽÿ.",
    "قړ/]/ްт悤 ϳׯĂ", 0 },
  // NavHintFLY
  { "Use mouse buttons to activate/accelerate/decelerate flight",
    "Flug aktivieren/beschleunigen/abbremsen mit den Maustasten",
    "Fliagn einscholtn/beschleinign/bremsn mit die Maustastn",
    "Utilisez les boutons de souris pour enclencher le vol/acclrer/dclrer",
    "Usare il mouse per attivare/accelerare/decelerare il volo",
    "Usar el ratn para activar/acelerar/desacelerar el vuelo",
    "Ȱȭ//ϱ ؼ 콺 ư Ͻʽÿ.",
    "sè//悤 ϳ݂gpĂB",
    0 },
  // NavHintFLYTO
  { "Press mouse buttons to set target/fly to it/fly away from it",
    "Ziel positionieren/anfliegen/verlassen mit den Maustasten",
    "Zl setzen/oufliagn/davoufliagn mit die Maustastn",
    "Utilisez les boutons de souris pour fixer la cible/l'approcher/l'loigner",
    "Clickare per posizionare obiettivo volare/verso - volare/via",
    "Usar botones del ratn para ajustar/volar hacia/abandonar el objetivo",
    "ö  ϱ ؼ 콺 ư ʽÿ.",
    "ړIݒ肵悤ϳ݂ĂB", 0 },
  // NavHintFLYTOINHU
  { "Set target/fly to it/fly away with mouse buttons; double-click to return to icons",
    "Ziel positionieren/anfliegen/verlassen mit den Maustasten; Doppelklick fr Rckkehr zu Symbolen",
    "Zl setzen/oufliagn/davoufliagn mit die Maustastn; doupplt klickn um za die Kastln zruckzkumman",
    "Fixez/volez vers/loignez vous de la cible avec les boutons de souris; cliquez deux fois pour revenir aux icnes",
    "Posizionare l'obiettivo e volare/verso - volare/via col bottone del mouse; doppio click per tornare alle icone",
    "Usar botones del ratn para ajustar/volar hacia/abandonar el objetivo; doble-click para retornar a los iconos",
    "콺 ư  ö  ϰ,   ؼ Ŭ ι Ͻʽÿ.",
    "ϳ݂ ړI ݒ肵Ă ; "
    "݂ɕς悤ٰدĂB", 0 },
  // NavHintHEADSUP
  { "Drag mouse out of icons for movement (or select fly-to icon)",
    "Fr Navigation Maus aus Symbol hinausziehen (oder Ziel-Symbol clicken)",
    "Zum Ummadumkumman Maus va de Kastln aussiziagn (oder aufs Zl-Kastl druckn)",
    "Sortez le pointeur d'un icne avec un bouton enfonc pour naviguer (ou choisissez l'icne Voler vers)",
    "Sposta mouse da icone per movimento (o selez. volare/verso)",
    "Retirar el ratn de los iconos para navegar ( seleccionar icono 'Volar hacia')",
    "̱ؼ 콺  ̽ʽÿ.(Ȥ fly-to  Ͻʽÿ)",
    "ړ̂߂ɱ݂ϳׯĂ (ײ ݑI)", 0 },
  // NavHintWALK
  { "Drag mouse to walk/move/look around",
    "Gehen/verschieben/schauen durch Ziehen der Maus",
    "Ziag die Maus zum Hatschn/Vaschiabn/Augn vadrahn",
    "Maintenez enfonc un bouton pour marcher/vous dplacer/tourner la tte",
    "Spostare il mouse per camminare/muovere/guardare",
    "Mover ratn para caminar/trasladar/mirar",
    "̵/̱/ѷؼ 콺  ̽ʽÿ.",
    "/ړ/񂵂悤ϳׯ Ă", 0 },

  /* Navigation Functions */
  // NavigateBACK
  { "Back", "Rckwrts", "Z'ruck", "Prcdent", "Indietro", "Atrs", "ڷ", "", 0 },
  // NavigateFORWARD
  { "Forward", "Vorwrts", "Firi", "Suivant", "Avanti", "Adelante", "", "O", 0 },
  // NavigateHISTORY
  { "History", "Befehlsgeschichte", "G'schicht", "Historique", "Storia", "Historia", "", "˽", 0 },
  // NavigateHOLD
  { "Hold", "Halte Dokument", "Hoits", "Maintenir cette fentre", "Mantenere", "Mantener", "", "ێ", 0 },

  // NavigateLEVELVIEW
  { "Level View", "Horizontale Ansicht", "Mch's ebn", "Niveler la vue", "Vista dell'orizzonte", "Vista Horizontal",
    "ܰ ", "iK\\", 0 },
  // NavigateRESETVIEW
  { "Reset View", "Ansicht zurcksetzen", "Ansicht zrucksetzen",
    "Rtablir la vue", "Ristabilire vista orig.", "Reajustar Vista", "缳", "\\ ", 0 },
  // NavigateUNTILTVIEW
  { "Untilt View", "Neigung zurcksetzen", "Mch's grod",
    "Rtablir l'inclinaison", "Riaggiustare l'inclinazione", "Reajustar Inclinacin",
    "￩ ", "XΕ\\", 0 },
  // NavigateVIEWPOINT
  { "Camera", "Kamera", "Kmera", "Camra", "Telecamera", "Cmara", "", "", 0 },
  // NavigateVIEWSELECTION
  { "View Selection", "Selektion zentrieren", "Selektion zentriean", 0, 0, 0, 0, 0, 0 },
  // NavigateVIEWWORLD
  { "View World", "Gesamt-Ansicht", "Gesmt-nsicht", 0, 0, 0, 0, 0, 0 },
  // NavigateSETTINGS
  {  "Settings...", "Einstellungen...", "Einstllungan...", "Paramtres...", "Configurazione...", "Valores...",
     "...", "ݒ蒆 ...", 0 },
  // NavigateSPACEBALL
  { "Spaceball...", 0, 0, 0, 0, 0, "̽", "߰ް", 0 },

  /* options */
  // OptionAALIASING
  { "Anti-aliasing", 0, "gltt mchn", "Adoucissement", "Addolcimento", 0, "", "ʏ̂Ȃ", 0 },
  // OptionAALINES
  { "Lines", "Linien", "Linien", "des lignes", "di linee", 0, "", "", 0 },
  // OptionAAPOLYGONS
  { "Polygons", "Polygone", "Polgone", "Faces", "Poligoni", "Polgonos", 0, 0, 0 },
  // OptionAATEXTURES
  { "Textures", "Texturen", "Flchn-Bldln", "Texturation", "Motivi", "Texturas", "", "ø", 0 },
  // OptionARBITRARYROTATIONS
  { "Free Rotation Control", "Beliebige Rotationen", "Drah's wias'd wlsd",
    "Libre contrle de la rotation", "Controllo libero della rotazione", "Rotacin Libre",
    " ȸ ", "R]۰", 0 },
  // OptionCOLLISIONDETECTION
  { "Collision Detection", "Kollisionen erkennen", "kane Bruchlndungen",
    "Dtection de collision", "Riconoscitore di collisione", 0, "浹 ", "Փ˖h~", 0 },
  // OptionDOLIGHTING
  { "Lighting Calculations", "Licht-Berechnungen", "Lichta ausrechnan",
    "Calcul de l'clairage", "Calcolo della luminosita'", "Clculos de Luz", " ", "邳vZ", 0},
  // OptionENABLEMOTION
  { "Enable Motion with Anchors", "Navigation bei Ankerhervorhebung", "Weita ummadumfoan",
    "Permettre mouvements avec ancres", "Permetti movimento con le ancore", "Navegacin Mediante Anclas",
    "Ŀ  ", "ݶӰ݊", 0 },
  // OptionNOMATERIALS
  { "no materials", "alles wei", "ois wei", /* F, I, E */ 0, 0, 0, /* K, J, H */ 0, 0, 0 },
  // OptionSHOWFRAMERATE
  { "Show Framerate", "Zeit pro Bild anzeigen", "zag wia schnll da'd bist",
    "Afficher frquence d'image", "Mostra la relazione tempo-immagine", "Ver Relacin Tiempo/Imgen",
    "  ", "ڰє{\\܂B", 0 },
  // OptionSHOWTITLE
  { "Show Title", "Titel anzeigen", "zag an Titl n", "Afficher titre", "Mostra titolo", 0,
    " ", "ٕ\\", 0 },
  // OptionTEXTURELIGHTING
  { "on texturing", "mit Texturen", "mit die Bldln", "sur textures", "con texture", "con texturas",
    "ȯ Ͽ", "øݸނɂ", 0 },
  // OptionTRANSPARENCY
  { "Transparency", "Transparenz", "Duachsichtigkeit", "Transparence", 0, 0 /* I, E */, "", "x", 0 },
  // OptionTWOSIDEDPOLYS
  { "Two-sided Polygons", "Zweiseitige Polygone", "zwoaseitige Polgone",
    "Calcul des deux faces", "Poligoni di due lati", "Polgonos de Doble Lado",
    "2 ٰ", "ʑp`", 0 },
  // OptionVELOCITYCONTROL
  { "Velocity Control", "Geschwindigkeitsregelung", "Regl die G'schwindigkeit",
    "Rglage de la vitesse", "Controllo della velocita'", "Control de Velocidad", "ӵ ", "x۰", 0 },

  /* progress labels */
  // ProgressCONTACTINGHOST
  { "contacting host: ", "Verbindungsaufbau: ", "Heat mi wer: ", 0, 0, 0,
    "ȣƮ ϰ ִ Դϴ. ", "νĂ ڑ: ", 0 },
  // ProgressDATATRANSFER
  { "data transfer: ", "Datentransfer: ", "Dat'n schaufln: ", 0, 0, 0, "ڷ :", "ް `", 0 },
  // ProgressPROCESSCAMERAS
  { "processing camera information", "Kameradaten verarbeiten", "Kmeradatn verorbeitn",
    "traitment de l'information des camras", "Elaborazione informazioni della telecamera",
    "procesando informacin de cmara", "  óϰ ֽϴ.", "׏ ", 0 },
  // ProgressREADINGACTORS
  { "reading scene actors", "Szenenbeschreibung einlesen", "Szenenbeschreibung einlesn",
    "lecture des acteurs de la scne", "Lettura attori della scena", "leyendo descripcin de escena",
    "Scene а ִ Դϴ.", "  ǂ", 0 },
  // ProgressREADINGCAMERAS
  { "reading camera information", "Kameradaten einlesen", "Kmeradatn einlesn",
    "lecture de l'information des camras", "Lettura informazioni della telecamera", "leyendo informacin de cmara",
    "  а ִ Դϴ.", "׏ ǂ", 0 },
  // ProgressREADINGLIGHTS
  { "reading light sources", "Lichtquellen einlesen", "Lichta einlesn",
    "lecture des sources de lumire", "Lettura sorgenti di luce", "leyendo fuentes de luz",
    "  д Դϴ.", "ײ  ǂ", 0 },
  // ProgressREADINGMATERIALS
  { "reading material definitions", "Materialdaten einlesen", "Materialdatn einlesn",
    "lecture des dfinitions de matriaux", "Lettura definizione dei materiali", "leyendo definicin de materiales",
    "ü Ǹ а ִ Դϴ.", "\\Afǂ", 0 },
  // ProgressREADINGOBJECTS
  { "reading object data", "Objektdaten einlesen", "Objektdatn einlesn",
    "lecture des donnes d'objets", "Lettura dati dell'oggetto", "leyendo datos de objeto",
    "ü ڷḦ а ִ Դϴ", "޼ު ްǂ", 0 },
  // ProgressREADINGPOSITIONS
  { "reading object positions", "Objektpositionen einlesen", "Objektpositionen einlesn",
    "lecture des positions d'objets", "Lettura posizione oggetti", "leyendo posiciones de objeto",
    "ü ġ а ִ Դϴ", "޼ުĈʒu ǂ", 0 },
  // ProgressREADINGTEXTURE
  { "reading texture image", "Texturbild einlesen", "Flchenbld'l einlesn",
    "lecture de l'image des textures", "Lettura immagine del texture", "leyendo imgen de textura",
    " ̹ а ִ Դϴ.", "øҰޓǂ", 0 },
  // ProgressREADINGVRML
  { "reading VRML scene", "VRML-Szene einlesen", "VRML-Datn einlesn",
    "lecture de la scne VRML", "Lettura della scena VRML", "leyendo escena VRML",
    "VRML ڷḦ а ִ Դϴ.", "VRML  ǂ", 0 },
  // ProgressREADY
  { "ready", "bereit", "featig", "prt", "pronto", "listo", "غ", "", 0 },
  // ProgressREQUESTINLINEVRML
  { "requesting inline VRML", "hole Inline-VRML", "hul' inlain VRML",
    "VRML en ligne demand", "Richiesta VRML inline", "buscando inline-VRML",
    "inline VRML ûϰ ִ Դϴ.", "ײ VRMLv", 0 },
  // ProgressREQUESTTEXTURE
  { "requesting texture", "hole Texturbild", "hul' Textuabld'l",
    "texture demande", "Richiesta texture", "buscando textura",
    " ûϰ ִ Դϴ.", "øv", 0 },

  // RenderRENDERMODE
  { "Render Mode", "Rendering", "Rendaring", 0, 0, 0, " ", "Ӱޕt^", 0 },
  // RenderSTEREO
  { "Stereo", 0, "Schtereo", 0, 0, 0, 0, 0, 0 },
  // RenderZBUFFER
  { "Depth Buffer", "Z-Buffer", "Z-Buffa", 0, 0, 0, "", "[ޯ̧", 0 },
  // RenderBSPTREE
  { "BSP Tree", "BSP Baum", "BSP Baam", 0, 0, 0, "BSP Ʈ", "BSP", 0 },
  // RenderBSPPLAIN
  { "plain BSP", 0, 0, 0, 0, 0, "ܻ BSP", " BSP", 0 },
  // RenderBSPBACKFACECULLING
  { "backface culling BSP", 0, 0, 0, 0, 0, "ø BSP", "ƑIBSP", 0 },
  // RenderBSPSHADOWVOLUME
  { "shadow volume BSP", 0, 0, 0, 0, 0, "׸  BSP", "Ae ح BSP", 0 },

  /* Selection */
  // SelectSELECTPARENT
  { "Select Parent", "Vater selektieren", "Vta selektian", 0, 0, 0, 0, 0, 0 },
  // SelectSELECTCHILD
  { "Select Child", "Kind selektieren", "Kind selektian", 0, 0, 0, 0, 0, 0 },
  // SelectSELECTPREVIOUS
  { "Select Previous", "Vorgnger selektieren", "Voagnga selektian", 0, 0, 0, 0, 0, 0 },
  // SelectSELECTNEXT
  { "Select Next", "Nachfolger selektieren", "Nchfolga selektian", 0, 0, 0, 0, 0, 0 },

  /* Spaceball */
#ifdef SPACEBALL
  // SpaceballDECREASE
  { "decrease", "verringern", "weniga", 0, "diminuire", 0, "", "", 0 },
  // SpaceballINCREASE
  { "increase", "erhhen", "mehr", 0, "incrementare", 0, "", "", 0 },
  // SpaceballRESETSENSITIVITY
  { "reset", "zurcksetzen", "zrucksetzen", 0, "reset", "reajustar", "缳", "", 0 },
  // SpaceballREZERO
  { "rezero", "Ruhelage", "Ruhelage", 0, "riazzerare", 0, "", "~", 0 },
  // SpaceballROTATION
  { "Rotation", 0, 0, 0, 0, 0, "ȸ", "]", 0 },
  // SpaceballSENSITIVITY
  { "Sensitivity", "Empfindlichkeit", "Empfindlichkeit", 0, "Sensibilita'", 0, "ΰ", "qx", 0 },
  // SpaceballSINGLEAXISFILTER
  { "Single Axis Filter", "Dominante Achse", "Dominante Achse", 0, "Filtro singolo asse", 0,
    "  ", "Pꎲ̨", 0 },
  // SpaceballTRANSLATION
  { "Translation", 0, 0, 0, 0, 0, "ȯ", "ړ", 0 },
#else
  { "" },
  { "" },
  { "" },
  { "" },
  { "" },
  { "" },
  { "" },
  { "" },
#endif

  /* status line info */

  // StatuslineBSPTREE
  { "BSP Tree", "BSP Baum", "BSP Baam", 0, 0, 0, "BSP Ʈ", "BSP", 0 },
  // StatuslineBSP_BACKFACES
  { "backface", "rckseitig", "va hintn", 0, 0, 0, "̽", "", 0 },
  // StatuslineBSP_HIDDENFACES
  { "hidden", "verdeckt", "vadeckt", 0, 0, 0, "", "B", 0 },
  // StatuslineBSP_VISIBLEFACES
  { "visible", "sichtbar", "sichtbr", 0, 0, 0, "̱", "", 0 },
  // StatuslineFPS
  { "fps", "F/s", "B/s", "i/s", "fps", 0, "F/s", "F/s", 0 },
  // StatuslineLASTFRAME
  { "last frame", "letzter Frame", "letztes Bldl", "dernire image", "Ultima immagine", 0,
    " ", "Ōڰ", 0 },
  // StatuslinePOLYGONS
  { "polygons", "Polygone", "Polgone", "polygones", "poligoni", "polgonos", "ٰ", "p`", 0 },
  // StatuslinePRIMITIVES
  { "primitives", "Grundobjekte", "ndare Objekte", "primitives", "oggetti base", "objetos base",
    "", "n", 0 },
  // StatuslineTEXTURED
  { "textured", "texturiert", "mit Bldln", "textures", 0, 0  /* I, E */, "", "ø", 0 },

  /* special menu items */
  // SpecialCAMERAINFO
  { "Camera Info", "Kamera Information", "Kamera Infou",
    "Info de camra", "Informazioni sulla telecamera", "Informacin sobre Cmara", " ", "׏", 0 },
  // SpecialPRINTALL
  { "Print All", "Alle Daten ausgeben", "Schmei olle Daten aussi", "Tout imprimer", "Stampa totale", "Imprimir Todo",
    " Ʈ", "ׂĂ", 0 },
  // SpecialPRINTDATA
  { "Print Data", "Datenstruktur ausgeben", "Schmei a poor Daten aussi",
    "Imprimer donnes", "Stampa dati", "Imprimir Datos", "ڷ Ʈ", "ް ", 0 },

  /* transparency methods (off: TwosidedOFF) */
  // TransparBLENDING
  { "blending/BSP", "berblenden/BSP", "bablendn/BSP", 0, 0, 0, 0, 0, 0 },
  // TransparSTIPPLE
  { "stipple", "Raster", "Rsta", 0, 0, 0, 0, 0, 0 },

  /* twosided polygons */
  // TwosidedAUTO
  { "auto", 0, 0, 0, 0, 0, "ڵ", "", 0 },
  // TwosidedOFF
  { "off", "aus", "aus", "dsactiv", "Spento", "desactivar", "", "off:", 0 },
  // TwosidedON
  { "on", "ein", "ein", "activ", "Acceso", "activar", "ѱ", "ւ", 0 },

  /* usability tests */
  // UTestEAST
  { "Test E", "Test O", "Test O", 0, 0, 0, " E", "ý E", 0 },
  // UTestNORTH
  { "Test N", 0, 0, 0, 0, 0, " N", "ý N", 0 },
  // UTestSOUTH
  { "Test S", 0, 0, 0, 0, 0, " S", "ý S", 0 },
  // UTestWEST
  { "Test W", 0, 0, "Test O", "Test O", 0, " W", "ý W", 0 },

}; // sstringtable



const char* STranslate::str (SStrSym strsym, HgLanguage::Language language)
{
  const char* res = sstringtable [strsym][language];

  if (res)
    return res;
  else
    return sstringtable [strsym][HgLanguage::Default];  // english
}
