// This may look like C code, but it is really -*- C++ -*-

//<copyright>
// 
// Copyright (c) 1994,95,96
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
//</copyright>

//<file>
//
// Name:        msgbox.h
//
// Purpose:     interface to message boxes
//
// Created:     19 Jan 94   Michael Pichler
//
// $Id: msgbox.h,v 1.8 1997/01/31 14:16:50 bmarsch Exp $
//
//</file>
//
// $Log: msgbox.h,v $
// Revision 1.8  1997/01/31 14:16:50  bmarsch
// New variant with glyph instead of string
//
// Revision 1.7  1996/08/16 08:06:28  bmarsch
// Changed order of labels Help and UserBack
//
// Revision 1.6  1996/06/27 14:35:36  bmarsch
// Call help action on pressing help button
//
// Revision 1.5  1996/03/12 13:42:13  bmarsch
// Bugfix: button release events are handled even if pointer
// is outside the message box
//
// Revision 1.4  1996/02/14 14:16:34  bmarsch
// Added keyboard shortcuts for all buttons
//
// Revision 1.3  1996/01/25 08:36:07  bmarsch
// Added Retry and Restore
//



#ifndef harmony_widgets_msgbox_h
#define harmony_widgets_msgbox_h

#include "libwidgets.h"

#include "wtranslate.h"

#include <InterViews/enter-scope.h>
class Action;
class Glyph;
class Handler;
class Window;



// class MessageBox
//
// MessageBox::message opens a modal dialog, i.e. all input for the
// application is grabbed during the dialog, and returns which
// button was pressed
//
// style name: MessageBox
//
// style attributes: font (IV)


class MessageBox {
public:
  enum {
    UserFront = 0x1,
    Ok = 0x2, Yes = 0x4, No = 0x8,
    Retry = 0x10, Restore = 0x20,
    Cancel = 0x40,
    UserBack = 0x80,                 // order is from left to right!
    Help = 0x100,
    NumDefined = 9,                   // number of defined bits
    // some typical combinations
    OkCancelHelp = Ok | Cancel | Help,
    YesNoHelp = Yes | No | Help,
    RetryCancelHelp = Retry | Cancel | Help
  };

  static int message(                 // message dialog
    HgLanguage::Language language,    //   language of button labels (as defined in hyperg/language.h)
    Window* parentwin,                //   parent window for alignment (nil means no alignment)
    const char* msg,                  //   message text (may contain '\n' chars for multiline text)
    const char* title = 0,            //   window title (default: same as application window)
    int buttons = OkCancelHelp,       //   the buttons the dialog contains
    int defbutton = Ok,               //   the default button (return)
    const char* userfront = nil,      //   label for UserFront button
    const char* userback = nil,       //   label for UserBack button
    char hotFront = 0,                //   hot key for front label
    char hotBack = 0,                 //   hot key for back label
    Action* helpAction = nil          //   action (called on help button)
  );
  static int message(                 // message dialog
    HgLanguage::Language language,    //   language of button labels (as defined in hyperg/language.h)
    Window* parentwin,                //   parent window for alignment (nil means no alignment)
    Glyph* message,                   //   message glyph
    const char* title = 0,            //   window title (default: same as application window)
    int buttons = OkCancelHelp,       //   the buttons the dialog contains
    int defbutton = Ok,               //   the default button (return)
    const char* userfront = nil,      //   label for UserFront button
    const char* userback = nil,       //   label for UserBack button
    char hotFront = 0,                //   hot key for front label
    char hotBack = 0,                 //   hot key for back label
    Action* helpAction = nil          //   action (called on help button)
  );

  static void sorryNotImplemented(    // reporting unimplemented feature
    HgLanguage::Language language,    //   language of "OK" label (as defined in hyperg/language.h)
    Window* parentwin,                //   parent window for alignment (nil means no alignment)
    const char* title = 0             //   optional window title
  );

private:
  static WTranslate::StrSym label_[NumDefined];
  static char hotKey_[NumDefined];
  static boolean grabbing(Handler*, Handler**);
  static Action* helpAction_;
};



#endif
