//translation.C.widgets
//<copyright>
// 
// Copyright (c) 1994,95,96
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
//</copyright>

//<file>
//
// Name:        wtranslate.C
//
// Purpose:     implementation of class WTranslate
//
// Created:     18 Feb 94   Michael Pichler
//
// Changed:     24 Oct 95   Tomas Torron-Mack (added Spanish)
//
// Changed:     15 Dec 95   ric Plante <planteer@JSP.UMontreal.CA> (added French)
//
// Changed:     04 Mar 96   Lia Spolidoro <lia@philos.unipv.it> (added Italian)
//
// Changed:     04 Mar 96   Michael Pichler
//
// $Id: wtranslate.C,v 1.14 1997/02/27 18:14:59 mpichler Exp $
//
//</file>
//
// $Log: wtranslate.C,v $
// Revision 1.14  1997/02/27 18:14:59  mpichler
// (c) 1997
//
// Revision 1.13  1996/10/08 09:02:30  bmarsch
// Bugfix
//
// Revision 1.12  1996/10/08 08:34:05  bmarsch
// Japanese labels
//
// Revision 1.8  1996/08/07 08:25:29  bmarsch
// Added Hungarian
//
// Revision 1.7  1996/08/06 14:00:05  bmarsch
// Changes in HgLanguage
//
// Revision 1.6  1996/03/04 17:13:46  mpichler
// Italian strings contributed by Lia Spolidoro <lia@philos.unipv.it>
//
// Revision 1.5  1996/01/25 08:18:27  bmarsch
// Added some labels
//



#include "wtranslate.h"



// English, German, Styrian, French, Italian, Spanish, Korean, Japanese

static const char* wstringtable [][HgLanguage::NumLanguages] =
{
  { "About Harmony",
    "Info ber Harmony",
    "Info ba Haarmoni",
    " propos de Harmony",
    "Informazioni su Harmony",
    "Info Acerca de Harmony",
    "ϸϿ Ͽ",
    "ʰưɂď",
    "" },
  { "All rights reserved",
    "Alle Rechte vorbehalten",
    "lle Rechte vurbehlten",
    "Tous droits rservs",
    "Tutti i diritti riservati",
    "Todos los derechos reservados",
    "  Ǿϴ.",
    "ׂĂ̱ Ă: "
    "" },
  { "Apply",
    "Anwenden",
    "Nimms her",
    "Appliquer",
    "Applicare",
    "Aplicar",
    "",
    "Kp",
    "" },
  { "Cancel",
    "Abbrechen",
    "Tuas weg",
    "Annuler",
    "Annulla",
    "Cancelar",
    "",
    "ݾ",
    "" },
  { "Copyright  1993-1997 IICM",
    "",
    "",
    "",
    "",
    "",
    "Copyright ^i 1993-1997 IICM",
    "쌠 : 1993-1997 IICM",
    "" },
  { "Deselect All",
    "Nichts auswhlen",
    "Nix auswhln",
    "Annuler toutes slections",
    "Deseleziona tutto",
    "Deseleccionar Todo",
    "  ",
    "ׂĂ̑I܂B",
    ""},
  { "Help",
    "Hilfe",
    "Hf ma",
    "Aide",
    "Aiuto",
    "Ayuda",
    "",
    "",
    "" },
  { "No",
    "Nein",
    "Naa",
    "Non",
    "No",
    "No",
    "ƴϿ",
    "",
    "" },
  { "OK",
    "OK",
    "Guat",
    "OK",
    "OK",
    "OK",
    "Ȯ",
    "͂",
    "" },
  { "Select All",
    "Alles auswhlen",
    "lles auswhln",
    "Tout slecter",
    "Seleziona tutto",
    "Seleccionar Todo",
    " ",
    "ׂĂI",
    "" },
  { "Selected",
    "selekiert",
    "slektiat",
    "Slect",
    "Selezionato",
    "Seleccionado",
    "õ",
    "I",
    "" },
  { "Stop",
    "Stop",
    "Her auf",
    "",
    "",
    "",
    "",
    "~",
    "" },
  { "Graz University of Technology",
    "Technische Universitt Graz",
    "Technische Universitt Graz",
    "Universit de Technologie de Graz",
    "Universita' Tecnologica di Graz",
    "Universidad Tecnolgica de Graz",
    "Graz  б",
    "Graz wZ",
    ""},
  { "Unselected",
    "deselekiert",
    "unslektiat",
    "Non slect",
    "Non selezionato",
    "No seleccionado",
    "",
    "I",
    "" },
  { "Yes",
    "Ja",
    "Joo",
    "Oui",
    "S",
    "Si",
    "",
    "͂",
    "" },
  { "New:",
    "Neu:",
    "Nei:",
    "Nouveau:",
    "Nuovo:",
    "Nuevo:",
    "ο:",
    "V :",
    "" },
  { "Old:",
    "Alt:",
    "Oid:",
    "Ancien:",
    "Vecchio:",
    "Antiguo:",
    ":",
    "Â :",
    "" },
  { "Close",
    "Schlieen",
    "Zuamchn",
    "",
    "Chiuso",
    "Cerrar",
    "ݱ",
    "",
    "" },
  { "Reset",
    "Zurcksetzen",
    "Zrucksetzn",
    "",
    "Riposizionare",
    "Reajustar",
    "ʱȭ",
    "",
    "" },
  { "Restore",
    "Wiederherstellen",
    "Wia frira",
    "",
    "Ristabilire",
    "",
    "",
    "Ē",
    "" },
  { "Retry",
    "Wiederholen",
    "Tuas nomoi",
    "",
    "Riprovare",
    "",
    "õ",
    "Ď}",
    "" }
};


const char* WTranslate::str (StrSym strsym, HgLanguage::Language language)
{
  const char* res = wstringtable [strsym][language];

  if (res && *res)
    return res;
  else
    return wstringtable [strsym][HgLanguage::Default];
}
