package org.apache.maven.wagon;

/*
 * Copyright 2001-2006 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;

import org.apache.maven.wagon.authorization.AuthorizationException;

/**
 * @author <a href="mailto:jason@maven.org">Jason van Zyl</a>
 * @version $Id: WagonMock.java 430944 2006-08-12 02:02:20Z carlos $
 */
public class WagonMock
    extends StreamWagon
{
    private boolean errorInputStream;

    public WagonMock()
    {
    }

    public WagonMock( boolean errorInputStream )
    {
        this.errorInputStream = errorInputStream;
    }


    public void fillInputData( InputData inputData )
        throws TransferFailedException
    {

        InputStream is;

        if ( errorInputStream )
        {
            InputStreamMock mockInputStream = new InputStreamMock();

            mockInputStream.setForcedError( true );

            is = mockInputStream;

        }
        else
        {
            byte[] buffer = new byte[1024 * 4 * 5];

            is = new ByteArrayInputStream( buffer );
        }

        inputData.setInputStream( is );

    }

    public void fillOutputData( OutputData outputData )
        throws TransferFailedException
    {

        OutputStream os;

        if ( errorInputStream )
        {
            OutputStreamMock mockOutputStream = new OutputStreamMock();

            mockOutputStream.setForcedError( true );

            os = mockOutputStream;
        }
        else
        {
            os = new ByteArrayOutputStream();
        }

        outputData.setOutputStream( os );

    }

    public boolean getIfNewer( String resourceName, File destination, long timestamp )
        throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException
    {
        return false;
    }

    public void openConnection()
    {
    }

    public void closeConnection()
    {
    }

    public List getFileList( String destinationDirectory )
        throws TransferFailedException, AuthorizationException
    {
        return Collections.EMPTY_LIST;
    }

    public boolean resourceExists( String resourceName )
        throws AuthorizationException
    {
        return false;
    }

}
