import os
import pygtk
import gtk
import gtk.glade
import gnome
import gnome.ui
import gconf
import gettext
import pwd
from gettext import gettext as _
from os import getenv
from commands import getoutput

name = "webboard"
version = "0.2"
image_dir = "/usr/share/pixmaps"
glade_dir = "/usr/share/" + name
#glade_dir = "../data/"


def about_info(self):
    about = gnome.ui.About("WebBoard",version,"GPL",\
                           _("Publish text notes and source code on a"\
                             " pastebin server for collaborative debugging"),
                            ["Sebastian Heinlein "
                             "<sebastian.heinlein@web.de>"],\
                            ["Sebastian Heinlein "
                             "<sebastian.heinlein@web.de>"],
                             _("translator_credits") ,self.logo_pixbuf)
    about.show()


class WebBoardConfig:
    def __init__(self):
        # setup the preferences glade interface
        self.glade = gtk.glade.XML(os.path.join(glade_dir,
                                   "wbconfig.glade"))
        self.glade.signal_autoconnect(self)
        self.dialog = self.glade.get_widget("dialog_preferences")
        self.entry = self.glade.get_widget("entry_url")
        self.entry.connect('changed', self.entry_activated_callback)
        self.close_button = self.glade.get_widget("button_close")
        self.close_button.connect("clicked", self.on_button_close_clicked)
        # setup gconf
        self.gconf = gconf.client_get_default()
        self.gconf.add_dir("/apps/webboard", gconf.CLIENT_PRELOAD_NONE)
        self.gconf.notify_add("/apps/webboard/pastebin", self.pastebin_changed)

        self.notifiers=[]

        # guess a user name
        self.user = self.guess_user()

        first_time = self.gconf.get_bool("/apps/webboard/first_time")
        self.gconf.set_bool("/apps/webboard/first_time", False)
        self.pastebin = self.gconf.get_string("/apps/webboard/pastebin")

        # Use the pastebin command line config as fallback or at the first time
        if self.pastebin == None or len(self.pastebin)== 0 or \
           first_time != False:
            for conf in ('/etc/pastebinrc', '%s/.pastebinrc' % getenv('HOME')):
                try:
                    (user, pastebin) = self.read_rc(conf)
                    if pastebin != None:
                        self.gconf.set_string("/apps/webboard/pastebin", pastebin)
                    if user != None:
                        self.user = user
                except:
                    pass

        if self.pastebin == None or len(self.pastebin)== 0:
            self.gconf.set_string("/apps/webboard/pastebin", "pastebin.com")


    def remove_notifier(self, func):
        self.notifiers.remove(func)

    def add_notifier(self, func):
        self.notifiers.append(func)

    def pastebin_changed(self, client, cnxn_id, entry, user_data):
        #print "pastebin changed: %s" % entry.value.get_string()
        if entry.value.type == gconf.VALUE_STRING:
            string = entry.value.to_string()
            if self.entry.get_chars(0,-1) != string:
                #print "%s -> %s" % (self.entry.get_chars(0,-1), string)
                self.entry.set_text(string)
            self.pastebin = string
        #print self.notifiers
        for func in self.notifiers:
            if func is not None:
                func()

    def notfiy(self, client, cnxn_id, entry, user_data):
        pass

    def read_rc(self, file):
        user = None
        pastebin = None
        try:
            for line in open(file,'r').readlines():
                pos = line.find('=')
                if pos > 0:
                    if line[:pos].strip() == 'poster':
                        user = line[pos+1:].strip()
                    if line[:pos].strip() == 'pastebin':
                        pastebin = line[pos+1:].strip()
        except:
            pass
        return user, pastebin

    def guess_user(self):
        full = pwd.getpwuid(os.getuid())[4].split(",")[0]
        if len(full) > 0:
            return full
        else:
            return pwd.getpwuid(os.getuid())[0]

    def preferences(self, *args):
        self.entry.set_sensitive(self.gconf.key_is_writable \
                                 ("/apps/webboard/pastebin"))
        self.entry.set_text(self.gconf.get_string ("/apps/webboard/pastebin"))
        self.dialog.show()

    def entry_activated_callback(self, entry, *args):
        s = self.entry.get_chars(0, -1)
        #print "old: %s - new: %s" % (self.pastebin, s)
        if s != self.pastebin:
         #   print "write: %s" % s
            self.gconf.set_string("/apps/webboard/pastebin", s)

    def on_button_close_clicked(self, widget, *args):
        self.dialog.hide()

    def on_dialog_preferences_delete_event(self, widget, *args):
        self.dialog.hide()
        return True
