/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef TABLEMODELSHELPER_H
#define TABLEMODELSHELPER_H

#include <QString>

#include "abstracttablemodel.h"

namespace WebIssues
{

/**
* Functions for formatting various values.
*
* This functions are mostly used by the table models and other
* UI elements which display information in a standarized way.
*/
class TableModelsHelper
{
public:
    /**
    * Format an item identifier.
    *
    * The identifier is prepended with a # like in links to items.
    */
    static QString formatId( int id );

    /**
    * Format the size of a file.
    *
    * The size is formatted using bytes, kilobytes or megabytes,
    * whichever is most appropriate.
    */
    static QString formatSize( int size );

    /**
    * Return the name of the user with given identifier.
    */
    static QString userName( int userId );

    /**
    * Return the name of the issue type with given identifier.
    */
    static QString typeName( int typeId );

    /**
    * Return the name of the attribute with given identifier.
    */
    static QString attributeName( int attributeId );

    /**
    * Return the name of the given column.
    */
    static QString columnName( Column column );

private:
    static QString tr( const char* text );
};

}

#endif
