#include <qmap.h>
class ServletEntry
{
    private:
    typedef QMap<QString, QString> InitParam;
    InitParam initParam;
    QString ServletName;
    QString ServletClass;
    QString DisplayName;
    QString URLPattern;
    QString Description;
    QString LoadOnStartup;
    public:
    ServletEntry()
    {
	ServletName="";
	ServletClass="";
	DisplayName="";
	URLPattern="";
	Description="";
	LoadOnStartup="";
    }
    ServletEntry(const QString ServletName, const QString ServletClass, const QString DisplayName, const QString URLPattern, const QString Description, const QString LoadOnStartup):
	    ServletName(ServletName), ServletClass(ServletClass), DisplayName(DisplayName),URLPattern(URLPattern), Description(Description), LoadOnStartup(LoadOnStartup){}
    
    virtual ~ServletEntry(){}
    void setInitParam(const QString ParamName, const QString ParamValue)
    {
	initParam[ParamName]=ParamValue;
    }
    void clearInitParams()
    {
	initParam.clear();
    }
    QMap<QString, QString> getInitParameters()
    {
	return initParam;
    }
    void setServletName(const QString ServletName)
    {
	this->ServletName=ServletName;
    }
    void setServletClass(const QString ServletClass)
    {
	this->ServletClass=ServletClass;
    }
    void setDisplayName(const QString DisplayName)
    {
	this->DisplayName=DisplayName;
    }
    void setURLPattern(const QString URLPattern)
    {
	this->URLPattern=URLPattern;
    }
    void setDescription(const QString Description)
    {
	this->Description=Description;
    }
    void setLoadOnStartup(const QString LoadOnStartup)
    {
	this->LoadOnStartup=LoadOnStartup;
    }
    QString getServletName()
    {
	return ServletName;
    }
    QString getServletClass()
    {
	return this->ServletClass;
    }
    QString getDisplayName()
    {
	return this->DisplayName;
    }
    QString getURLPattern()
    {
	return this->URLPattern;
    }
    QString getDescription()
    {
	return this->Description;
    }
    QString getLoadOnStartup()
    {
	return this->LoadOnStartup;
    }
};