/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename slots use Qt Designer which will
** update this file, preserving your code. Create an init() slot in place of
** a constructor, and a destroy() slot in place of a destructor.
*****************************************************************************/


void WDForm::init()
{
    QToolTip::add( tblWelcome, trUtf8("Welcome files are used when user\ndoes not specify jsp file.\nThey are usualy index.jsp, index.html\nand should be visible from Internet.\nEnter file names row by row:\nindex.jsp\nindex.html"));
    QToolTip::add( tblErrors, tr("Error code should be numeric\nFile will be shown on proper error\ni.e: 404 /errors/err404.html\n500 /errors/err500.html\nThese files should be visible from Internet."));
}




void WDForm::destroy()
{
    //delete params;
}


void WDForm::tblParams_contextMenuRequested( int row, int, const QPoint & )
{
    QPopupMenu *menu=new QPopupMenu();
    menu->insertItem("Add new parameter", this, SLOT(newParameter()));
    if(row!=-1)
	menu->insertItem("Delete parameter", this, SLOT(delParameter()));
    menu->popup(QCursor::pos());

}


void WDForm::newParameter()
{
     tblParams->insertRows(tblParams->numRows());
     tblParams->editCell(tblParams->numRows()-1, 0);
}


void WDForm::delParameter()
{
//    qDebug(tblParams->currentSelection ());
    tblParams->removeRow(tblParams->currentRow ());
}


void WDForm::cbWelcome_stateChanged( int state)
{
    if(state==0)
    {
	tblWelcome->setEnabled(false);
    }
    if(state==2)
    {
	tblWelcome->setEnabled(true);
    }
}


void WDForm::cbErrors_stateChanged( int state)
{
    switch(state)
    {
    case 0:
	tblErrors->setEnabled(false);
	break;
    case 2:
	tblErrors->setEnabled(true);
	break;
    }
}


void WDForm::tblWelcome_contextMenuRequested( int row, int, const QPoint & )
{
    QPopupMenu *menu=new QPopupMenu();
    menu->insertItem("Add new parameter", this, SLOT(newWelcomeFile()));
    if(row!=-1)
	menu->insertItem("Delete parameter", this, SLOT(delWelcomeFile()));
    menu->popup(QCursor::pos());
}


void WDForm::tblErrors_contextMenuRequested( int row, int, const QPoint & )
{
    QPopupMenu *menu=new QPopupMenu();
    menu->insertItem("Add new parameter", this, SLOT(newError()));
    if(row!=-1)
	menu->insertItem("Delete parameter", this, SLOT(delError()));
    menu->popup(QCursor::pos());
}


void WDForm::newWelcomeFile()
{
     tblWelcome->insertRows(tblWelcome->numRows());
     tblWelcome->editCell(tblWelcome->numRows()-1, 0);
}

void WDForm::delWelcomeFile()
{
    tblWelcome->removeRow(tblWelcome->currentRow ());
}


void WDForm::newError()
{
     tblErrors->insertRows(tblErrors->numRows());
     tblErrors->editCell(tblErrors->numRows()-1, 0);
}

void WDForm::delError()
{
    tblErrors->removeRow(tblErrors->currentRow ());
}
