/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

using namespace std;

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "conf.h"
#include "defs.h"


wf_outmodule_html_conf::wf_outmodule_html_conf() {
  config.option_add("verbose", WF_OPTION_TYPE_INT,
		    _("verbosity level"));
  config.option_add("summary", WF_OPTION_TYPE_BOOL,
		    _("summary mode"));

  config.option_add("lines", WF_OPTION_TYPE_INT,
		    _("show n first lines"));
  /* config.option_add("header", WF_OPTION_TYPE_BOOL,
     _("show header and footer")); RV@@2 */
  config.option_add("unique", WF_OPTION_TYPE_BOOL,
		    _("show unique characteristics at the beginning"));
  config.option_add("title", WF_OPTION_TYPE_STR,
		    _("page title"));
  config.option_add("stimes", WF_OPTION_TYPE_BOOL,
		    _("show start time"));
  config.option_add("etimes", WF_OPTION_TYPE_BOOL,
		    _("show end time"));
  config.option_add("duration", WF_OPTION_TYPE_BOOL,
		    _("show duration between start and end"),
		    _("show duration between start and end in day:hour:min:sec format"));
  config.option_add("resolve", WF_OPTION_TYPE_INT,
		    _("resolve IP addresses"),
		    _("determine reverse DNS lookup handling: 0 is for none, 1 for always, and 2 for forcing synchronous resolution (makes sense if asynchronous resolution is supported)"));
  config.option_add("sresolve", WF_OPTION_TYPE_BOOL,
		    _("resolve service names"));
  config.option_add("whois_lookup", WF_OPTION_TYPE_INT,
		    _("do a whois lookup"),
		    _("determine whois lookup handling: 0 is for none, 1 for always, and 2 for ifnodns (only if DNS name could not be found)"));
  config.option_add("src_ip", WF_OPTION_TYPE_BOOL,
		    _("show source IP address"));
  config.option_add("dst_ip", WF_OPTION_TYPE_BOOL,
		    _("show destination IP address"));
  config.option_add("proto", WF_OPTION_TYPE_BOOL,
		    _("show protocol"));
  config.option_add("src_port", WF_OPTION_TYPE_BOOL,
		    _("show source port"));
  config.option_add("dst_port", WF_OPTION_TYPE_BOOL,
		    _("show destination port"));
  config.option_add("src_mac", WF_OPTION_TYPE_BOOL,
		    _("show source MAC address"));
  config.option_add("dst_mac", WF_OPTION_TYPE_BOOL,
		    _("show destination MAC address"));
  config.option_add("mac_vendor", WF_OPTION_TYPE_BOOL,
		    _("show MAC vendor"));
  config.option_add("tcpflags", WF_OPTION_TYPE_BOOL,
		    _("show TCP flags"));
  config.option_add("datalen", WF_OPTION_TYPE_BOOL,
		    _("show packet data length"));
  config.option_add("loghost", WF_OPTION_TYPE_BOOL,
		    _("show log host"));
  config.option_add("chain", WF_OPTION_TYPE_BOOL,
		    _("show chain name"));
  config.option_add("branch", WF_OPTION_TYPE_BOOL,
		    _("show branch name"));
  config.option_add("interfaces", WF_OPTION_TYPE_BOOL,
		    _("show interfaces"));

  config.option_add("textcol", WF_OPTION_TYPE_STR,
		    _("text color"));
  config.option_add("bgcol", WF_OPTION_TYPE_STR,
		    _("background color"));
  config.option_add("rowcol1", WF_OPTION_TYPE_STR,
		    _("background color of odd rows"));
  config.option_add("rowcol2", WF_OPTION_TYPE_STR,
		    _("background color of even rows"));

  config["verbose"] = 0;
  config["summary"] = true;

  config["lines"] = 0;

  // config["header"] = true; RV@@2
  config["unique"] = true;
  config["title"] = _("wflogs summary");
  
  config["stimes"] = true;
  config["etimes"] = true;
  config["duration"] = true;

  config["resolve"] = RESOLV_YES;
  config["sresolve"] = true;
  config["whois_lookup"] = WHOIS_IFNODNS;

  config["src_ip"] = true;
  config["dst_ip"] = true;
  config["proto"] = true;
  config["src_port"] = true;
  config["dst_port"] = true;
  config["src_mac"] = false;
  config["dst_mac"] = false;
  config["mac_vendor"] = false;
  config["tcpflags"] = true;

  config["datalen"] = false;

  // string sort_order;
  // unsigned char sortfield;
  // unsigned char sortmode;

  config["loghost"] = true;

  config["chain"] = true;
  config["branch"] = false;

  config["interfaces"] = true;


  config["textcol"] = "white";
  config["bgcol"] = "black";
  config["rowcol1"] = "#555555";
  config["rowcol2"] = "#333333";
}

ostream&
wf_outmodule_html_conf::print(ostream& os) const {
  os << "PRINT HTML CONFIG" << endl;
  // RV@@8
  return os;
}
