/*
 * MeshBasedNode.h
 *
 * Copyright (C) 1999 Stephen F. White, 2004 J. "MUFTI" Scheurich
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _MESH_BASED_NODE_H
#define _MESH_BASED_NODE_H

#ifndef _NODE_H
#include "Node.h"
#endif

class Scene;
class MFVec3f;
class MFVec2f;
class MFInt32;
class Vec3f;
class Mesh;

class MeshBasedNode : public Node {
public:
		    MeshBasedNode(Scene *scene, Proto *proto);
    virtual	   ~MeshBasedNode();

    int             cleanDoubleVertices(int *coordIndex, Vec3f *vertices,
                                        Vec3f *normals, int index, 
                                        bool ccw=false);
    virtual void    draw();

    virtual Node   *toIndexedFaceSet(bool wantNormal = true);
    virtual bool    canConvertToIndexedFaceSet(void) { return true; }

    virtual bool    isInvalidChildNode(void) { return true; }
    virtual bool    hasBoundingBox(void) { return true; }
    virtual Vec3f   getMinBoundingBox(void);
    virtual Vec3f   getMaxBoundingBox(void);

    void            update(void) { _meshDirty = true; }
    void            reInit(void) { _mesh = NULL; _meshDirty = true; }

    virtual int	    countPolygons(void);

    MFVec3f	   *getVertices(void);
    MFVec2f        *getTextureCoordinates();
    MFInt32        *getTexCoordIndex(); 

    virtual void    createMesh() = 0;

protected:
    Mesh	   *_mesh;
    bool	    _meshDirty;
};

#endif // _MESH_BASED_NODE_H

