/*
 * NodeSwitch.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "stdafx.h"

#include "NodeSwitch.h"
#include "Proto.h"
#include "FieldValue.h"
#include "MFNode.h"
#include "SFInt32.h"

ProtoSwitch::ProtoSwitch(Scene *scene)
  : Proto(scene, "Switch")
{
    choice.set(
          addExposedField(MFNODE, "choice", new MFNode(), CHILD_NODE));
    whichChoice.set(
          addExposedField(SFINT32, "whichChoice", new SFInt32(-1), 
                          new SFInt32(-1)));
}

Node *
ProtoSwitch::create(Scene *scene)
{ 
    return new NodeSwitch(scene, this); 
}

NodeSwitch::NodeSwitch(Scene *scene, Proto *def)
  : Node(scene, def)
{
}

int NodeSwitch::accountWhich()
{
    NodeList *choiceList = choice()->getValues();
    
    int which = whichChoice()->getValue();
    
    int whichCount = 0;
    for (int i = 0; i < choiceList->size(); i++)
        if (choiceList->get(i)->getType() != NODE_COMMENT) {
            if (whichCount == which)
                which = i;
            else
                whichCount++;
        }
    return whichCount;
}

void
NodeSwitch::preDraw()
{
    NodeList *choiceList = choice()->getValues();

    int which = accountWhich();

    if (which < 0 || which >= choiceList->size()) return;

    choiceList->get(which)->preDraw();
}

void
NodeSwitch::draw()
{
    NodeList *choiceList = choice()->getValues();

    int which = accountWhich();

    if (which < 0 || which >= choiceList->size()) return;

    glPushName(0);
    glPushName(which);
    choiceList->get(which)->draw();
    glPopName();
    glPopName();
}

void
NodeSwitch::flip(int index)
{
    NodeList    *childList = choice()->getValues();

    for (int i = 0; i < childList->size(); i++)
	childList->get(i)->flip(index);
}

int         
NodeSwitch::countPolygons(void)
{
    NodeList *choiceList = choice()->getValues();

    int which = accountWhich();
    
    if (which < 0 || which >= choiceList->size()) return 0;
    
    return choiceList->get(which)->countPolygons();
}

int         
NodeSwitch::countPrimitives(void)
{
    NodeList *choiceList = choice()->getValues();

    int which = accountWhich();
    
    if (which < 0 || which >= choiceList->size()) return 0;
    
    return choiceList->get(which)->countPrimitives();
}

