/*
 * OutputApp.cpp
 *
 * Copyright (C) 2003 J. "MUFTI" Scheurich
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <errno.h>
#include "stdafx.h"
#include <math.h>

#include "mycsnprintf.h"
#include "TheApp.h"
#include "OutputApp.h"
#include "PreferencesApp.h"

#define DEFAULT_INDENT 2
#define DEFAULT_FLOAT_DIGITS 6

OutputApp::OutputApp()
   {
   }

void
OutputApp::OutputSetDefaults()
   {
#ifdef WIN32
    _keepURLs = true;
#else
    _keepURLs = false;
#endif
   _krFormating = false;
   
   _indent = DEFAULT_INDENT;
   _floatDigits = DEFAULT_FLOAT_DIGITS;
   }

void
OutputApp::OutputLoadPreferences()
   {
   assert(TheApp != NULL);

   OutputSetDefaults();

#ifdef WIN32
    _keepURLs = TheApp->GetBoolPreference("KeepURLs", true);    
#else
    _keepURLs = TheApp->GetBoolPreference("KeepURLs", false);    
#endif 
   char buf[128];
   const char *buf2;

   mysnprintf(buf, 128, "%d", DEFAULT_INDENT);   
   buf2 = TheApp->GetPreference("Indent", buf); 
   _indent = atoi(buf2);
   mysnprintf(buf, 128, "%d", DEFAULT_FLOAT_DIGITS);   
   buf2 = TheApp->GetPreference("FloatDigits", buf); 
   _floatDigits = atoi(buf2);
   _krFormating = TheApp->GetBoolPreference("krFormating", false);    
   _includeProtos = TheApp->GetBoolPreference("IncludeProtos", false);    
   _compress = TheApp->GetBoolPreference("Compress", false);    
   }

void
OutputApp::OutputSavePreferences()
   {
   assert(TheApp != NULL);

   char buf[128];

   TheApp->SetBoolPreference("KeepURLs", _keepURLs);

   mysnprintf(buf, 128, "%d", _indent);
   TheApp->SetPreference("Indent", buf); 
   mysnprintf(buf, 128, "%d", _floatDigits);
   TheApp->SetPreference("FloatDigits", buf); 
   TheApp->SetBoolPreference("krFormating", _krFormating);
   TheApp->SetBoolPreference("IncludeProtos", _includeProtos);
   TheApp->SetBoolPreference("Compress", _compress);
   }

bool parseCommandlineArgumentOutput(int & i,int argc, char** argv)
   {
   bool found = true;
   if (strcmp(argv[i],"-krFormating")==0) 
      {
      TheApp->SetkrFormating(true);
      return found;
      }
   else if (strcmp(argv[i],"-indent")==0) 
      {
      int indent;
      if (i++>=argc) return found;
      if (sscanf(argv[i],"%d",&indent)==1)
         TheApp->SetIndent(indent);
      } 
   else if (strcmp(argv[i],"-floatDigits")==0) 
      {
      int floatDigits;
      if (i++>=argc) return found;
      if (sscanf(argv[i],"%d",&floatDigits)==1)
         TheApp->SetFloatDigits(floatDigits);
      } 
   else
      return false;
  return found;
  }


void
OutputApp::SetFloatDigits(int value)
{
   set_number_of_digits(value);
   _floatDigits = value;
}

