/*
 * SFInt32.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _SFINT32_H
#define _SFINT32_H

#ifndef _FIELDVALUE_H
#include "FieldValue.h"
#endif

class SFInt32 : public FieldValue {
public:
			SFInt32(int value);
			SFInt32(void) { _value = 0; } // silly default

    virtual int         getType() const { return SFINT32; }
    virtual const char *getTypeName() const { return "SFInt32"; }
    virtual int	        write(int filedes, int indent) const;
//    virtual int		writeCC(int filedes, char* variableName) const;
    virtual bool	equals(const FieldValue *value) const;
    virtual void	clamp(const FieldValue *min, const FieldValue *max);
    virtual FieldValue *copy() { return new SFInt32(*this); }

    int			getValue() const { return _value; }

    MyString	        getEcmaScriptComment(MyString name, int flags) const;

    // VRML 200x IntegerSequencer not implemented yet
    bool                isAnimateable() const { return false; }
    bool                hasAnimationSupport() { return false; }

private:
    int			_value;
};

#endif // _SFINT32_H
