/*
 * Copyright (C) 2002-2004, 2007 by the Widelands Development Team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "editor_tool_options_menu.h"

Editor_Tool_Options_Menu::Editor_Tool_Options_Menu
(Editor_Interactive         &       parent,
 UI::UniqueWindow::Registry &       registry,
 const uint width, const uint height,
 const char                 * const title)
:
UI::UniqueWindow(&parent, &registry, width, height, title),
m_current_pointer(parent.tools.current_pointer)
{if (get_usedefaultpos()) move_to_mouse();}


void Editor_Tool_Options_Menu::select_correct_tool() {
	dynamic_cast<Editor_Interactive &>(*get_parent())
		.select_tool(*m_current_pointer, Editor_Tool::First);
}
