/*  Wordtrans, front-end for several dictionaries, for the Qt toolkit.
    Copyright (C) 2000-2004 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <qvariant.h>

#ifdef HAVE_KDELIBS3
#include "KApplicationWindow.h"
#include <kmenubar.h>
#include <kstatusbar.h> //KDE3
#include <kapp.h>
#include <kaboutkde.h>
#include <kpopupmenu.h> //KDE3
#include "qbrowser/khelpwindow.h"
#include "dcop/kde_interface.h"
#define APPNAME "Multi Language Word Translator"
#else
#include "QApplicationWindow.h"
#include "qbrowser/helpwindow.h"
#define APPNAME "Multi Language Word Translator"
#endif

#include <qglobal.h> //Nmero versin qt
#include <qpixmap.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qaccel.h>
#include <qstatusbar.h>
#include <qmessagebox.h>
#include <qapplication.h>
#include <qaccel.h>
#include <qmsgbox.h>
#include <qdatetime.h>
#include <string.h>
#include <qfontdialog.h>
#include <qstring.h>
#include <qlistbox.h>
#include <qwhatsthis.h>
#include <qtooltip.h>
#include <qcolor.h>


#include "DiccionarioBase.h"
#include "QTextDiccionario.h"
#include "QBabyDiccionario.h"
#include "QDictDiccionario.h"
#include "QEditaDiccionario.h"
#include "chooseDictType.h"
#include "acercade.h"
#include "QSimpleTextBrowser.h"
#include "setup.h"
#include "urlmanager.h"
#include "salidas.h"

#ifdef USE_WIZARD
#include "wizard.h"
#endif

#ifdef USAR_CUESTIONARIO
#include "QCuestionario.h"
#endif

#include "qdialogos.h"
#include "qfunciones.h"
#include "miniwindow.h"
#include "intern.h"
#include "version.h"


#ifdef CAMBIAR_ESTILOS
#ifndef HAVE_KDELIBS3
#if QT_VERSION < 300
#include <qwindowsstyle.h>
#include <qplatinumstyle.h>
#include <qmotifstyle.h>
#include <qcdestyle.h>

#if QT_VERSION >= 220
#include <qmotifplusstyle.h>
#include <qsgistyle.h>
#endif //QT_VERSION

#ifdef TEMAS_EXTRA
#include "themes/metal.h"
#include "themes/wood.h"
#endif //TEMAS_EXTRA

#endif //QT_VERSION < 300
#endif //HAVE_KDELIBS3
#endif //CAMBIAR_ESTILOS


#if QT_VERSION < 300
#include "pixmaps/selected.xpm"
#endif

#include "iconos.h"


QApplicationWindow::QApplicationWindow(
	QDiccionarios *dictionary_list, bool ismainwindow,
	QWidget * parent, const char * name, WFlags f )
#ifdef HAVE_KDELIBS3
	: KMainWindow( parent, name, f )
#else
    : QMainWindow( parent, name, f )
#endif
{
	dicts=dictionary_list;
	main_window=ismainwindow;

	old_status_mes="";
	use_internal_browser=true;
	//help_window=NULL;

	iconInv1=icono_flecha_der();
	iconInv2=icono_flecha_izq();

	small_app_icon=icono_small_app();
	big_app_icon=icono_big_app();

#ifdef HAVE_KDELIBS3
	dock=NULL;

	if (main_window) {
		dock=new MiSystemTray( this, "dock" );
		//Para salir realmente del programa si el usuario seleccionar la
		//opcin de salir en el men contextual.
		//kapp->setMainWidget( dock ); 
		dock->setPixmap( icono_docked() );
		QToolTip::add( dock, "kwordtrans" );

		//Arreglamos la ltima opcin del men
		//Ojo: es una chapuza, habr que pensar en algo mejor...
		/*
		debug( "Items: %d", dock->menu()->count() );
		//Parece que la opcin de salir no se crea hasta que se muestra
		//el widget.
		dock->show();
		debug( "Items: %d", dock->menu()->count() );
		dock->hide();

		dock->menu()->removeItemAt( dock->menu()->count()-1 );
		dock->menu()->insertItem( iconSalir, _("&Quit"), kapp, SLOT( quit() ) );
		*/

		dock_clip_item= dock->menu()->insertItem( _("&Watch clipboard"), this, SLOT( cambiaClipboardMenu() ), 0, -1, 1 );
#ifdef OPCION_AUTOPOPUP
		autopopup_item= dock->menu()->insertItem( _("&Activate mini-window"), this, SLOT(setAutopopup() ), 0, -1, 2 );
		dock->menu()->insertSeparator(3);
#else
		dock->menu()->insertSeparator(2);
#endif
	}
#endif
	auto_popup=true;


	// Toolbar
	setUsesBigPixmaps(true);

#ifdef SEPARATE_TOOLBAR
#define TMP_TOOLBAR controles
	controles = new QToolBar(this, "controles" );
	addToolBar( controles, _("Navigation bar") );
#else
#define TMP_TOOLBAR tb
#endif
	tb = new QToolBar(this, "toolbar" );

	tbRetroceder= new QToolButton( icono_back(), _("Backward"), 0, this,
                                   SLOT(retroceder()), TMP_TOOLBAR, "backward");
	tbRetroceder->setEnabled(false);

	tbAvanzar= new QToolButton( icono_forward(), _("Forward"), 0, this,
                                SLOT(avanzar()), TMP_TOOLBAR, "forward");
	tbAvanzar->setEnabled(false);

	(void) new QToolButton( icono_reload(), _("Refresh"), 0, this,
                            SLOT( refrescar() ), TMP_TOOLBAR, "refresh");

#ifndef SEPARATE_TOOLBAR
	tb->addSeparator();
#endif

	addToolBar( tb, _("Tool bar") );

	/*
	tbI2E = new QToolButton( iconI2E, "Language 1 -> Language 2", 0,
                             this, SLOT(cambiaI2E()),
                             tb, "i2e" );
	tbI2E->setToggleButton(true);

	tbE2I = new QToolButton( iconE2I, "Language 2 -> Language 1", 0,
                             this, SLOT(cambiaE2I()),
                             tb, "e2i" );
	tbE2I->setToggleButton(true);
	*/

	tbPixI2E = new QLabel( tb, "tbPixI2E");
	//tbPixI2E->setFrameStyle( QFrame::WinPanel | QFrame::Sunken );
	tbPixI2E->setPixmap( icono_lang1().pixmap() );

	tbInvertir = new QToolButton( iconInv1, _("Invert way of translation"), 0,
                                  this, SLOT(invierteIdioma()), tb, "invertir");
	tbInvertir->setToggleButton(false);

	tbPixE2I = new QLabel( tb, "tbPixE2I");
	//tbPixE2I->setFrameStyle( QFrame::WinPanel | QFrame::Sunken );
	tbPixE2I->setPixmap( icono_lang2().pixmap() );

	tb->addSeparator();

	/*
	QToolButton *tbTraduce = new QToolButton( iconTraduce, _("Translate"), 0,
                                              this, SLOT(traduce()),
                                              tb, "traduce" );
	tbTraduce->setUsesBigPixmap(true);
	*/

	tbAprender = new QToolButton( icono_aprender(), _("Learn"), 0,
                                  this, SLOT(aprender()),
                                  tb, "aprender" );

	//tb->addSeparator();

	tbClip = new QToolButton( icono_clipboard(), _("Watch clipboard"), 0,
                              this, SLOT(cambiaClipboard()),
                              tb, "clipboard" );
	tbClip->setToggleButton(true);

	(void) new QToolButton( icono_configure(),
                            _("Edit preferences"), 0, this, 
                            SLOT(activaDialogPreferencias()), 
                            tb, "preferencias");
#ifdef USE_WIZARD
	(void) new QToolButton( icono_wizard(), _("Wizard"), 0, this,
                            SLOT(activaWizard()), tb, "wizard");
#endif
	(void) new QToolButton( icono_contents(), _("Help"), 0, this,
                            SLOT(verManual()), tb, "ayuda");

//#ifdef HAVE_KDELIBS3
//	tb->addSeparator();
//	QToolButton *tbDock = new QToolButton( iconSetDocked, _("Dock"), 0, this, 
//                                           SLOT( forceDocked() ), tb, "dock");
//	tbDock->setEnabled(true); //Esto es para evitar el warning "unused variable"
//#endif

	//Desactivamos el botn de salir
	/*
	tb->addSeparator();

	tbSalir = new QToolButton( iconSalir, _("Exit"), 0,
                               this, SLOT(salir()),
                               tb, "salir" );
	*/

	/* No queda demasiado bien
	tb->addSeparator();

	(void) QWhatsThis::whatsThisButton( tb );
	*/


	//Lista con el historial
	lista_historial = new QListBox(0, "historial");
	lista_historial->setCaption( _("History - qwordtrans") );
	QWhatsThis::add( lista_historial, 
		_("<p>Here is a list with the latest words you've look for.</p>"
          "<p>You may double click in one of them to perform the search again.</p>"));
	connect( lista_historial, SIGNAL( selected(const QString&) ),
             this, SLOT( historyChosen(const QString&) ) );

	QAccel* acc = new QAccel(this);

	// Mens
#ifdef HAVE_FILE_MENU
#define FILE_MENU archivo
	archivo = new QPopupMenu(this);
	menuBar()->insertItem( _("&File"), archivo );
	FILE_MENU->insertItem( icono_nuevo(), _("&New window"), this, SLOT(newWindow()) );
	save_item= FILE_MENU->insertItem( icono_grabar(), _("&Save...") );
	print_item= FILE_MENU->insertItem( icono_imprimir(), _("&Print...") );
	archivo->insertSeparator();
	FILE_MENU->insertItem( icono_cerrar(), _("&Close"), this, SLOT(salir()), CTRL+Key_Q );
#ifdef HAVE_KDELIBS3
	FILE_MENU->insertItem( icono_salir(), _("&Quit"), kapp, SLOT( closeAllWindows() ) );
#else
	FILE_MENU->insertItem( icono_salir(), _("&Quit"), qApp, SLOT( closeAllWindows() ) );
#endif
#endif

	translate = new QPopupMenu(this);
	translate->setCheckable(true);
    menuBar()->insertItem( _("&Translate"), translate );
	i2e_item= translate->insertItem( icono_lang1(), "Language 1 -> Language 2", this, SLOT(cambiaI2E()), CTRL+Key_I );
	//acc->connectItem( acc->insertItem( CTRL+Key_I ), this, SLOT(cambiaI2E()) );
	e2i_item= translate->insertItem( icono_lang2(), "Language 2 -> Language 1", this, SLOT(cambiaE2I()), CTRL+Key_E );
	//acc->connectItem( acc->insertItem( CTRL+Key_E ), this, SLOT(cambiaE2I()) );
	learn_item= translate->insertItem( icono_aprender(), _("&Learn..."), this, SLOT(aprender()), CTRL+Key_A );
	//acc->connectItem( acc->insertItem( CTRL+Key_A ), this, SLOT(aprender()) );
#ifndef HAVE_FILE_MENU
#define FILE_MENU translate
	translate->insertSeparator();
	FILE_MENU->insertItem( icono_nuevo(), _("&New window"), this, SLOT(newWindow()) );
	save_item= FILE_MENU->insertItem( icono_grabar(), _("&Save...") );
	print_item= FILE_MENU->insertItem( icono_imprimir(), _("&Print...") );
	FILE_MENU->insertItem( icono_salir(), _("&Close"), this, SLOT(salir()), CTRL+Key_Q );
#endif
	//FILE_MENU->setItemEnabled( save_item, false );
	acc->connectItem( acc->insertItem( CTRL+Key_Q ), this, SLOT(salir()) );

	//dicts=new QDiccionarios( conf_dir );
	//dicts->load();
	dict=dicts->first();
	//diccionarios=dicts.creaMenu();
	diccionarios= new QPopupMenu(this);
	diccionarios->setCheckable(true);
	diccionarios->insertItem( _("&New..."), this, SLOT(nuevoDict()), CTRL+Key_N );
	acc->connectItem( acc->insertItem( CTRL+Key_N ), this, SLOT(nuevoDict()) );
	diccionarios->insertItem( _("&Edit..."), this, SLOT(editaDict()), Key_F2 );
	acc->connectItem( acc->insertItem( Key_F2 ), this, SLOT(editaDict()) );
	diccionarios->insertSeparator();
	dicts->addMenuItems( diccionarios );

	//URLMANAGER
	if (main_window) {
		url_manager = new UrlManager( dicts, dict );
	}
	connect( url_manager, SIGNAL( dictionaryChanged( DiccionarioBase *) ),
       	     this, SLOT( changeDict( DiccionarioBase *) ) );
	connect( url_manager, SIGNAL( htmlLink( const QString &)),
   	         this, SLOT( invokeBrowser(const QString&)) );
	connect( url_manager, SIGNAL( seeManual() ),
   	         this, SLOT( verManual() ) );

	menuBar()->insertItem( _("&Dictionaries"), diccionarios );
	connect( diccionarios, SIGNAL(activated(int)), this, SLOT(changeDict(int)) );
	diccionarios->setItemChecked( diccionarios->idAt(3), true );

#ifdef HAVE_KDELIBS3
	if (dock!=NULL) {
#ifdef OPCION_AUTOPOPUP
		dock->menu()->insertItem( _("&Dictionaries"), diccionarios, -1, 4 );
#else
		dock->menu()->insertItem( _("&Dictionaries"), diccionarios, -1, 3 );
#endif //del OPCION_AUTOPOPUP
		//dock->menu()->insertSeparator(5);
	}
#endif

	/*
	diccionarios = new QPopupMenu();
	diccionarios->setCheckable(true);
	menuBar()->insertItem( _("&Dictionaries"), diccionarios );
	dict1_item= diccionarios->insertItem( _("English - Spanish"), this, SLOT(selectDict1()) );
	dict2_item= diccionarios->insertItem( _("English - German"), this, SLOT(selectDict2()) );
	*/

#ifdef MENU_HISTORY
	hist = new QPopupMenu( this );
	menuBar()->insertItem( _("H&istory"), hist );
	hist->insertItem( _("&Clear"), this, SLOT( clearHistory() ) );
	hist->insertSeparator();
    connect( hist, SIGNAL( activated( int ) ),
             this, SLOT( histChosen( int ) ) );
#endif

    bookm = new QPopupMenu( this );
	menuBar()->insertItem( _("&Bookmarks"), bookm );
    bookm->insertItem( _( "&Add Bookmark" ), this, SLOT( addBookmark() ) );
    bookm->insertSeparator();
    connect( bookm, SIGNAL( activated( int ) ),
             this, SLOT( bookmChosen( int ) ) );

	view = new QPopupMenu(this);
	//view->setCheckable(true);
	menuBar()->insertItem( _("&View"), view );
	view->insertItem( _("&Introduction"), this, SLOT( showIntro() ), Key_F5 );
	acc->connectItem( acc->insertItem( Key_F5 ), this, SLOT(showIntro()) );
	view->insertItem( _("&Description of the dictionary"), this, SLOT( showDesc() ), Key_F6 );
	acc->connectItem( acc->insertItem( Key_F6 ), this, SLOT(showDesc()) );
	geninfo_item= view->insertItem( _("&Server info"), this, SLOT( showGenInfo() ), Key_F7 );
	acc->connectItem( acc->insertItem( Key_F7 ), this, SLOT(showGenInfo()) );
	dictinfo_item= view->insertItem( _("Dictionary &info"), this, SLOT( showDictInfo() ), Key_F8 );
	acc->connectItem( acc->insertItem( Key_F8 ), this, SLOT(showDictInfo()) );
	view->insertSeparator();
	view->insertItem( _("&History"), lista_historial, SLOT(show()) );

	opciones = new QPopupMenu(this);
	opciones->setCheckable(true);
	menuBar()->insertItem( _("&Options"), opciones );
	fullwords_item= opciones->insertItem( _("&Full words"), this, SLOT(fullWords()), CTRL+Key_B );
	//acc->connectItem( acc->insertItem( CTRL+Key_B ), this, SLOT(fullWords()) );
	casesensitive_item= opciones->insertItem( _("&Case sensitive"), this, SLOT(caseSensitive()), CTRL+Key_X );
	//acc->connectItem( acc->insertItem( CTRL+Key_X ), this, SLOT(caseSensitive()) );
	ignoraracentos_item= opciones->insertItem( _("&Ignore accented vowels"), this, SLOT(ignorarAcentos()), CTRL+Key_G );
	//acc->connectItem( acc->insertItem( CTRL+Key_G ), this, SLOT(ignorarAcentos()) );
	opciones->insertSeparator();
	conformato_item= opciones->insertItem( _("&Rich text"), this, SLOT( cambiaFormato()), CTRL+Key_R );
	acc->connectItem( acc->insertItem( CTRL+Key_R ), this, SLOT(cambiaFormato()) );

	/*
	clipboard=new QPopupMenu(this);
	clipboard->setCheckable(true);
	clip_item= clipboard->insertItem( iconClip, _("&Watch"), this, SLOT( cambiaClipboardMenu() ) );
	clipboard->insertItem( _("&Adjust sensitivity..."), this, SLOT( clipProperties() ) );
	*/

/*
#ifdef CAMBIAR_ESTILOS
#ifndef HAVE_KDELIBS3
	estilo=new QPopupMenu(this);
	estilo->setCheckable( TRUE );
	est_windows=estilo->insertItem( "Windows" );
	est_motif=estilo->insertItem( "Motif" );
	est_platinum=estilo->insertItem( "Platinum" );
	est_cde=estilo->insertItem( "CDE" );
	est_motifplus=estilo->insertItem( "Motifplus" );
	est_sgi=estilo->insertItem( "SGI" );
#if QT_VERSION < 220
	estilo->setItemEnabled( est_motifplus, false );
	estilo->setItemEnabled( est_sgi, false );
#endif //QT_VERSION

#ifdef TEMAS_EXTRA
	est_wood=estilo->insertItem( "Wood" );
	est_metal=estilo->insertItem( "Metal" );
#endif //TEMAS_EXTRA

	estilo->setItemChecked( est_windows, TRUE );
	connect( estilo, SIGNAL(activated(int)), 
             this, SLOT(cambiaEstilo(int)) );
#endif //HAVE_KDELIBS3
#endif //CAMBIAR_ESTILOS
*/

	/*
	QPopupMenu *fonts=new QPopupMenu(this);
	fonts->insertItem( _("&Main window"), this, SLOT(cambiaFuente()) );
	font_view_item= fonts->insertItem( _("&Output window") );
	*/

	/*
	oculta_menu=new QPopupMenu(this);
	oculta_menu->setCheckable(true);
	tb_hidden_item= oculta_menu->insertItem( _("&Tool bar"), this, SLOT(ocultaToolbar()), CTRL+Key_T );
	menu_hidden_item= oculta_menu->insertItem( _("&Menu"), this, SLOT( ocultaMenu() ), CTRL+Key_M );
	statusbar_hidden_item= oculta_menu->insertItem( _("&Status bar"), this, SLOT( ocultaStatusBar() ), CTRL+Key_S );
	*/

    acc->connectItem( acc->insertItem( CTRL+Key_T ), this, SLOT(ocultaToolbar()) );
    acc->connectItem( acc->insertItem( CTRL+Key_M ), this, SLOT(ocultaMenu()) );
    acc->connectItem( acc->insertItem( CTRL+Key_S ), this, SLOT(ocultaStatusBar()) );

	/*
	toolbar_prefs = new QPopupMenu(this);
	tb_big_item= toolbar_prefs->insertItem( _("&Big"), this, SLOT(bigToolbar()) );
	tb_small_item= toolbar_prefs->insertItem( _("&Small"), this, SLOT(smallToolbar()) );
	toolbar_prefs->setCheckable(true);
	toolbar_prefs->setItemChecked( tb_big_item, true );
	*/

	preferencias=new QPopupMenu(this);
	preferencias->setCheckable(true);
	preferencias->insertItem( icono_configure(), _("&Edit..."), this, SLOT( activaDialogPreferencias() ) );
	preferencias->insertSeparator();
	//preferencias->insertItem( _("&Clipboard"), clipboard );
	clip_item= preferencias->insertItem( icono_clipboard(), _("&Watch clipboard"), this, SLOT( cambiaClipboardMenu() ) );
	//preferencias->insertItem( _("&Fonts"), fonts );
/*
#ifdef CAMBIAR_ESTILOS
#ifndef HAVE_KDELIBS3
	preferencias->insertItem( _("&Style"), estilo );
#endif
#endif
*/
	//preferencias->insertItem( _("&Toolbar"), toolbar_prefs );
	//preferencias->insertItem( _("&Hide"), oculta_menu );
	//color_view_item= preferencias->insertItem( _("&Change background colour") );
	//animaciones_item= preferencias->insertItem( _("&Animation effects"), this, SLOT(cambiaAnimaciones()) );
//#if QT_VERSION < 220
	//preferencias->setItemEnabled( animaciones_item, false );
//#endif
#ifdef SMALL_ICON_OPTION
	small_icon_item= preferencias->insertItem( _("Small application &icon"), this, SLOT(cambiaAppIcon()) );
#endif
	//preferencias->insertSeparator();
#ifdef HAVE_KDELIBS3
	docked_item= preferencias->insertItem( _("&Dock"), this, SLOT( setDocked() ) );
	//int force_docked_item= preferencias->insertItem( _("D&ock && hide main window"), this, SLOT( forceDocked() ), CTRL+Key_Y );
	if (!main_window) { //No es la ventana principal
		preferencias->setItemEnabled( docked_item, false );
		//preferencias->setItemEnabled( force_docked_item, false );
	}
#else
	docked_item= preferencias->insertItem( _("Hide && use &miniwindow"), this, SLOT( setDocked() ) );
#endif
	//preferencias->insertItem( _("Wizard"), this, SLOT( activaWizard() ) );

	menuBar()->insertItem( _("&Preferences"), preferencias);

	menuBar()->insertSeparator();

/*
#ifdef HAVE_KDELIBS3
	//KPopupMenu *ayuda=helpMenu();
	KPopupMenu *ayuda=customHelpMenu();
	//ayuda->insertItem( _("Configure &browser..."), this, SLOT(editaBrowser()), 0, -1, 0 );
	//ayuda->insertSeparator(1);
	ayuda->insertItem( _("&Questionnaire"), this, SLOT(cuestionario()), 0, -1, 7-2 );
	ayuda->insertSeparator(8-2);
	menuBar()->insertItem( _("&Help"), ayuda );
#else
*/
	QPopupMenu * ayuda = new QPopupMenu(this);
	menuBar()->insertItem( _("&Help"), ayuda );
	//ayuda->insertItem( _("Configure &browser..."), this, SLOT(editaBrowser()) );
	//ayuda->insertSeparator();
	ayuda->insertItem( icono_contents(), _("&Contents"), this, SLOT(verManual()), Key_F1 );
	acc->connectItem( acc->insertItem( Key_F1 ), this, SLOT(verManual()) );
	ayuda->insertItem( icono_contexthelp(), _("What's &this"), this , SLOT(whatsThis()), SHIFT+Key_F1);
	acc->connectItem( acc->insertItem( SHIFT+Key_F1 ), this, SLOT(whatsThis()) );
	//ayuda->insertSeparator();

#ifdef USAR_CUESTIONARIO
	ayuda->insertItem( _("&Questionnaire"), this, SLOT(cuestionario()) );
#endif

#ifdef HAVE_KDELIBS3
	ayuda->insertItem( icono_acerca_kde(), _("About &KDE"), this, SLOT(acercaDeQt()) );
#else
	ayuda->insertItem( icono_acerca_qt(), _("About &Qt"), this, SLOT(acercaDeQt()) );
#endif
	ayuda->insertItem( small_app_icon, _("&About Wordtrans"), this, SLOT(acercaDe()) );
/*#endif*/

	/*
	i2e_dict = new QDiccionario();
	i2e_dict->setAlias("i2e");
	i2e_dict->setFileName("/tmp/i2e.conf");
	i2e_dict->setDiccionario("/usr/share/i2e/i2e.dict");
	i2e_dict->setPersonal( ".i2e.dict" );

	german_english = new QDiccionario();
	german_english->setAlias("de-en");
	german_english->setFileName("/tmp/de-en.conf");
	german_english->setDiccionario("/usr/share/trans/de-en");
	german_english->setPersonal( ".de-en.dict" );
	german_english->setSeparador(" :: ");

	dict=i2e_dict;
	*/

	mainwidget=new QMainWidget(dict, this);
	diccionarios->setItemChecked( dict1_item, true );

	setCentralWidget( mainwidget );


	connect( url_manager, SIGNAL(fraseTraducida(const QString&, const QString&, 
             const QString&, unsigned int)), 
			 this, SLOT(cambiaTitulo(const QString&, const QString&, 
             const QString&, unsigned int) ) );

	connect( mainwidget->browser(), SIGNAL(backwardAvailable(bool)), 
             tbRetroceder, SLOT(setEnabled(bool)) );

	connect( mainwidget->browser(), SIGNAL(forwardAvailable(bool)), 
             tbAvanzar, SLOT(setEnabled(bool)) );

	connect( mainwidget->browser(), SIGNAL(highlighted(const QString&)), 
             this, SLOT(showLink(const QString&)) );

	/*connect( mainwidget->browser(), SIGNAL(anchor_clicked(const QString&)), 
             this, SLOT(search_in_all(const QString&)) );*/

	connect( mainwidget->browser(), SIGNAL( textChanged() ),
             this, SLOT( textChanged() ) );

	FILE_MENU->connectItem( print_item, mainwidget->browser(),
	                        SLOT( imprimir() ) );

	FILE_MENU->connectItem( save_item, mainwidget->browser(),
	                        SLOT( grabar() ) );

	/*
	fonts->connectItem( font_view_item, mainwidget->browser(), 
                        SLOT( cambia_font() ) );

	preferencias->connectItem( color_view_item, mainwidget->browser(),
                               SLOT( cambia_color() ) );
	*/

	//status = new QLabel( statusBar(), "status");
	//statusBar()->addWidget( status, 10, true );
    //setStatusText( _("Ready") );

	connect( Setup::dialog(), SIGNAL( applyClicked() ),
             this, SLOT( aplicaPreferencias() ) );

	connect( Setup::dialog(), SIGNAL( okClicked() ),
             this, SLOT( aplicaPreferencias() ) );

	cambiaTitulo( "","","",0); //Ttulo por defecto
	setStatusText( _("Ready") );

	initConfig();
	leeConfig();
	//MiniWindow::setConf(conf);

#ifdef HAVE_KDELIBS3
	KdeInterface *iface = new KdeInterface(dictionary_list, this, "kdeinterface");
	if (dict) iface->setDefaultDictionary( dict->getAlias() );
#endif

	syncWidgets();

	//if (strcmp( version_loaded.data(), VERSION) != 0) showIntro();
	if ( version_loaded != VERSION ) showIntro();
}

QApplicationWindow::~QApplicationWindow() {
	delete mainwidget;
	delete lista_historial;

	//if (help_window != NULL) delete help_window;

	debug("Destruyendo QApplicationWindow");
}


void QApplicationWindow::initConfig() {
	QString fullName=QConfig::configName("wordtrans/preferencias");
	//debug("Nombre config: %s", fullName);

	conf=new QConfig(fullName.latin1());
}


void QApplicationWindow::newWindow() {
	QApplicationWindow *mw = new QApplicationWindow(dicts, false, 0, "new_window", 
                                                    WDestructiveClose);
	mw->show();
}

void QApplicationWindow::acercaDe() {
	QString titulo= _("About ");
	titulo += APPNAME;
	//QMessageBox::about(this, titulo.data() ,getAcercaDe() );

	Acercade *d = new Acercade(this, "acercade");
	d->setCaption( titulo );
	d->setDebugInfo( Salidas::getShowDebugMessages() );
	//d.setTexto( getAcercaDe() );
	//d.setImagen( "/usr/share/wordtrans/logo.bmp" );
	d->exec();
	Salidas::setShowDebugMessages( d->getDebugInfo() );
	delete d;
}

void QApplicationWindow::showAboutApplication(void) {
	acercaDe();
}

//Se usar tambin para el acerca de KDE
void QApplicationWindow::acercaDeQt() {
#ifdef HAVE_KDELIBS3
	KAboutKDE acercadekde( this, "acercadekde", true);
	acercadekde.exec();
#else
	QMessageBox::aboutQt( this, _("About Qt") );
#endif
}

void QApplicationWindow::salir() {
	//QSize s=size();
	//debug("ancho: %d, alto: %d", s.width(), s.height() );

	close();
}

void QApplicationWindow::closeEvent(QCloseEvent *e) {
	//dicts->save_all_dicts();
	//qDebug("QApplicationWindow::closeEvent");
	if (main_window) {
		//qDebug( "Saving preferences" );
		grabaConfig();
	} else {
		debug( "Not saving preferences" );
	}
#ifdef HAVE_KDELIBS3
	if (dock!=NULL) dock->close();
#endif
	e->accept();
}

void QApplicationWindow::hideEvent (QHideEvent *e)  {
#ifdef HAVE_KDELIBS3
	//debug("Ventana ocultada");
	if ( (dock!=NULL) && (dock->isVisible()) ) {
		//debug("dock visible");
		setDocked(TRUE);
	}
#endif
}

//Preferencias
void QApplicationWindow::activaDialogPreferencias() {
	//Fuentes y colores
	Setup::dialog()->setMainFont( QApplication::font() );
	Setup::dialog()->setOutputFont( mainwidget->getFontVista() );
	Setup::dialog()->setMiniwindowFont( MiniWindow::defaultWindow()->browser()->defaultFont() );

	Setup::dialog()->setOutputColor( mainwidget->browser()->colorFondo() );
	Setup::dialog()->setMiniwindowColor( MiniWindow::defaultWindow()->browser()->colorFondo() );

	//Browser
	Setup::dialog()->setBrowser( web_browser );
	Setup::dialog()->setInternalBrowser( use_internal_browser );

	//Clipboard
	Setup::dialog()->setClipboardTime( mainwidget->getClipInterval() );

	//Misc
	//Setup::dialog()->setBigToolbar( toolbar_prefs->isItemChecked( tb_big_item ) );
	Setup::dialog()->setBigToolbar( usesBigPixmaps() );
	Setup::dialog()->setMenubarVisible( menuBar()->isVisibleTo( this ) );
	Setup::dialog()->setToolbarVisible( tb->isVisibleTo( this ) );
	Setup::dialog()->setStatusbarVisible( statusBar()->isVisibleTo( this ) );

	Setup::dialog()->setStyle( estilo_actual );
	Setup::dialog()->setEfecto( tipo_efecto );

	//Charsets
	Setup::dialog()->setSavingCharset( mainwidget->browser()->getCharset() );

	Setup::dialog()->show();
}

void QApplicationWindow::aplicaPreferencias() {
	qDebug("QApplicationWindow::aplicaPreferencias");

	//Fuentes y colores
	QApplication::setFont( Setup::dialog()->getMainFont(), TRUE );
#ifndef HAVE_KDELIBS3
	Setup::dialog()->setRebelFonts( Setup::dialog()->getMainFont() );
#endif
	mainwidget->setFontVista( Setup::dialog()->getOutputFont() );
	MiniWindow::defaultWindow()->browser()->setDefaultFont( Setup::dialog()->getMiniwindowFont() );
	//Lo siguiente informa al diccionario del cambio de font. Mmmm,,,
	mainwidget->slot_cambiadoFontVista( Setup::dialog()->getOutputFont() );

	mainwidget->browser()->cambia_color( Setup::dialog()->getOutputColor() );
	MiniWindow::defaultWindow()->browser()->cambia_color( Setup::dialog()->getMiniwindowColor() );

	//Browser
	web_browser = Setup::dialog()->getBrowser();
	use_internal_browser = Setup::dialog()->getInternalBrowser();

	//Clipboard
	mainwidget->setClipInterval( Setup::dialog()->getClipboardTime() );

	//Misc
	changeSizeToolbar( Setup::dialog()->getBigToolbar() );
	ocultaMenu( ! Setup::dialog()->isMenubarVisible() );
	ocultaToolbar( ! Setup::dialog()->isToolbarVisible() );
	ocultaStatusBar( ! Setup::dialog()->isStatusbarVisible() );

	if ( estilo_actual != Setup::dialog()->getStyle() ) {
		estilo_actual=Setup::dialog()->getStyle();
		qDebug("New style: '%s'", estilo_actual.latin1() );
		cambiaEstilo( estilo_actual );
	}

	setEfecto( Setup::dialog()->getEfecto() );

	//Charsets
	QString saving_charset= Setup::dialog()->getSavingCharset();
	mainwidget->browser()->setCharset( saving_charset );
	MiniWindow::defaultWindow()->browser()->setCharset( saving_charset );
}

void QApplicationWindow::activaWizard() {
#ifdef USE_WIZARD
	Wizard *wizard = new Wizard( this, "wizard", TRUE );
	wizard->exec();

	delete wizard;
#endif
}

//Browser
void QApplicationWindow::avanzar() {
	mainwidget->browser()->forward();
}

void QApplicationWindow::retroceder() {
	mainwidget->browser()->backward();
}

void QApplicationWindow::refrescar() {
//#if QT_VERSION >= 300
//	mainwidget->browser()->reload();
//#else
	QString enlace( mainwidget->browser()->nameText() );
	mainwidget->browser()->setSource( enlace );
//#endif
}

void QApplicationWindow::textChanged() {
	QString enlace( mainwidget->browser()->nameText() );
	if (enlace == "about:null") return;

	bool existe;

#ifdef MENU_HISTORY
	existe=false;
	QMap<int, QString>::Iterator it = mHistory.begin();
	for ( ; it != mHistory.end(); ++it ) {
   		if ((*it)==enlace) {
			existe=true;
			break;
		}
	}

	if (!existe) 
		mHistory[ hist->insertItem( enlace ) ] = enlace;
#endif

	existe=false;
	for (unsigned int n=0; n < lista_historial->count(); n++) {
		if ( lista_historial->text(n) == enlace ) {
			existe=true;
			break;
		}
	}

	if (!existe)
		lista_historial->insertItem( enlace );
}

void QApplicationWindow::histChosen( int i ) {
#ifdef MENU_HISTORY
	if ( mHistory.contains( i ) ) {
		mainwidget->browser()->setSource( mHistory[ i ] );
	}
#endif
}

void QApplicationWindow::clearHistory() {
#ifdef MENU_HISTORY
	QMap<int, QString>::Iterator it = mHistory.begin();
	for ( ; it != mHistory.end(); ++it ) {
		hist->removeItem( it.key() );
	}

	mHistory.clear();
#endif
}


void QApplicationWindow::historyChosen(const QString& enlace) {
	mainwidget->browser()->setSource( enlace );
}

void QApplicationWindow::bookmChosen( int i ) {
	if ( mBookmarks.contains( i ) ) {
		mainwidget->browser()->setSource( mBookmarks[ i ] );
	}
}

void QApplicationWindow::addBookmark() {
	QString enlace( mainwidget->browser()->nameText() );
	mBookmarks[ bookm->insertItem( enlace ) ] = enlace;
}


/*
void QApplicationWindow::traduce() {
	//statusBar()->message( _("Translating...") );

	//QTime t;
	//t.start();

	mainwidget->traducir();

	//debug("Tiempo traduccin: %d", t.elapsed() );

	//statusBar()->message( _("Ready") );
}
*/

void QApplicationWindow::aprender() {
	mainwidget->aprender();
}

void QApplicationWindow::changeIdioma(bool i2c) {
	translate->setItemChecked( e2i_item, !i2c );
	translate->setItemChecked( i2e_item, i2c );
	//tbE2I->setOn( !i2c );
	//tbI2E->setOn( i2c );

	if (i2c) 
		tbInvertir->setIconSet( iconInv1 );
	else
		tbInvertir->setIconSet( iconInv2 );

	//mainwidget->setIdioma( i2c );

	if (dict!=NULL) dict->setInvertirResultados( !i2c );
}

void QApplicationWindow::invierteIdioma() {
	if (dict!=NULL)
		changeIdioma( dict->getInvertirResultados() );	
}

void QApplicationWindow::cambiaE2I() {
	changeIdioma(false);
}

void QApplicationWindow::cambiaI2E() {
	changeIdioma(true);
}


void QApplicationWindow::nuevoDict() {
	ChooseDictType dt(this, "choose_dictionary");
	int res = dt.exec();
	if (res == QDialog::Rejected) return;

	DiccionarioBase *nuevo_dict;

	switch (dt.getChosenType()) {
		case DiccionarioBase::Babylon_dict : 
			nuevo_dict=new QBabyDiccionario();
			break;

		case DiccionarioBase::Dict_dict : 
			nuevo_dict=new QDictDiccionario();
			break;

		default: nuevo_dict=new QTextDiccionario();
	}

	//delete dt; //***POR HACER: que se borre solo

	if (nuevo_dict!=NULL) {
		QEditaDiccionario d( nuevo_dict, true, this, "edit_dict" );
		int r=d.exec();

		bool ok;
		switch (r) {
			case 1: ok=nuevo_dict->update();
					dicts->add(nuevo_dict); 
					dicts->updateMenuItems(diccionarios,3); 
					syncWidgets();
					if (!ok) Dialogos::mensaje(this, _("Error"), nuevo_dict->getError() );
					break;
			case 2: delete nuevo_dict; break;
		}
	}
}

void QApplicationWindow::editaDict() {
	if (dict!=NULL) {
		QEditaDiccionario d( dict, false, this, "edit_dict" );
		int r=d.exec();

		if (r==1) {
			bool ok=dict->update();
			dicts->updateMenuItems(diccionarios,3);
			syncWidgets();
			if (!ok) Dialogos::mensaje(this, _("Error"), dict->getError() );
		}
	}
}

/*
void QApplicationWindow::editaBrowser() {
	QAEditBrowser d(this, "edit_browser");
	d.setBrowser( web_browser );
	d.setInternalBrowser( use_internal_browser );

	int r=d.exec();
	if (r==1) {
		use_internal_browser = d.internalBrowser();
		//if (!use_internal_browser) {
			web_browser = d.getBrowser();
			debug("Nuevo browser: %s", web_browser.latin1() );
		//}
	}
	//delete d; // ***POR HACER: que se borre solo
}
*/

void QApplicationWindow::verManual( const QString& url, bool force_external ) {
/*
#ifdef HAVE_KDELIBS3
	//debug("QApplicationWindow::verManual: not implemented for KDE version");
	//KRun *krun= new KRun( url );
	kapp->invokeBrowser( url );
#else
*/
	if ((use_internal_browser==TRUE) && (force_external==FALSE)) {
		/*
		if (help_window==NULL)
			help_window=new HelpWindow( url, ".", 0, "helpwindow");
		else
			help_window->goTo( url );
		*/
		HelpWindow::defaultHelpWindow()->goTo( url );

		HelpWindow::defaultHelpWindow()->show();
		return;
	}

	//Browser externo
	if (web_browser.isEmpty()) {
		Dialogos::mensaje( this, _("No browser selected"), 
                  _("In order to see the help pages or a url\n"
				    "you need to select a web browser first.") );
		//editaBrowser();
		activaDialogPreferencias();
		return;
	}
	QCString comando;
	comando= web_browser.latin1();
	comando += " ";
	comando += url.latin1();
	comando += " &";
	debug("Comando para ver manual: '%s'",comando.data());
	ejecuta( comando.data() );
/*#endif*/
}

void QApplicationWindow::verManual() {
/*
#ifdef HAVE_KDELIBS3
	//url_manual.remove(0,1); //Quitamos el espacio inicial
	kapp->invokeHelp();
#else
*/
	//Note: This is the help contents file
	QString url_manual( _(" file:/usr/share/doc/wordtrans-doc/html.en/index.html") );
	verManual( url_manual );
/*#endif*/
}

void QApplicationWindow::cuestionario() {
/*
	QPixmap appIcon=QPixmap(qi2e_xpm);

	QMessageBox d("qwordtrans",
			_("<h2>Questionnaire</h2>\n"
			  "<p>A short questionnaire is included in wordtrans.\n"
              "I would appreciate if you could take some minutes\n"
              "to fill it.</p>\n\n"
			  "<p>Your answers could help me improve this\n"
              "application. The questionnaire is located in\n"
              "<code>/usr/share/doc/wordtrans/questionnaire.txt.gz</code></p>\n\n"
              "<p>Thank you.</p>"), QMessageBox::Information,
			  QMessageBox::Ok | QMessageBox::Default, 0, 0 );
	d.setIconPixmap( appIcon );
	d.setButtonText( QMessageBox::Ok, _("&Ok") );
	d.show();
*/

#ifdef USAR_CUESTIONARIO
	QCuestionario *cuestionario=new QCuestionario(0, "cuestionario");
	cuestionario->show();
#endif
}


void QApplicationWindow::fullWords() {
	bool checked= opciones->isItemChecked( fullwords_item );
	opciones->setItemChecked( fullwords_item, !checked );

	if (dict!=NULL) dict->setPalabrasCompletas( !checked );
}

void QApplicationWindow::caseSensitive() {
	bool checked= opciones->isItemChecked( casesensitive_item );
	opciones->setItemChecked( casesensitive_item, !checked );

	if (dict!=NULL) dict->setCaseSensitive( !checked );
}

void QApplicationWindow::ignorarAcentos() {
	bool checked= opciones->isItemChecked( ignoraracentos_item );
	opciones->setItemChecked( ignoraracentos_item, !checked );

	if (dict!=NULL) dict->setIgnorarAcentos( !checked );
}

void QApplicationWindow::cambiaFormato(bool con_formato) {
	opciones->setItemChecked( conformato_item, con_formato );
	mainwidget->setFormato( con_formato );
	url_manager->setRichText( con_formato );
#if QT_VERSION >= 300
	if (con_formato) {
		mainwidget->browser()->setTextFormat( Qt::RichText );
		MiniWindow::defaultWindow()->browser()->setTextFormat( Qt::RichText );
	} else {
		mainwidget->browser()->setTextFormat( Qt::PlainText );
		MiniWindow::defaultWindow()->browser()->setTextFormat( Qt::PlainText );
	}
#endif
	refrescar();
}

void QApplicationWindow::cambiaFormato() {
	bool checked= opciones->isItemChecked( conformato_item );
	cambiaFormato( !checked );
}



void QApplicationWindow::showIntro() {
	mainwidget->procesaEnlace( "about:wordtrans" );
	//mainwidget->setTextVista( getIntroText() );
}

void QApplicationWindow::showDesc() {
	mainwidget->procesaEnlace( "about:dictionary" );
	//mainwidget->showDesc();
}

void QApplicationWindow::showGenInfo() {
	if (dict!=NULL) {
		mainwidget->procesaEnlace( "about:server" );
		//bool con_formato=opciones->isItemChecked( conformato_item );
		//mainwidget->setTextVista( *dict->getGeneralInfo(con_formato) );
	}
}

void QApplicationWindow::showDictInfo() {
	if (dict!=NULL) {
		mainwidget->procesaEnlace( "about:database" );
		//bool con_formato=opciones->isItemChecked( conformato_item );
		//mainwidget->setTextVista( *dict->getDictionaryInfo(con_formato) );
	}
}


void QApplicationWindow::syncWidgets() {
	if (dict!=NULL) {
		//debug("syncWidgets");
		//if (dict->getInvertirResultados()) 
		//	debug(" invertir idioma = true");
		//else
		//	debug(" invertir idioma = false");

		if ( dict->canSelectInvertirResultados() ) {
			changeIdioma( !dict->getInvertirResultados() );
			translate->setItemEnabled(i2e_item, true);
			translate->setItemEnabled(e2i_item, true);
		} else {
			changeIdioma( true );
			//translate->setItemEnabled(i2e_item, false);
			translate->setItemEnabled(e2i_item, false);
		}
	
		if ( dict->canSelectPalabrasCompletas() ) {
			opciones->setItemChecked( fullwords_item, dict->getPalabrasCompletas() );
			opciones->setItemEnabled( fullwords_item, true );
		} else {
			opciones->setItemChecked( fullwords_item, false );
			opciones->setItemEnabled( fullwords_item, false );
		}

		if ( dict->canSelectCaseSensitive() ) {
			opciones->setItemChecked( casesensitive_item, dict->getCaseSensitive() );
			opciones->setItemEnabled( casesensitive_item, true);
		} else {
			opciones->setItemChecked( casesensitive_item, false );
			opciones->setItemEnabled( casesensitive_item, false );
		}

		if ( dict->canSelectIgnorarAcentos() ) {
			opciones->setItemChecked( ignoraracentos_item, dict->getIgnorarAcentos() );
			opciones->setItemEnabled( ignoraracentos_item, true);
		} else {
			opciones->setItemChecked( ignoraracentos_item, false );
			opciones->setItemEnabled( ignoraracentos_item, false );
		}

		view->setItemEnabled( geninfo_item, dict->canGetGeneralInfo() );
		view->setItemEnabled( dictinfo_item, dict->canGetDictionaryInfo() );

		QString s1=dict->getIdioma1() + " -> " + dict->getIdioma2();
		QString s2=dict->getIdioma2() + " -> " + dict->getIdioma1();
		translate->changeItem( s1, i2e_item);
		translate->changeItem( s2, e2i_item);

		translate->setItemEnabled( learn_item, dict->puedeAprender() );

		//const char *n_icono1=dict->getIconoIdioma1().data();
		//const char *n_icono2=dict->getIconoIdioma2().data();

		icono_idioma1.load( dict->getIconoIdioma1() );
		icono_idioma2.load( dict->getIconoIdioma2() );


		//tbI2E->setTextLabel( s1 );
		//tbE2I->setTextLabel( s2 );

		tbPixI2E->setText( s1 );
		tbPixE2I->setText( s2 );

		if (!icono_idioma1.isNull()) {
			//tbI2E->setPixmap(icono_idioma1);
			tbPixI2E->setPixmap(icono_idioma1);
			translate->changeItem( i2e_item, icono_idioma1, s1 );
		}

		if (!icono_idioma2.isNull()) {
			//tbE2I->setPixmap(icono_idioma2);
			tbPixE2I->setPixmap(icono_idioma2);
			translate->changeItem( e2i_item, icono_idioma2, s2 );
		}

		if (dict->canSelectInvertirResultados()) {
			//tbI2E->setEnabled( true );
			//tbE2I->setEnabled( true );
			//tbPixI2E->setEnabled( true );
			//tbPixE2I->setEnabled( true );
			tbInvertir->setEnabled( true );
		} else {
			//tbI2E->setEnabled( false ); //Esto ya estaba comentado
			//tbE2I->setEnabled( false );
			//tbPixE2I->setEnabled( false );
			tbInvertir->setEnabled( false );
		}

		tbAprender->setEnabled( dict->puedeAprender() );

	}
}

void QApplicationWindow::selectDict( QString alias, bool show_desc ) {
	int index;
	DiccionarioBase *d= dicts->find( alias, index );
	if ((d!=NULL) && (index!=-1)) {
		int id=diccionarios->idAt(index+3);
		changeDict(id, show_desc); 
	}
}

void QApplicationWindow::changeDict( DiccionarioBase *dict ) {
	selectDict( dict->getAlias() );
}

void QApplicationWindow::changeDict(int id, bool show_desc) {
	//debug("QApplicationWindow::changeDict: id=%d",id);

	int index= diccionarios->indexOf( id );
	//debug("QApplicationWindow::changeDict: index=%d",index);

	if (index < 2) return; //Items 'new' y 'edit'

	for (unsigned int n=0;n< diccionarios->count();n++) {
		int item_id= diccionarios->idAt(n);
		diccionarios->setItemChecked( item_id, false );
#if QT_VERSION < 300
		if (n>=3) {
			DiccionarioBase *diccionario=dicts->at( n-3 );
			QPixmap *icono= dicts->getIconoTipo( diccionario );
			diccionarios->changeItem( item_id, *icono, diccionarios->text( item_id ) );
		}
#endif
	}
	
	diccionarios->setItemChecked( id, true );
#if QT_VERSION < 300
	diccionarios->changeItem( id, QPixmap(selected_xpm), diccionarios->text(id) );
#endif

	dict=dicts->at( index-3 );
	url_manager->setDictionary( dict );

#if QT_VERSION < 300
	//Verifica que el charset es el adecuado
	//Cambiamos el font slo en caso de que el charset del font
	//actual no coincida con el font del diccionario.
	//Hacemos este cambio antes de informar a mainwidget del
	//cambio de diccionario para que el nuevo texto ya
	//aparezca con el nuevo font.
	if (!dict->f_family.isEmpty()) {
		QFont font( dict->f_family, dict->f_pointSize, dict->f_weight,
                    dict->f_italic, (QFont::CharSet) dict->f_charset );
		font.setBold( dict->f_bold );
		font.setUnderline( dict->f_underline );
		font.setStrikeOut( dict->f_strikeout );

		if ( font.charSet() != mainwidget->getFontVista().charSet() ) {
			qDebug("Forced font changing in mainwidget");
			mainwidget->setFontVista( font );
		}

		if ( font.charSet() != MiniWindow::defaultWindow()->browser()->defaultFont().charSet() ) {
			qDebug("Forced font changing in miniwindow");
			MiniWindow::defaultWindow()->browser()->setDefaultFont( font );
		}
	}
#endif

	mainwidget->setDiccionario(dict, show_desc);

	syncWidgets();
}

void QApplicationWindow::changeDict(int id) {
	changeDict(id, true);
}


void QApplicationWindow::cambiaTitulo(const QString& titulo, 
    const QString& palabra, const QString & texto,
	unsigned int numTraducciones) 
{
	if (numTraducciones>0) {
		setCaption( titulo + "  (" + APPNAME + " by rvm)");

		QString mensaje= _(" %1 terms found for \"%2\"")
                         .arg(numTraducciones).arg(palabra);
		setStatusText( mensaje );
#ifdef HAVE_KDELIBS3
		if (dock!=NULL) QToolTip::add( dock, titulo );
		if ( (auto_popup) && (isHidden()) ) {
#else
		if ( (auto_popup) && (isMinimized()) ) {
#endif
			//if (MiniWindow::defaultWindow()->isMinimized()) 
			//	MiniWindow::defaultWindow()->showNormal();
			MiniWindow::defaultWindow()->setCaption( titulo );
			MiniWindow::defaultWindow()->setText( texto );
#if QT_VERSION >= 300
			//MiniWindow::defaultWindow()->browser()->setCursorPosition(1,1);
			MiniWindow::defaultWindow()->browser()->setContentsPos(0,0);
#endif
			MiniWindow::defaultWindow()->show();
			MiniWindow::defaultWindow()->setActiveWindow();
			MiniWindow::defaultWindow()->raise();
		}
	} else {
		QString t(APPNAME);
		t += " by rvm";
		setCaption( t );

		QString mensaje= _(" No terms found for \"%1\"").arg(palabra);
		setStatusText( mensaje );
#ifdef HAVE_KDELIBS3
		if (dock!=NULL) QToolTip::add( dock, mensaje );
#endif

	}
}

void QApplicationWindow::setStatusText(const QString & texto) {
	old_status_mes=texto;
	statusBar()->message( texto );
}

void QApplicationWindow::showLink(const QString & enlace) {
	if ( enlace.isEmpty() ) {
		statusBar()->message( old_status_mes );
	} else {
		//old_status_mes= status->text();
		statusBar()->message( enlace );
	}
}

/*
void QApplicationWindow::search_in_all(const QString & enlace) {
	QString diccionario="";
	QString palabra;

	int pos=enlace.find(':');
	if (pos > -1 ) {
		diccionario=enlace.left( pos );
		palabra=enlace.mid( pos+1 );
#if QT_VERSION >= 300
		//Qt 3 aade "//" detrs de ":". Lo quitamos.
		if (palabra.left(2) == "//") palabra.remove(0,2);
#endif
	} else {
		palabra=enlace;
	}

	//ABOUT
	if ( diccionario == "about" ) {
		palabra=palabra.stripWhiteSpace();
		bool con_formato=opciones->isItemChecked( conformato_item );

		if ( palabra == "wordtrans" ) {
			mainwidget->setTextVista( getIntroText() );
		} 
		else
		if ( palabra == "dictionary" ) {
			mainwidget->showDesc();
		}
		else
		if ( palabra == "server" ) {
			if (dict!=NULL)
				mainwidget->setTextVista( dict->getGeneralInfo(con_formato) );
		}
		else
		if ( palabra == "database" ) {
			if (dict!=NULL)
				mainwidget->setTextVista( dict->getDictionaryInfo(con_formato) );
		}
		else
		if ( palabra == "broken link" ) {
			mainwidget->setTextVista( 
				_("<h3>This is a wordtrans warning</h3>\n"
				"<p>It seems the current dictionary has found a broken link, "
				"in other words, a string starting with '<b>{</b>' but without "
				"a closing '<b>}</b>'.</p>\n"
				"<p>To be sure you can deselect the <b>Options->Rich Text</b> "
				"and see if this is true.</p>"
				"<p>If not, then you have found a bug in "
				"wordtrans. Report it to &lt;rvm@escomposlinux.org&gt; along "
				"with the text causing the problem.</p>") );
		}
		else
		if ( palabra == "doc" ) {
			verManual();
		}
		else
		if ( palabra == "questions" ) {
			cuestionario();
		}
		else
		if ( palabra == "mozilla" ) {
			mainwidget->setTextVista( 
				_("<p>The slowest web browser I've ever seen.</p>") );
		}
		else {
			mainwidget->setTextVista( 
				_("<p>about what?</p><br/>"
				"<p>&lt;Insert your commercials here&gt;</p>"
				"<p>Just joking... or not? ;-)</p>") );
		}
	} else 
	// HTTP
	if ( diccionario == "http" ) {
		verManual( enlace, TRUE );
	} else {
		if ( (!diccionario.isEmpty()) && (diccionario != dict->getAlias()) ) {
			debug("QApplicationWindow::search_in_all: cambio diccionario: %s", diccionario.latin1());
			selectDict( diccionario );
		}

		mainwidget->traducir( palabra );
	}
}
*/

void QApplicationWindow::setClipboard(bool b) {
	tbClip->setOn( b );
	preferencias->setItemChecked( clip_item, b );
	mainwidget->checkClipboard( b );
#ifdef HAVE_KDELIBS3
	if (dock!=NULL) {
		dock->menu()->setItemChecked( dock_clip_item, b );
		if (b) 
			dock->setPixmap( icono_docked() );
		else
			dock->setPixmap( icono_docked_off() );
    }
#endif
}

void QApplicationWindow::cambiaClipboardMenu() {
	setClipboard( !preferencias->isItemChecked( clip_item ) );
}

void QApplicationWindow::cambiaClipboard() {
	setClipboard( tbClip->isOn() );
}

/*
void QApplicationWindow::clipProperties() {
	mainwidget->changeClipProperties();
}
*/

/*
void QApplicationWindow::cambiaFuente() {
	QFont f( mainwidget->getFontVista() );

	QApplication::setFont( QFontDialog::getFont( 0, QApplication::font() ), TRUE );

	mainwidget->setFontVista( f );
}
*/

void QApplicationWindow::changeSizeToolbar(bool grande) {
	//toolbar_prefs->setItemChecked( tb_big_item, grande );
	//toolbar_prefs->setItemChecked( tb_small_item, !grande );
	setUsesBigPixmaps( grande );
}

void QApplicationWindow::bigToolbar() {
	changeSizeToolbar( true );
}

void QApplicationWindow::smallToolbar() {
	changeSizeToolbar( false );
}

void QApplicationWindow::ocultaToolbar(bool ocultar) {
	//oculta_menu->setItemChecked( tb_hidden_item, ocultar );
	if (ocultar) {
		tb->hide();
#ifdef SEPARATE_TOOLBAR
		controles->hide();
#endif
	} else {
		tb->show();
#ifdef SEPARATE_TOOLBAR
		controles->show();
#endif
	}
}

void QApplicationWindow::ocultaToolbar() {
	//bool checked= oculta_menu->isItemChecked( tb_hidden_item );
	//ocultaToolbar( !checked );
	ocultaToolbar( ! tb->isVisibleTo( this ) );
}

void QApplicationWindow::ocultaMenu(bool ocultar) {
	//oculta_menu->setItemChecked( menu_hidden_item, ocultar );
	if (ocultar) {
		menuBar()->hide();
		setStatusText( _("Menu bar hidden. Press CTRL-M to do it visible again."));
	}
	else {
		menuBar()->show();
	}
}

void QApplicationWindow::ocultaMenu() {
	//bool checked= oculta_menu->isItemChecked( menu_hidden_item );
	//ocultaMenu( !checked );
	ocultaMenu( ! menuBar()->isVisibleTo( this ) );
}

void QApplicationWindow::ocultaStatusBar(bool ocultar) {
	//oculta_menu->setItemChecked( statusbar_hidden_item, ocultar );
	if (ocultar) statusBar()->hide(); else statusBar()->show();
}

void QApplicationWindow::ocultaStatusBar() {
	//bool checked= oculta_menu->isItemChecked( statusbar_hidden_item );
	//ocultaStatusBar( !checked );
	ocultaStatusBar( ! statusBar()->isVisibleTo( this ) );
}

void QApplicationWindow::setEfecto(int efecto) {
#if QT_VERSION >= 220
	tipo_efecto = efecto;
	switch (efecto) {
		case 1:
			QApplication::setEffectEnabled( Qt::UI_General, true );
			QApplication::setEffectEnabled( Qt::UI_AnimateMenu, true );
			QApplication::setEffectEnabled( Qt::UI_AnimateCombo, true );
			QApplication::setEffectEnabled( Qt::UI_AnimateTooltip, true );
			QApplication::setEffectEnabled( Qt::UI_FadeMenu, false );
			QApplication::setEffectEnabled( Qt::UI_FadeTooltip, false );
			break;
		case 2: 
			QApplication::setEffectEnabled( Qt::UI_General, true );
			QApplication::setEffectEnabled( Qt::UI_AnimateMenu, false );
			QApplication::setEffectEnabled( Qt::UI_AnimateCombo, false );
			QApplication::setEffectEnabled( Qt::UI_AnimateTooltip, false );
			QApplication::setEffectEnabled( Qt::UI_FadeMenu, true );
			QApplication::setEffectEnabled( Qt::UI_FadeTooltip, true );
			break;
		default:
			QApplication::setEffectEnabled( Qt::UI_General, false );
			QApplication::setEffectEnabled( Qt::UI_AnimateMenu, false );
			QApplication::setEffectEnabled( Qt::UI_AnimateCombo, false );
			QApplication::setEffectEnabled( Qt::UI_AnimateTooltip, false );
			QApplication::setEffectEnabled( Qt::UI_FadeMenu, false );
			QApplication::setEffectEnabled( Qt::UI_FadeTooltip, false );
	}
#endif
}

/*
void QApplicationWindow::cambiaAnimaciones(bool activado) {
#if QT_VERSION >= 220
	preferencias->setItemChecked( animaciones_item, activado );

	QApplication::setEffectEnabled( Qt::UI_General, activado );
	//QApplication::setEffectEnabled( Qt::UI_FadeMenu, activado );
	QApplication::setEffectEnabled( Qt::UI_AnimateMenu, activado );
	QApplication::setEffectEnabled( Qt::UI_AnimateCombo, activado );
	QApplication::setEffectEnabled( Qt::UI_AnimateTooltip, activado );
	//QApplication::setEffectEnabled( Qt::UI_FadeTooltip, activado );
#endif
}

void QApplicationWindow::cambiaAnimaciones() {
	bool checked= preferencias->isItemChecked( animaciones_item );
	cambiaAnimaciones( !checked );
}
*/

void QApplicationWindow::setDocked(bool docked) {
	preferencias->setItemChecked( docked_item, docked );
#ifdef HAVE_KDELIBS3
	if (docked) {
		if (dock!=NULL) dock->show();
		hide();
	} else {
		if (dock!=NULL) dock->hide();
		show();
	}

#ifndef OPCION_AUTOPOPUP
	auto_popup=docked;
#endif //del OPCION_AUTOPOPUP

#else
	auto_popup=docked;
	if (docked) showMinimized(); else showNormal();
#endif
}

void QApplicationWindow::setDocked() {
	bool checked= preferencias->isItemChecked( docked_item );
	setDocked( !checked );
}

//void QApplicationWindow::forceDocked() {
//	setDocked( TRUE );
//}

void QApplicationWindow::setAutopopup(bool b) {
#ifdef HAVE_KDELIBS3
#ifdef OPCION_AUTOPOPUP
	auto_popup=b;
	if (dock!=NULL) 
		dock->menu()->setItemChecked( autopopup_item, b );
#endif
#endif
}

void QApplicationWindow::setAutopopup() {
#ifdef HAVE_KDELIBS3
#ifdef OPCION_AUTOPOPUP
	if (dock!=NULL) {
		bool checked= dock->menu()->isItemChecked( autopopup_item );
		setAutopopup( !checked );
	}
#endif
#endif
}

void QApplicationWindow::setAppIconSmall(bool b) {
	if (b) setIcon( small_app_icon); else setIcon( big_app_icon );
#ifdef SMALL_ICON_OPTION
	preferencias->setItemChecked( small_icon_item, b );
#endif
}

void QApplicationWindow::cambiaAppIcon() {
#ifdef SMALL_ICON_OPTION
	bool checked= preferencias->isItemChecked( small_icon_item );
	setAppIconSmall( !checked );
#endif
}

void QApplicationWindow::cambiaEstilo( const QString & estilo) {
#ifdef CAMBIAR_ESTILOS
#ifndef HAVE_KDELIBS3

	estilo_actual=estilo;

#if QT_VERSION >= 300
	QApplication::setStyle(estilo);
#else

	QString texto=estilo;
	QStyle *style=NULL;

	if ( texto == "Windows" ) { style=new QWindowsStyle; }
	else
	if ( texto == "Motif" ) { style=new QMotifStyle; }
	else
	if ( texto == "Platinum" ) { style=new QPlatinumStyle; }
	else
	if ( texto == "CDE" ) { style=new QCDEStyle; }
	else
#if QT_VERSION >= 220
	if ( texto == "Motifplus" ) { style=new QMotifPlusStyle(true); }
	else
	if ( texto == "SGI" ) { style=new QSGIStyle; }
	else
#endif
#ifdef TEMAS_EXTRA
	if ( texto == "Wood" ) { style=new NorwegianWoodStyle; }
	else
	if ( texto == "Metal" ) { style=new MetalStyle; }
	else
#endif
	{ debug( "Unknown style: %s", texto.latin1()); return; }

	qApp->setStyle( style );
#endif // QT_VERSION >= 300

	//Volvemos a marcar como "checkables" los mens ya que
	//al cambiar al estilo motif no se actualiza. Bug de Qt?
	translate->setCheckable(true);
	diccionarios->setCheckable(true);
	opciones->setCheckable(true);
	preferencias->setCheckable(true);
#endif //HAVE_KDELIBS3
#endif //CAMBIAR_ESTILOS
}

/*
void QApplicationWindow::cambiaEstilo( int item_id ) {
#ifdef CAMBIAR_ESTILOS
#ifndef HAVE_KDELIBS3
	//Desmarcamos todos los items del men
	for (unsigned int n=0; n < estilo->count(); n++) {
		int id= estilo->idAt(n);
		estilo->setItemChecked( id, false );
	}

	estilo->setItemChecked( item_id, true );
	QString texto=estilo->text( item_id );

	QStyle *style=NULL;

	if ( texto == "Windows" ) { style=new QWindowsStyle; }
	else
	if ( texto == "Motif" ) { style=new QMotifStyle; }
	else
	if ( texto == "Platinum" ) { style=new QPlatinumStyle; }
	else
	if ( texto == "CDE" ) { style=new QCDEStyle; }
	else
#if QT_VERSION >= 220
	if ( texto == "Motifplus" ) { style=new QMotifPlusStyle(true); }
	else
	if ( texto == "SGI" ) { style=new QSGIStyle; }
	else
#endif
#ifdef TEMAS_EXTRA
	if ( texto == "Wood" ) { style=new NorwegianWoodStyle; }
	else
	if ( texto == "Metal" ) { style=new MetalStyle; }
	else
#endif
	{ debug( _("Unknown style: %s"), texto.latin1()); return; }

	qApp->setStyle( style );

	//Volvemos a marcar como "checkables" los mens ya que
	//al cambiar al estilo motif no se actualiza. Bug de Qt?
	translate->setCheckable(true);
	diccionarios->setCheckable(true);
	//view->setCheckable(true);
	opciones->setCheckable(true);
	//clipboard->setCheckable(true);
	estilo->setCheckable(true);
	preferencias->setCheckable(true);
	//oculta_menu->setCheckable(true);
	//toolbar_prefs->setCheckable(true);
#endif //HAVE_KDELIBS3
#endif //CAMBIAR_ESTILOS
}
*/

void QApplicationWindow::grabaBookmarks() {
	//BOOKMARKS
	conf->setGroup("Bookmarks");
	QString nombre;
	int contador=0;
	QMap<int, QString>::Iterator it2 = mBookmarks.begin();
    for ( ; it2 != mBookmarks.end(); ++it2 ) {
		nombre.sprintf( "line%d", contador );
		conf->writeEntry( nombre.latin1(), (*it2).latin1() );
		contador++;
	}
	conf->writeNumEntry( "lines", contador );
}

void QApplicationWindow::leeBookmarks() {
	//BOOKMARKS
	conf->setGroup("Bookmarks");
	QString nombre;
	int lineas = conf->readNumEntry( "lines", 0 );
	for (int n=0; n < lineas; n++) {
		nombre.sprintf( "line%d", n );
		QString s= conf->readEntry( nombre.latin1(), "" );
		mBookmarks[ bookm->insertItem( s ) ] = s;
	}
}


void QApplicationWindow::grabaEstilo() {
#ifdef CAMBIAR_ESTILOS
#ifndef HAVE_KDELIBS3
	/*
	const char *s="";
	if (estilo->isItemChecked( est_windows ) ) s="windows";
	if (estilo->isItemChecked( est_motif ) ) s="motif";
	if (estilo->isItemChecked( est_platinum ) ) s="platinum";
	if (estilo->isItemChecked( est_cde ) ) s="cde";
#if QT_VERSION >= 220
	if (estilo->isItemChecked( est_motifplus ) ) s="motifplus";
	if (estilo->isItemChecked( est_sgi ) ) s="sgi";
#endif
#ifdef TEMAS_EXTRA
	if (estilo->isItemChecked( est_wood ) ) s="wood";
	if (estilo->isItemChecked( est_metal ) ) s="metal";
#endif
	*/
	conf->setCurrentPath("Appearance");
	conf->writeEntry("style", estilo_actual.latin1() );
#endif //HAVE_KDELIBS3
#endif //CAMBIAR_ESTILOS
}

void QApplicationWindow::recuperaEstilo() {
#ifdef CAMBIAR_ESTILOS
#ifndef HAVE_KDELIBS3
	conf->setCurrentPath("Appearance");
	//const char *s=conf->readEntry("style", "Windows" );
	cambiaEstilo( conf->readEntry("style", "Windows" ) );
/*
	if (strcmp(s,"windows")==0) cambiaEstilo( est_windows );
	if (strcmp(s,"motif")==0) cambiaEstilo( est_motif );
	if (strcmp(s,"platinum")==0) cambiaEstilo( est_platinum );
	if (strcmp(s,"cde")==0) cambiaEstilo( est_cde );
#if QT_VERSION >= 220
	if (strcmp(s,"motifplus")==0) cambiaEstilo( est_motifplus );
	if (strcmp(s,"sgi")==0) cambiaEstilo( est_sgi );
#endif
#ifdef TEMAS_EXTRA
	if (strcmp(s,"wood")==0) cambiaEstilo( est_wood );
	if (strcmp(s,"metal")==0) cambiaEstilo( est_metal );
#endif
*/
#endif //HAVE_KDELIBS3
#endif //CAMBIAR_ESTILOS
}


void QApplicationWindow::leeConfig() {

	conf->setGroup("General");
	QString alias= conf->readEntry("diccionario", "ninguno");
	web_browser= conf->readEntry("browser", "" );
	version_loaded= conf->readEntry("version", "0.0");
	use_internal_browser= conf->readBoolEntry("internal_browser", true );
	Salidas::setShowDebugMessages( conf->readBoolEntry("debug",false) );

	conf->setGroup("Clipboard");
	setClipboard( conf->readBoolEntry("active", false) );
	mainwidget->setClipInterval( conf->readNumEntry("interval", 1000) );
	cambiaClipboard();

	conf->setGroup("Options");
	cambiaFormato( conf->readBoolEntry("formato", true) );

	conf->setGroup("Appearance");
 	DiccionarioBase::color_header=conf->readEntry("table_header_color","#F8FFD2");
	DiccionarioBase::usar_tabla=conf->readBoolEntry("use_table",true);

	//QSize s(this->size() );
	QSize s(570, 336); 				// Tamao por defecto
	resize(conf->readSizeEntry("WSize", s));
	QApplication::setFont( conf->readFontEntry("main_font", QApplication::font() ), TRUE );
#ifndef HAVE_KDELIBS3
	Setup::dialog()->setRebelFonts( QApplication::font() );
#endif
	mainwidget->setFontVista( conf->readFontEntry("view_font", mainwidget->getFontVista() ) );

	mainwidget->browser()->cambia_color( conf->readColorEntry("view_bg_color", mainwidget->browser()->colorFondo() ) );

#if QT_VERSION >= 220
	//cambiaAnimaciones( conf->readBoolEntry("animaciones", true) );
	setEfecto( conf->readNumEntry("efecto", 0 ) );
#endif

//#ifdef HAVE_KDELIBS3
	setDocked( conf->readBoolEntry("docked", false) );
#ifdef OPCION_AUTOPOPUP
	setAutopopup( conf->readBoolEntry("autopopup", true) );
#endif
//#endif

	setAppIconSmall( conf->readBoolEntry("small_icon", false) );

	conf->setGroup("Toolbar");
	changeSizeToolbar( conf->readBoolEntry("grande", true ) );
	leeToolbars();

	conf->setGroup("Hide_widgets");
	ocultaToolbar( conf->readBoolEntry("toolbar", false ) );
	ocultaMenu( conf->readBoolEntry("menu", false ) );
	ocultaStatusBar( conf->readBoolEntry("statusbar", false ) );

	recuperaEstilo();
	leeBookmarks();

	//Cargamos la configuracin de la miniwindow.
	MiniWindow::defaultWindow()->load(conf);

	//Leemos el charset a usar en los QSimpleBrowser
	//TODO: Poder configurar esto en el GUI (y poder grabarlo)
	conf->setGroup("Encodings");
	QString saving_charset= conf->readEntry( "saving", "ISO 8859-1");
	mainwidget->browser()->setCharset( saving_charset );
	MiniWindow::defaultWindow()->browser()->setCharset( saving_charset );

	selectDict( alias, true );
}


void QApplicationWindow::grabaConfig() {
	// Qt
	conf->setGroup("General");
	conf->writeEntry("diccionario", dict->getAlias().latin1() );
	conf->writeEntry("browser", web_browser.latin1() );
	conf->writeEntry("version", VERSION );
	conf->writeBoolEntry("internal_browser", use_internal_browser );
	conf->writeBoolEntry("debug", Salidas::getShowDebugMessages() );

	conf->setGroup("Options");
	conf->writeBoolEntry("formato", opciones->isItemChecked( conformato_item ) );

	conf->setGroup("Clipboard");
	conf->writeBoolEntry("active", preferencias->isItemChecked( clip_item) );
	conf->writeNumEntry("interval", mainwidget->getClipInterval() );

	conf->setGroup("Appearance");
	conf->writeSizeEntry("WSize", this->size() );
	conf->writeFontEntry("main_font", QApplication::font() );
	conf->writeFontEntry("view_font", mainwidget->getFontVista() );
	conf->writeColorEntry("view_bg_color", mainwidget->browser()->colorFondo() );
#if QT_VERSION >= 220
	//conf->writeBoolEntry("animaciones", preferencias->isItemChecked( animaciones_item ) );
	conf->writeNumEntry( "efecto", tipo_efecto );
#endif
#ifdef SMALL_ICON_OPTION
	conf->writeBoolEntry("small_icon", preferencias->isItemChecked( small_icon_item ) );
#endif

//#ifdef HAVE_KDELIBS3
	conf->writeBoolEntry("docked", preferencias->isItemChecked( docked_item ) );
#ifdef OPCION_AUTOPOPUP
	conf->writeBoolEntry("autopopup", auto_popup );
#endif
//#endif

	conf->setGroup("Toolbar");
	//conf->writeBoolEntry("grande", toolbar_prefs->isItemChecked( tb_big_item ) );
	conf->writeBoolEntry("grande", usesBigPixmaps() );
	grabaToolbars();

	conf->setGroup("Hide_widgets");
	//conf->writeBoolEntry("toolbar", oculta_menu->isItemChecked( tb_hidden_item ) );
	//conf->writeBoolEntry("menu", oculta_menu->isItemChecked( menu_hidden_item ) );
	//conf->writeBoolEntry("statusbar", oculta_menu->isItemChecked( statusbar_hidden_item ) );
	conf->writeBoolEntry("toolbar", !tb->isVisibleTo(this) );
	conf->writeBoolEntry("menu", !menuBar()->isVisibleTo(this) );
	conf->writeBoolEntry("statusbar", !statusBar()->isVisibleTo(this) );

	conf->setGroup("Encodings");
	conf->writeEntry( "saving", mainwidget->browser()->getCharset().latin1() );

	grabaEstilo();
	grabaBookmarks();

	//Grabamos la configuracin de la miniwindow.
	MiniWindow::defaultWindow()->save(conf);

	conf->sync();
}


void QApplicationWindow::leeToolbars() {
#if QT_VERSION >= 220
	ToolBarDock dock;
	int index, extraOffset;
	bool nl;

	conf->setGroup("Toolbar/tb");
	getLocation( tb, dock, index, nl, extraOffset );

	dock= (ToolBarDock) conf->readNumEntry( "dock", (int) dock );
	index= conf->readNumEntry( "index", index );
	nl= conf->readBoolEntry( "nl", nl );
	extraOffset= conf->readNumEntry( "extraoffset", extraOffset );

	moveToolBar( tb, dock, nl, index, extraOffset );

#ifdef SEPARATE_TOOLBAR
	conf->setGroup("Toolbar/controles");
	getLocation( controles, dock, index, nl, extraOffset );

	dock= (ToolBarDock) conf->readNumEntry( "dock", (int) dock );
	index= conf->readNumEntry( "index", index );
	nl= conf->readBoolEntry( "nl", nl );
	extraOffset= conf->readNumEntry( "extraoffset", extraOffset );

	moveToolBar( controles, dock, nl, index, extraOffset );
#endif
#endif
}

void QApplicationWindow::grabaToolbars() {
#if QT_VERSION >= 220
	ToolBarDock dock;
	int index, extraOffset;
	bool nl;

	conf->setGroup("Toolbar/tb");

	getLocation( tb, dock, index, nl, extraOffset );

	conf->writeNumEntry( "dock", (int) dock );
	conf->writeNumEntry( "index", index );
	conf->writeBoolEntry( "nl", nl );
	conf->writeNumEntry( "extraoffset", extraOffset );

#ifdef SEPARATE_TOOLBAR
	conf->setGroup("Toolbar/controles");

	getLocation( controles, dock, index, nl, extraOffset );

	conf->writeNumEntry( "dock", (int) dock );
	conf->writeNumEntry( "index", index );
	conf->writeBoolEntry( "nl", nl );
	conf->writeNumEntry( "extraoffset", extraOffset );
#endif
#endif
}


#ifdef HAVE_KDELIBS3
#include "KApplicationWindow.moc.cpp"
#else
#include "QApplicationWindow.moc.cpp"
#endif

