/*  Wordtrans, front-end for several dictionaries, for the Qt toolkit.
    Copyright (C) 2000-2004 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/**********************************************************************

	--- Qt Architect generated file ---

	File: QADictPrefs.cpp
	Last generated: Sat Nov 11 16:25:03 2000

 *********************************************************************/

#include "dictPrefs.h"
#include "qdialogos.h"
#include <qfiledialog.h>
#include <qfile.h>
#include <qfileinfo.h>
#include "qfunciones.h"
#include <qstringlist.h>
#include <qfile.h>

#include "dictPrefsData.cpp"
#include "dictPrefsData.moc.cpp"


QString DictPrefs::last_dir;

DictPrefs::DictPrefs
(
	QDictDiccionario *dictionary, bool nuevo,
	QWidget* parent,
	const char* name
)
	:
	DictPrefsData( parent, name )
{
	dict=dictionary;
	nuevo_dict=nuevo;

	alias->setText( dict->getAlias() );
	server->setText( dict->getServidor() );
	port->setText( dict->getPuerto() );

	utf8->setChecked(dict->getUTF8() );

	idioma1->setText( dict->getIdioma1() );
	idioma2->setText( dict->getIdioma2() );

	icono1->setText("");
	icono2->setText("");

	fichero_icono1=dict->getIconoIdioma1();
	ico1.load( fichero_icono1 );
	fichero_icono2=dict->getIconoIdioma2();
	ico2.load( fichero_icono2 );

	icono1->setPixmap( ico1 );
	icono2->setPixmap( ico2 );

	actualiza_combos();

	if (last_dir.isEmpty()) last_dir="/usr/share/wordtrans/";

	alias->setFocus();
}


DictPrefs::~DictPrefs()
{
	debug("Destruyendo DictPrefs");
}

bool DictPrefs::aceptar() {
	QString s_alias=alias->text();

	if (s_alias.isEmpty()) {
		Dialogos::mensaje( this, _("Error: wrong alias"),  
				 _("The alias will be used as the file name.\n"
				 "Please introduce a right one.") );
		return false;
	}

	if (!valida_servidor_y_puerto()) return false;

	dict->setAlias( alias->text() );
	dict->setServidor( server->text() );
	dict->setPuerto( port->text() );
	dict->setDatabase( database->currentText() );
	dict->setEstrategia( strategy->currentText() );
	dict->setIdioma1( idioma1->text() );
	dict->setIdioma2( idioma2->text() );

	dict->setUTF8( utf8->isChecked() );

	if (nuevo_dict) {
		QString fichero;
		fichero += qNomPersonal(".wordtrans/");
		fichero += s_alias;
		fichero += ".dconf";

		QFile f( fichero );
        if (f.exists()) {
			QString s= _("File %1 already exists.\nPlease change the alias.")
					.arg(fichero);
			Dialogos::mensaje( this, _("Error: file exists"), s );
			return false;
		}

		dict->setFileName(fichero);
	}

	dict->setIconoIdioma1( fichero_icono1 );
	dict->setIconoIdioma2( fichero_icono2 );

	return true;
}

bool DictPrefs::valida_servidor_y_puerto() {
	if ( !QDictDiccionario::esValidoServidor(server->text()) ) {
		Dialogos::mensaje( this, _("Error"), _("Server no valid") );
		return false;
	}

	if ( !QDictDiccionario::esValidoPuerto(port->text()) ) {
		Dialogos::mensaje( this, _("Error"), _("Port no valid") );
		return false;
	}

	return true;
}

//void DictPrefs::cancelar() {
	//done(2);
//}

void DictPrefs::actualiza_combos() {
	if (!valida_servidor_y_puerto()) return;

	QString old_servidor= dict->getServidor();
	QString old_puerto= dict->getPuerto();

	dict->setServidor( server->text() );
	dict->setPuerto( port->text() );

	database->clear();
	database->insertItem("*");
	database->insertStringList( dict->getAllDatabases() );
	seleccionaItem( database, dict->getDatabase() );

	strategy->clear();
	strategy->insertItem(".");
	strategy->insertStringList( dict->getAllStrategies() );
	seleccionaItem( strategy, dict->getEstrategia() );

	//Volvemos a dejar el servidor y el puerto tal como estaban
	//por si el usuario al final cancela.

	dict->setServidor( old_servidor );
	dict->setPuerto( old_puerto );
}

void DictPrefs::load_icono1() {
	QString fileName = Dialogos::cargarIcono(last_dir,"*.xpm *.png",this);
	if ( fileName.isNull() ) return;

	fichero_icono1=fileName;
	ico1.load( fichero_icono1 );
	icono1->setPixmap(ico1);

	QFileInfo fi( fileName );
	last_dir = fi.dirPath( true );
}

void DictPrefs::load_icono2() {
	QString fileName = Dialogos::cargarIcono(last_dir,"*.xpm *.png",this);
	if ( fileName.isNull() ) return;

	fichero_icono2=fileName;
	ico2.load( fichero_icono2 );
	icono2->setPixmap(ico2);

	QFileInfo fi( fileName );
	last_dir = fi.dirPath( true );
}

#include "dictPrefs.moc.cpp"

